/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeToggleSwitch;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeDescriptionButton
extends JPanel
implements BreezeButtonInterface {
    private final BreezeToggleSwitch breezeSwitch;
    private final JLabel descriptionLabel;

    public BreezeDescriptionButton() {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setFont(new Font("Tahoma", 0, 14));
        this.descriptionLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.breezeSwitch = new BreezeToggleSwitch();
        this.breezeSwitch.setIcon(ImageHelper.getResourceIcon("toggleOff", false));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.breezeSwitch, gridBagConstraints);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.breezeSwitch.addMouseListener(mouseListener);
    }

    public String getDesc() {
        return this.breezeSwitch.getDesc();
    }

    public String getDescription() {
        return this.descriptionLabel.getText();
    }

    public String getText() {
        return this.breezeSwitch.getText();
    }

    @Override
    public boolean isEnabled() {
        return this.breezeSwitch.isEnabled();
    }

    @Override
    public void setBackground(Color color) {
        if (this.breezeSwitch != null) {
            this.breezeSwitch.setBackground(color);
        }
    }

    public void setDesc(String string) {
        this.breezeSwitch.setDesc(string);
    }

    public void setDescForeground(Color color) {
        this.breezeSwitch.setDescForegroundReal(color);
    }

    public void setDescription(String string) {
        this.descriptionLabel.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.breezeSwitch.setEnabled(bl);
    }

    public void setText(String string) {
        this.breezeSwitch.setText(string);
    }

    public void setToggled(boolean bl, boolean bl2) {
        this.setToggled(bl);
        this.setEnabled(bl2);
    }

    public void setToggled(boolean bl) {
        this.breezeSwitch.setToggled(bl);
    }

    public boolean isToggled() {
        return this.breezeSwitch.isToggled();
    }

    @Override
    public void doClick() {
        this.breezeSwitch.doClick();
    }
}

