/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class BreezeDesktopPane
extends JDesktopPane {
    private LayoutMode layoutMode = LayoutMode.VERTICAL_SPLIT;
    private int upperPercent = 50;
    private BreezeFrame lastResizedFrame;
    private int globalFrameCounter = 0;
    private boolean internalLayoutChange = false;
    private final Timer layoutTimer;

    public BreezeDesktopPane() {
        this.setBackground(Color.LIGHT_GRAY);
        this.layoutTimer = new Timer(150, actionEvent -> {
            this.revalidate();
            this.repaint();
        });
        this.layoutTimer.setRepeats(false);
    }

    @Override
    public void add(Component component, Object object) {
        if (component instanceof BreezeFrame) {
            BreezeFrame breezeFrame = (BreezeFrame)component;
            if (breezeFrame.logicalIndex == -1) {
                breezeFrame.logicalIndex = this.globalFrameCounter++;
            }
        }
        super.add(component, object);
    }

    @Override
    public Component add(Component component) {
        if (component instanceof BreezeFrame) {
            BreezeFrame breezeFrame = (BreezeFrame)component;
            if (breezeFrame.logicalIndex == -1) {
                breezeFrame.logicalIndex = this.globalFrameCounter++;
            }
        }
        return super.add(component);
    }

    public void setLayoutMode(LayoutMode layoutMode) {
        this.layoutMode = layoutMode;
        this.revalidate();
        this.repaint();
    }

    public LayoutMode getLayoutMode() {
        return this.layoutMode;
    }

    private int clampPercent(int n) {
        return Math.max(10, Math.min(90, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void doLayout() {
        if (this.internalLayoutChange) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n == 0 || n2 == 0) {
            return;
        }
        ArrayList<BreezeFrame> arrayList = new ArrayList<BreezeFrame>();
        for (Component component : this.getComponents()) {
            BreezeFrame breezeFrame2;
            if (!(component instanceof BreezeFrame) || (breezeFrame2 = (BreezeFrame)component).isDetached() || !breezeFrame2.isVisible()) continue;
            arrayList.add(breezeFrame2);
        }
        Object var5_6 = null;
        for (BreezeFrame breezeFrame3 : arrayList) {
            if (!breezeFrame3.isMaximized()) continue;
            BreezeFrame breezeFrame4 = breezeFrame3;
            break;
        }
        this.internalLayoutChange = true;
        try {
            Rectangle rectangle;
            Rectangle rectangle2;
            int n3;
            void var5_8;
            if (var5_8 != null) {
                var5_8.setBounds(0, 0, n, n2);
                for (BreezeFrame breezeFrame5 : arrayList) {
                    if (breezeFrame5 == var5_8) continue;
                    breezeFrame5.setBounds(-10000, -10000, 0, 0);
                }
                return;
            }
            Iterator<BreezeFrame> iterator = new ArrayList();
            ArrayList<BreezeFrame> arrayList2 = new ArrayList<BreezeFrame>();
            for (BreezeFrame breezeFrame2 : arrayList) {
                if (breezeFrame2.getDockSide() == DockSide.UPPER) {
                    iterator.add(breezeFrame2);
                    continue;
                }
                arrayList2.add(breezeFrame2);
            }
            Comparator<BreezeFrame> comparator = Comparator.comparingInt(breezeFrame -> breezeFrame.logicalIndex);
            iterator.sort(comparator);
            arrayList2.sort(comparator);
            if (this.lastResizedFrame != null && !iterator.isEmpty()) {
                boolean bl;
                boolean bl2 = bl = this.lastResizedFrame == iterator.get(iterator.size() - 1);
                if (bl && this.lastResizedFrame.getDockSide() == DockSide.UPPER) {
                    if (this.layoutMode == LayoutMode.VERTICAL_SPLIT) {
                        n3 = this.lastResizedFrame.getX() + this.lastResizedFrame.getWidth();
                        this.upperPercent = this.clampPercent((int)Math.round(100.0 * (double)n3 / (double)n));
                    } else {
                        n3 = this.lastResizedFrame.getY() + this.lastResizedFrame.getHeight();
                        this.upperPercent = this.clampPercent((int)Math.round(100.0 * (double)n3 / (double)n2));
                    }
                }
            }
            if (this.layoutMode == LayoutMode.VERTICAL_SPLIT) {
                int n4 = n * this.upperPercent / 100;
                n3 = n - n4;
                rectangle2 = new Rectangle(0, 0, n4, n2);
                rectangle = new Rectangle(n4, 0, n3, n2);
            } else {
                int n5 = n2 * this.upperPercent / 100;
                n3 = n2 - n5;
                rectangle2 = new Rectangle(0, 0, n, n5);
                rectangle = new Rectangle(0, n5, n, n3);
            }
            boolean bl = this.layoutMode == LayoutMode.VERTICAL_SPLIT;
            boolean bl3 = this.layoutMode == LayoutMode.HORIZONTAL_SPLIT;
            this.layoutGroup((List<BreezeFrame>)((Object)iterator), rectangle2, bl);
            this.layoutGroup(arrayList2, rectangle, bl3);
            this.lastResizedFrame = null;
        }
        finally {
            this.internalLayoutChange = false;
        }
    }

    private void layoutGroup(List<BreezeFrame> list, Rectangle rectangle, boolean bl) {
        int n;
        int n2;
        if (list.isEmpty()) {
            return;
        }
        ArrayList<BreezeFrame> arrayList = new ArrayList<BreezeFrame>();
        ArrayList<BreezeFrame> arrayList2 = new ArrayList<BreezeFrame>();
        for (BreezeFrame breezeFrame : list) {
            if (breezeFrame.isMinimized()) {
                arrayList.add(breezeFrame);
                continue;
            }
            arrayList2.add(breezeFrame);
        }
        int n3 = list.get(0).getToolbarHeight();
        int n4 = arrayList.size() * n3;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = rectangle.width;
        int n8 = Math.max(0, rectangle.height - n4);
        int n9 = n6 + n8;
        for (BreezeFrame breezeFrame : arrayList) {
            breezeFrame.setBounds(n5, n9, n7, n3);
            n9 += n3;
        }
        if (arrayList2.isEmpty()) {
            return;
        }
        long l = bl ? (long)n7 : (long)n8;
        boolean bl2 = this.lastResizedFrame != null && arrayList2.contains(this.lastResizedFrame);
        for (BreezeFrame breezeFrame : arrayList2) {
            if (breezeFrame.cachedSize > 0) continue;
            breezeFrame.cachedSize = (int)(l / (long)arrayList2.size());
        }
        if (bl2) {
            int n10 = arrayList2.indexOf(this.lastResizedFrame);
            int n11 = bl ? this.lastResizedFrame.getWidth() : this.lastResizedFrame.getHeight();
            int n12 = n11 - this.lastResizedFrame.cachedSize;
            this.lastResizedFrame.cachedSize = n11;
            if (arrayList2.size() > 1) {
                if (n10 < arrayList2.size() - 1) {
                    BreezeFrame object = (BreezeFrame)arrayList2.get(n10 + 1);
                    object.cachedSize -= n12;
                    if (object.cachedSize < 50) {
                        n2 = 50 - object.cachedSize;
                        object.cachedSize = 50;
                        this.lastResizedFrame.cachedSize -= n2;
                    }
                } else {
                    BreezeFrame breezeFrame = (BreezeFrame)arrayList2.get(n10 - 1);
                    breezeFrame.cachedSize -= n12;
                    if (breezeFrame.cachedSize < 50) {
                        n2 = 50 - breezeFrame.cachedSize;
                        breezeFrame.cachedSize = 50;
                        this.lastResizedFrame.cachedSize -= n2;
                    }
                }
            }
        }
        long l2 = 0L;
        for (BreezeFrame breezeFrame : arrayList2) {
            l2 += (long)breezeFrame.cachedSize;
        }
        if (l2 != l) {
            long l3 = l - l2;
            if (!bl2) {
                if (l2 == 0L) {
                    l2 = 1L;
                }
                n2 = 0;
                for (n = 0; n < arrayList2.size(); ++n) {
                    BreezeFrame breezeFrame = (BreezeFrame)arrayList2.get(n);
                    double d = (double)breezeFrame.cachedSize / (double)l2;
                    var25_42 = (int)Math.round((double)l * d);
                    if (n == arrayList2.size() - 1) {
                        var25_42 = (int)l - n2;
                    }
                    breezeFrame.cachedSize = Math.max(50, var25_42);
                    n2 += breezeFrame.cachedSize;
                }
            } else if (l2 != 0L) {
                double d = (double)l / (double)l2;
                int n10 = 0;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    BreezeFrame breezeFrame = (BreezeFrame)arrayList2.get(i);
                    var25_42 = (int)((double)breezeFrame.cachedSize * d);
                    if (i == arrayList2.size() - 1) {
                        var25_42 = (int)l - n10;
                    }
                    breezeFrame.cachedSize = var25_42;
                    n10 += var25_42;
                }
            }
        }
        int n14 = bl ? n5 : n6;
        for (BreezeFrame breezeFrame : arrayList2) {
            n = breezeFrame.cachedSize;
            if (bl) {
                breezeFrame.setBounds(n14, n6, n, n8);
                n14 += n;
                continue;
            }
            breezeFrame.setBounds(n5, n14, n7, n);
            n14 += n;
        }
    }

    public static enum LayoutMode {
        VERTICAL_SPLIT,
        HORIZONTAL_SPLIT;

    }

    public class BreezeFrame
    extends JInternalFrame {
        private final DockSide dockSide;
        private final JComponent content;
        private final JPanel toolbar;
        public int logicalIndex;
        public int cachedSize;
        private boolean minimized;
        private boolean maximized;
        private boolean detached;
        private Rectangle normalBounds;
        private JButton btnMinimize;
        private JButton btnMaximize;
        private JButton btnRemove;
        private JButton btnDetach;
        private JDialog floatingDialog;

        public BreezeFrame(String string, DockSide dockSide, JComponent jComponent) {
            super("", true, true, true, true);
            this.logicalIndex = -1;
            this.cachedSize = -1;
            this.minimized = false;
            this.maximized = false;
            this.detached = false;
            this.normalBounds = null;
            this.dockSide = dockSide;
            this.content = jComponent;
            BasicInternalFrameUI basicInternalFrameUI = (BasicInternalFrameUI)this.getUI();
            basicInternalFrameUI.setNorthPane(null);
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
            this.setLayout(new BorderLayout());
            this.toolbar = this.createToolbar(string);
            this.add((Component)this.toolbar, "North");
            this.add((Component)jComponent, "Center");
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    BreezeFrame.this.handleInteraction();
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    BreezeFrame.this.handleInteraction();
                }
            });
        }

        private void handleInteraction() {
            if (!this.detached && !this.maximized && !BreezeDesktopPane.this.internalLayoutChange && this.isVisible()) {
                BreezeDesktopPane.this.lastResizedFrame = this;
                BreezeDesktopPane.this.layoutTimer.restart();
            }
        }

        private JPanel createToolbar(String string) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.LIGHT_GRAY);
            jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(jLabel.getFont().deriveFont(1));
            JPanel jPanel2 = new JPanel(new FlowLayout(2, 2, 0));
            jPanel2.setOpaque(false);
            this.btnMinimize = this.createToolButton("_");
            this.btnMaximize = this.createToolButton("[]");
            this.btnDetach = this.createToolButton("^");
            this.btnRemove = this.createToolButton("X");
            this.btnMinimize.addActionListener(actionEvent -> this.toggleMinimize());
            this.btnMaximize.addActionListener(actionEvent -> this.toggleMaximize());
            this.btnRemove.addActionListener(actionEvent -> this.removeFrame());
            this.btnDetach.addActionListener(actionEvent -> {
                if (!this.detached) {
                    this.detachToDialog();
                } else {
                    this.attachBackToDesktop();
                }
            });
            jPanel2.add(this.btnMinimize);
            jPanel2.add(this.btnMaximize);
            jPanel2.add(this.btnDetach);
            jPanel2.add(this.btnRemove);
            jPanel.add((Component)jLabel, "West");
            jPanel.add((Component)jPanel2, "East");
            return jPanel;
        }

        private JButton createToolButton(String string) {
            JButton jButton = new JButton(string);
            jButton.setMargin(new Insets(1, 4, 1, 4));
            jButton.setFocusable(false);
            return jButton;
        }

        public DockSide getDockSide() {
            return this.dockSide;
        }

        public boolean isMinimized() {
            return this.minimized;
        }

        public boolean isMaximized() {
            return this.maximized;
        }

        public boolean isDetached() {
            return this.detached;
        }

        public int getToolbarHeight() {
            return this.toolbar.getPreferredSize().height;
        }

        private void toggleMinimize() {
            if (this.detached) {
                return;
            }
            if (this.minimized) {
                this.minimized = false;
                this.btnMinimize.setText("_");
                this.content.setVisible(true);
            } else {
                this.minimized = true;
                this.maximized = false;
                this.btnMinimize.setText("+");
                this.btnMaximize.setText("[]");
                this.content.setVisible(false);
            }
            this.revalidateDesktop();
        }

        private void toggleMaximize() {
            if (this.detached) {
                return;
            }
            if (this.maximized) {
                this.maximized = false;
                this.btnMaximize.setText("[]");
            } else {
                this.minimized = false;
                this.content.setVisible(true);
                this.btnMinimize.setText("_");
                this.maximized = true;
                this.normalBounds = this.getBounds();
                this.btnMaximize.setText("][");
            }
            this.revalidateDesktop();
        }

        private void removeFrame() {
            if (this.detached && this.floatingDialog != null) {
                this.floatingDialog.dispose();
            }
            try {
                this.setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Container container = this.getParent();
            if (container != null) {
                container.remove(this);
                this.revalidateDesktop();
            }
        }

        private void detachToDialog() {
            if (this.detached) {
                return;
            }
            this.minimized = false;
            this.maximized = false;
            this.content.setVisible(true);
            this.remove(this.content);
            Window window = SwingUtilities.getWindowAncestor(BreezeDesktopPane.this);
            this.floatingDialog = new JDialog(window, this.getTitle());
            this.floatingDialog.setLayout(new BorderLayout());
            this.floatingDialog.add((Component)this.content, "Center");
            JButton jButton = new JButton("Move back to layout");
            jButton.addActionListener(actionEvent -> this.attachBackToDesktop());
            JPanel jPanel = new JPanel(new FlowLayout(2));
            jPanel.add(jButton);
            this.floatingDialog.add((Component)jPanel, "South");
            this.floatingDialog.setSize(400, 300);
            this.floatingDialog.setLocationRelativeTo(BreezeDesktopPane.this);
            this.floatingDialog.setDefaultCloseOperation(0);
            this.floatingDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    BreezeFrame.this.attachBackToDesktop();
                }
            });
            this.floatingDialog.setVisible(true);
            this.detached = true;
            this.setVisible(false);
            this.revalidateDesktop();
        }

        private void attachBackToDesktop() {
            if (!this.detached) {
                return;
            }
            if (this.floatingDialog != null) {
                this.floatingDialog.remove(this.content);
                this.floatingDialog.dispose();
                this.floatingDialog = null;
            }
            this.add((Component)this.content, "Center");
            this.detached = false;
            this.setVisible(true);
            if (this.getParent() == null) {
                BreezeDesktopPane.this.add(this);
            }
            this.revalidateDesktop();
        }

        private void revalidateDesktop() {
            BreezeDesktopPane.this.revalidate();
            BreezeDesktopPane.this.repaint();
        }
    }

    public static enum DockSide {
        UPPER,
        DOWN;

    }

    public static class DemoFrame
    extends JFrame {
        private final BreezeDesktopPane desktop = new BreezeDesktopPane();
        private int contourCounter = 1;
        private int spectralCounter = 1;

        public DemoFrame() {
            super("BreezeDesktopPane Demo");
            this.setContentPane(this.desktop);
            this.setSize(1200, 800);
            this.setDefaultCloseOperation(3);
            this.setLocationRelativeTo(null);
            this.addContour();
            this.addContour();
            this.addSpectral();
            this.addSpectral();
            this.addSpectral();
            this.setJMenuBar(this.createMenuBar());
        }

        private JMenuBar createMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("Layout");
            JMenuItem jMenuItem = new JMenuItem("Vertical Split (Contours Left)");
            jMenuItem.addActionListener(actionEvent -> this.desktop.setLayoutMode(LayoutMode.VERTICAL_SPLIT));
            JMenuItem jMenuItem2 = new JMenuItem("Horizontal Split (Contours Top)");
            jMenuItem2.addActionListener(actionEvent -> this.desktop.setLayoutMode(LayoutMode.HORIZONTAL_SPLIT));
            jMenu.add(jMenuItem);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Plots");
            JMenuItem jMenuItem3 = new JMenuItem("Add Contour (UPPER)");
            jMenuItem3.addActionListener(actionEvent -> this.addContour());
            JMenuItem jMenuItem4 = new JMenuItem("Add Spectral (DOWN)");
            jMenuItem4.addActionListener(actionEvent -> this.addSpectral());
            jMenu2.add(jMenuItem3);
            jMenu2.add(jMenuItem4);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            return jMenuBar;
        }

        private void addContour() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(new Color(100, 150, 220));
            jPanel.setLayout(new GridBagLayout());
            jPanel.add(new JLabel("Contour " + this.contourCounter));
            BreezeDesktopPane breezeDesktopPane = this.desktop;
            Objects.requireNonNull(breezeDesktopPane);
            BreezeFrame breezeFrame = breezeDesktopPane.new BreezeFrame("Contour " + this.contourCounter, DockSide.UPPER, jPanel);
            ++this.contourCounter;
            this.desktop.add(breezeFrame);
            breezeFrame.setVisible(true);
        }

        private void addSpectral() {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(new Color(120, 200, 120));
            jPanel.setLayout(new GridBagLayout());
            jPanel.add(new JLabel("Spectral " + this.spectralCounter));
            BreezeDesktopPane breezeDesktopPane = this.desktop;
            Objects.requireNonNull(breezeDesktopPane);
            BreezeFrame breezeFrame = breezeDesktopPane.new BreezeFrame("Spectral " + this.spectralCounter, DockSide.DOWN, jPanel);
            ++this.spectralCounter;
            this.desktop.add(breezeFrame);
            breezeFrame.setVisible(true);
        }

        public static void main(String[] stringArray) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            SwingUtilities.invokeLater(() -> new DemoFrame().setVisible(true));
        }
    }
}

