/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import lombok.Generated;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.AbstractBreezeTextPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.update.UpdateHelper;

public class BreezeEditorPane
extends AbstractBreezeTextPanel {
    private final JEditorPane editor;
    private final HTMLEditorKit kit;
    private LinkCallback linkCallback;
    private Object hoverHl;
    private String lastHtml = "";
    private final LayeredHighlighter.LayerPainter hoverPainter = new HoverUnderlinePainter();

    public BreezeEditorPane(String string) {
        this(string, null);
    }

    public BreezeEditorPane(String string, LinkCallback linkCallback) {
        this(string, linkCallback, true);
    }

    public BreezeEditorPane(String string, LinkCallback linkCallback, boolean bl) {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.linkCallback = linkCallback;
        this.editor = new JEditorPane();
        this.kit = new HTMLEditorKit();
        this.updateTheme();
        this.editor.setEditorKit(this.kit);
        this.editor.setContentType("text/html");
        this.editor.setEditable(false);
        this.editor.setCaretColor(new Color(0, 0, 0, 0));
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setUpdatePolicy(1);
        defaultCaret.setBlinkRate(0);
        defaultCaret.setVisible(false);
        defaultCaret.setSelectionVisible(false);
        this.editor.setCaret(defaultCaret);
        this.editor.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editor.setFont(new Font("Tahoma", 0, 16));
        this.editor.setBorder(BorderFactory.createEmptyBorder());
        this.editor.setText(string);
        this.editor.setHighlighter(new DefaultHighlighter());
        this.editor.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                Element element = hyperlinkEvent.getSourceElement();
                if (element != null) {
                    try {
                        int n = element.getStartOffset();
                        int n2 = element.getEndOffset();
                        this.hoverHl = this.editor.getHighlighter().addHighlight(n, n2, this.hoverPainter);
                    }
                    catch (Exception exception) {}
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
                if (this.hoverHl != null) {
                    this.editor.getHighlighter().removeHighlight(this.hoverHl);
                    this.hoverHl = null;
                }
            } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                boolean bl;
                boolean bl2 = bl = this.linkCallback != null && this.linkCallback.onLinkActivated(hyperlinkEvent);
                if (!bl && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(hyperlinkEvent.getURL().toURI());
                    }
                    catch (Exception exception) {
                        throw new ErrorHandler.MessageException("Could not open link: " + String.valueOf(hyperlinkEvent.getURL()), (Throwable)exception);
                    }
                }
            }
        });
        if (!bl) {
            this.add((Component)this.editor, "Center");
        } else {
            BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.editor, false);
            breezeScrollPane.setBorder(BorderFactory.createEmptyBorder());
            breezeScrollPane.getViewport().setOpaque(false);
            breezeScrollPane.setOpaque(false);
            this.add((Component)breezeScrollPane, "Center");
        }
    }

    public void updateTheme() {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        String string = BreezeColor.colorToHex(breezeTheme.getLinkForeground());
        String string2 = BreezeColor.colorToHex(breezeTheme.getLabelForegroundMoreDifuse());
        StyleSheet styleSheet = new StyleSheet();
        styleSheet.addRule("a { color:" + string + "; }");
        styleSheet.addRule("ul { margin-left:8px; padding-left:8px; list-style-type:disc; }");
        styleSheet.addRule("li { list-style-type:disc; }");
        styleSheet.addRule("span.expire { color: " + string2 + "; font-size: smaller; }");
        this.kit.setStyleSheet(styleSheet);
        HTMLDocument hTMLDocument = (HTMLDocument)this.kit.createDefaultDocument();
        hTMLDocument.putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        this.editor.setDocument(hTMLDocument);
        if (!this.lastHtml.isEmpty()) {
            this.editor.setText(this.lastHtml);
        }
        this.editor.setBackground(breezeTheme.getDialogBackground());
        this.editor.setForeground(breezeTheme.getLabelForeground());
        this.editor.repaint();
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.editor.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public String getText() {
        return this.editor.getText();
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.editor.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void requestFocusAndSelectAll() {
        this.editor.requestFocusInWindow();
    }

    @Override
    protected void setTextInComponent(String string) {
        this.lastHtml = string;
        this.editor.setText(string);
        this.editor.setCaretPosition(0);
    }

    public void setFontSize(int n) {
        this.editor.setFont(this.editor.getFont().deriveFont((float)n));
    }

    @Override
    public boolean supportMultipleLines() {
        return true;
    }

    static void main() {
        BreezeFrame breezeFrame = new BreezeFrame(UpdateHelper.Product.Breeze);
        breezeFrame.setDefaultCloseOperation(3);
        breezeFrame.setSize(900, 700);
        breezeFrame.setLocationRelativeTo(null);
        breezeFrame.setVisible(true);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<p>Test</p>");
        stringBuilder.append("<ul>");
        stringBuilder.append("<li>1</li>");
        stringBuilder.append("<li>2</li>");
        stringBuilder.append("</ul>");
        stringBuilder.append("<a href=\"https://www.google.com\">Browser link");
        stringBuilder.append("<img src='");
        stringBuilder.append(BreezeEditorPane.class.getResource("/images/material/open_in_browser.png").toExternalForm());
        stringBuilder.append("' width='16' height='16'/>");
        stringBuilder.append("</a>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<a href=\"breeze://print\">Breeze custom action");
        stringBuilder.append("<img src='");
        stringBuilder.append(BreezeEditorPane.class.getResource("/images/material/open_in_new.png").toExternalForm());
        stringBuilder.append("' width='16' height='16'/>");
        stringBuilder.append("</a>");
        stringBuilder.append("</html>");
        breezeFrame.add(new BreezeEditorPane(stringBuilder.toString(), hyperlinkEvent -> {
            System.out.println(hyperlinkEvent.getDescription());
            return hyperlinkEvent.getDescription().startsWith("breeze://");
        }));
    }

    @Generated
    public void setLinkCallback(LinkCallback linkCallback) {
        this.linkCallback = linkCallback;
    }

    public static interface LinkCallback {
        public boolean onLinkActivated(HyperlinkEvent var1);
    }

    private static final class HoverUnderlinePainter
    extends LayeredHighlighter.LayerPainter {
        private HoverUnderlinePainter() {
        }

        @Override
        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            try {
                int n3;
                Rectangle rectangle;
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                if (shape2 == null) {
                    return null;
                }
                Rectangle rectangle2 = shape2 instanceof Rectangle ? (rectangle = (Rectangle)shape2) : shape2.getBounds();
                boolean bl = false;
                Object object = jTextComponent.getDocument();
                if (object instanceof StyledDocument) {
                    StyledDocument styledDocument = (StyledDocument)object;
                    object = styledDocument.getCharacterElement(n);
                    AttributeSet attributeSet = object.getAttributes();
                    bl = HTML.Tag.IMG.equals(attributeSet.getAttribute(StyleConstants.NameAttribute));
                }
                if (bl) {
                    n3 = rectangle2.y + rectangle2.height;
                } else {
                    object = jTextComponent.getFontMetrics(jTextComponent.getFont());
                    n3 = rectangle2.y + rectangle2.height - ((FontMetrics)object).getDescent() / 2;
                }
                object = graphics.getColor();
                graphics.setColor(BreezeTheme.getInstance().getLinkForeground());
                graphics.drawLine(rectangle2.x, n3, rectangle2.x + rectangle2.width, n3);
                graphics.setColor((Color)object);
                return shape2 instanceof Rectangle ? rectangle2 : shape2;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

