/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.map.common.BrowserLauncher;

public class BreezeExternalLinkPanel
extends JPanel {
    private URI helpSite = null;
    private final BreezeButton helpCompressLink;

    public BreezeExternalLinkPanel(JComponent jComponent, String string) {
        this(jComponent, string, false, false);
    }

    public BreezeExternalLinkPanel(JComponent jComponent, String string, boolean bl) {
        this(jComponent, string, bl, false);
    }

    public BreezeExternalLinkPanel(JComponent jComponent, String string, boolean bl, boolean bl2) {
        this(jComponent, BreezeExternalLinkPanel.toUriOrNull("https://help.prediktera.com/" + (bl ? "breeze-runtime/" : "breeze/") + string), bl2, "help");
    }

    public BreezeExternalLinkPanel(JComponent jComponent, URI uRI, boolean bl, String string) {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(0, 0, 0, 0), false);
        if (bl) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
        }
        this.add((Component)jComponent, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = GridBagHelper.create(1, new Insets(0, 15, 0, 0), !bl);
        gridBagConstraints2.anchor = 18;
        this.helpCompressLink = EntryMainHelper.createButton("", string, () -> BrowserLauncher.open((URI)this.helpSite));
        this.helpCompressLink.setToolTipText("Open in browser");
        this.add((Component)this.helpCompressLink, gridBagConstraints2);
        this.setHelpSite(uRI);
    }

    public void setHelpSite(String string) {
        try {
            this.helpSite = new URI(string);
            this.helpCompressLink.setVisible(true);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.helpCompressLink.setVisible(false);
        }
    }

    public void setHelpSite(URI uRI) {
        this.helpSite = uRI;
        this.helpCompressLink.setVisible(uRI != null);
    }

    private static URI toUriOrNull(String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }
}

