/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JPanel;

public class BreezeGradientPanel
extends JPanel {
    private boolean round = false;

    public BreezeGradientPanel() {
        super(new GridBagLayout());
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Paint paint = null;
        if (this.round) {
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            graphics2D2.setComposite(AlphaComposite.Clear);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.setComposite(AlphaComposite.Src);
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setColor(Color.WHITE);
            graphics2D2.fillOval(0, 0, n - 1, n2 - 1);
            paint = new RoundGradientPaint(this, n / 2, n2 / 2, this.getBackground(), n2 / 3, this.getForeground());
            graphics2D2.setComposite(AlphaComposite.SrcAtop);
            graphics2D2.setPaint(paint);
            graphics2D2.fillRect(0, 0, n, n2);
            graphics2D2.dispose();
            graphics.drawImage(bufferedImage, 0, 0, null);
        } else {
            paint = new GradientPaint(0.0f, 0.0f, this.getForeground(), 0.0f, n2, this.getBackground(), false);
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }

    private class RoundGradientPaint
    implements Paint {
        protected Point2D point;
        protected Point2D mRadius;
        protected Color mPointColor;
        protected Color mBackgroundColor;

        public RoundGradientPaint(BreezeGradientPanel breezeGradientPanel, double d, double d2, Color color, int n, Color color2) {
            if (n <= 0) {
                n = 1;
            }
            this.point = new Point2D.Double(d, d2);
            this.mPointColor = color;
            this.mRadius = new Point(n, n);
            this.mBackgroundColor = color2;
        }

        @Override
        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            Point2D point2D = affineTransform.transform(this.point, null);
            Point2D point2D2 = affineTransform.deltaTransform(this.mRadius, null);
            return new RoundGradientContext(point2D, this.mPointColor, point2D2, this.mBackgroundColor);
        }

        @Override
        public int getTransparency() {
            int n;
            int n2 = this.mPointColor.getAlpha();
            return (n2 & (n = this.mBackgroundColor.getAlpha())) == 255 ? 1 : 3;
        }
    }

    public static class RoundGradientContext
    implements PaintContext {
        protected Point2D mPoint;
        protected Point2D mRadius;
        protected Color color1;
        protected Color color2;

        public RoundGradientContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
            this.mPoint = point2D;
            this.color1 = color;
            this.mRadius = point2D2;
            this.color2 = color2;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d;
                    double d2 = this.mPoint.distance(n + j, n2 + i);
                    double d3 = d2 / (d = this.mRadius.distance(0.0, 0.0));
                    if (d3 > 1.0) {
                        d3 = 1.0;
                    }
                    int n5 = (i * n3 + j) * 4;
                    nArray[n5 + 0] = (int)((double)this.color1.getRed() + d3 * (double)(this.color2.getRed() - this.color1.getRed()));
                    nArray[n5 + 1] = (int)((double)this.color1.getGreen() + d3 * (double)(this.color2.getGreen() - this.color1.getGreen()));
                    nArray[n5 + 2] = (int)((double)this.color1.getBlue() + d3 * (double)(this.color2.getBlue() - this.color1.getBlue()));
                    nArray[n5 + 3] = (int)((double)this.color1.getAlpha() + d3 * (double)(this.color2.getAlpha() - this.color1.getAlpha()));
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

