/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.text.DefaultCaret;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeInfoPanel
extends BreezePanel {
    private final JLabel typeLabel;
    private final JTextArea messageArea;

    public BreezeInfoPanel() {
        this(InfoType.Note, "");
    }

    public BreezeInfoPanel(boolean bl) {
        this(InfoType.Note, "", InfoType.Note.name(), bl);
    }

    public BreezeInfoPanel(InfoType infoType, String string) {
        this(infoType, string, infoType.name(), true);
    }

    public BreezeInfoPanel(InfoType infoType, String string, boolean bl) {
        this(infoType, string, infoType.name(), bl);
    }

    public BreezeInfoPanel(InfoType infoType, String string, String string2) {
        this(infoType, string, string2, true);
    }

    public BreezeInfoPanel(InfoType infoType, String string, String string2, boolean bl) {
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.typeLabel = new BreezeLabel("", true, 14);
        this.messageArea = this.createMessageArea(breezeTheme);
        JButton jButton = this.createCloseButton(breezeTheme);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.typeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 2, 2);
        this.add((Component)this.messageArea, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        this.add((Component)jButton, gridBagConstraints);
        jButton.setVisible(bl);
        this.updatePanel(infoType, string, string2);
    }

    private JTextArea createMessageArea(BreezeTheme breezeTheme) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFont(new Font("Tahoma", 0, 14));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setForeground(breezeTheme.getLabelForeground());
        jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        DefaultCaret defaultCaret = (DefaultCaret)jTextArea.getCaret();
        defaultCaret.setUpdatePolicy(1);
        jTextArea.setCaretColor(new Color(0, 0, 0, 0));
        jTextArea.setRows(2);
        return jTextArea;
    }

    private JButton createCloseButton(BreezeTheme breezeTheme) {
        final JButton jButton = new JButton("x");
        jButton.setFont(new Font("DejaVu Sans", 1, 12));
        jButton.setForeground(breezeTheme.getLabelForegroundMoreDifuse());
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setContentAreaFilled(false);
        jButton.setFocusPainted(false);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        jButton.setToolTipText("Close panel");
        final Color color = breezeTheme.getLabelForegroundMoreDifuse();
        final Color color2 = breezeTheme.getLabelForeground();
        jButton.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jButton.setForeground(color2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jButton.setForeground(color);
            }
        });
        jButton.addActionListener(actionEvent -> this.setVisible(false));
        return jButton;
    }

    private MatteBorder createBorder(InfoType infoType) {
        return new MatteBorder(0, 5, 0, 0, infoType.color);
    }

    public void updatePanel(InfoType infoType, String string) {
        this.updatePanel(infoType, string, infoType.name());
    }

    public void updatePanel(InfoType infoType, String string, String string2) {
        this.typeLabel.setIcon(ImageHelper.tintIconWithColor(ImageHelper.getResourceIcon(infoType.icon), infoType.color));
        this.typeLabel.setForeground(infoType.color);
        this.typeLabel.setText(string2);
        this.typeLabel.setToolTipText(string2);
        this.messageArea.setText(string);
        this.setBorder(BorderFactory.createCompoundBorder(this.createBorder(infoType), BorderFactory.createEmptyBorder(8, 10, 8, 5)));
        this.revalidate();
        this.repaint();
    }

    public void setText(String string) {
        this.messageArea.setText(string);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Info Panels Demo");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setLayout(new BoxLayout(jFrame.getContentPane(), 1));
            jFrame.setSize(400, 600);
            jFrame.add(new BreezeInfoPanel(InfoType.Note, "Useful information that users should know, even when skimming content."));
            jFrame.add(new BreezeInfoPanel(InfoType.Tip, "Helpful advice for doing things better or more easily."));
            jFrame.add(new BreezeInfoPanel(InfoType.Important, "Key information users need to know to achieve their goal."));
            jFrame.add(new BreezeInfoPanel(InfoType.Warning, "Urgent info that needs immediate user attention to avoid problems. No close.", false));
            jFrame.add(new BreezeInfoPanel(InfoType.Error, "Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions. Advises about risks or negative outcomes of certain actions."));
            jFrame.setVisible(true);
        });
    }

    public static enum InfoType {
        Note("material/info", BreezeTheme.getInstance().getNoteColor()),
        Tip("material/lightbulb", BreezeTheme.getInstance().getTipColor()),
        Important("material/report", BreezeTheme.getInstance().getImportantColor()),
        Warning("material/warning", BreezeTheme.getInstance().getWarningColor()),
        Error("material/dangerous", BreezeTheme.getInstance().getCautionColor());

        private final String icon;
        private final Color color;

        @Generated
        private InfoType(String string2, Color color) {
            this.icon = string2;
            this.color = color;
        }
    }
}

