/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyListener;
import java.util.Optional;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeFieldInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;
import se.prediktera.map.common.NiceDataFormat;

public class BreezeInputField
extends JPanel
implements BreezeFieldInterface {
    private final BreezeLabel descLabel = new BreezeLabel("Name");
    private final BreezeLabel unitLabel = new BreezeLabel("mm");
    private final BreezeLabel usageLabel = new BreezeLabel("", false, 12);
    private final BreezeTextField textField = new BreezeTextField();
    private BreezeInputFieldHelper.Format format = BreezeInputFieldHelper.Format.TwoRows;
    private String description;

    public BreezeInputField() {
        BreezeInputFieldHelper.format(this, this.descLabel, this.textField, this.unitLabel, this.usageLabel, this.format);
    }

    public BreezeInputField(String string, String string2, String string3) {
        this(string, string2, string3, BreezeInputFieldHelper.Format.TwoRows);
    }

    public BreezeInputField(String string, double d, String string2) {
        this();
        this.setDescription(string);
        this.textField.setFormatedNumber(d);
        this.setUnit(string2);
        this.textField.setNumberField(true);
    }

    public BreezeInputField(String string, double d, String string2, BreezeInputFieldHelper.Format format) {
        this(string, NiceDataFormat.toString((double)d), string2, format);
    }

    public BreezeInputField(String string, String string2, String string3, BreezeInputFieldHelper.Format format) {
        this(string, string2, string3, null, format);
    }

    public BreezeInputField(String string, String string2, String string3, TextActionEvent.TextActionListener textActionListener, BreezeInputFieldHelper.Format format) {
        this.format = format;
        BreezeInputFieldHelper.format(this, this.descLabel, this.textField, this.unitLabel, this.usageLabel, format);
        this.setDescription(string);
        this.textField.setText(string2);
        this.setUnit(string3);
        if (textActionListener != null) {
            this.addChangeListener(textActionListener);
        }
    }

    @Override
    public void setForeground(Color color) {
        if (this.descLabel != null) {
            this.descLabel.setForeground(color);
        }
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
        if (this.unitLabel != null) {
            this.unitLabel.setForeground(color);
        }
        if (this.usageLabel != null) {
            this.usageLabel.setForeground(color);
        }
    }

    @Override
    public void setFormat(BreezeInputFieldHelper.Format format) {
        this.format = format;
        BreezeInputFieldHelper.format(this, this.descLabel, this.textField, this.unitLabel, this.usageLabel, format);
        this.update();
    }

    public BreezeInputFieldHelper.Format getFormat() {
        return this.format;
    }

    public void reFormat() {
        this.setFormat(this.format);
    }

    public void setLabelForeground(Color color) {
        this.descLabel.setForeground(color);
        this.unitLabel.setForeground(color);
        this.usageLabel.setForeground(color);
    }

    public void setLabelFont(Font font) {
        this.descLabel.setFont(font);
    }

    public Color getLabelForeground() {
        return this.descLabel.getForeground();
    }

    public void setDescription(String string) {
        this.description = string;
        this.update();
    }

    public String getDescription() {
        return this.descLabel.getText();
    }

    @Override
    public void setValue(Object object) {
        this.setValue(object.toString());
    }

    public void setValue(double d) {
        this.textField.setFormatedNumber(d);
    }

    public void setValue(String string) {
        this.textField.setText(string);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public int getValueInt() {
        return this.textField.getNumberInt();
    }

    public String getValueOrNull() {
        if (this.isEmpty()) {
            return null;
        }
        return this.textField.getText();
    }

    public void setDefaultValue(String string) {
        this.textField.setDefaultValue(string);
    }

    public void setValueHeight(int n) {
        this.textField.setMinimumSize(new Dimension(6, n));
        this.textField.setPreferredSize(new Dimension(59, n));
    }

    public int getValueHeight() {
        return this.textField.getPreferredSize().height;
    }

    public void addChangeListener(TextActionEvent.TextActionListener textActionListener) {
        this.textField.addChangeListener(textActionListener);
    }

    public void addTextKeyListener(KeyListener keyListener) {
        this.textField.addTextKeyListener(keyListener);
    }

    public void setUnit(String string) {
        this.unitLabel.setText(string);
        this.update();
    }

    private void update() {
        if (this.format == BreezeInputFieldHelper.Format.TwoRows && !this.unitLabel.getText().trim().isEmpty()) {
            this.descLabel.setText(this.description + " (" + this.unitLabel.getText() + ")");
        } else {
            this.descLabel.setText(this.description);
        }
        this.unitLabel.setVisible(this.format == BreezeInputFieldHelper.Format.OneRow && this.unitLabel.getText().length() > 0);
    }

    public String getUnit() {
        return this.unitLabel.getText();
    }

    public double getNumber() {
        return this.textField.getNumber();
    }

    public float getNumberFloat() {
        return this.textField.getNumberFloat();
    }

    public int getNumberInt() {
        return this.textField.getNumberInt();
    }

    public boolean isEmpty() {
        return this.textField.getText().length() == 0;
    }

    public boolean hasValue() {
        return !this.isEmpty();
    }

    public void setNumberField(boolean bl) {
        this.textField.setNumberField(bl);
    }

    public void setNumberField(boolean bl, double d, double d2) {
        this.textField.setNumberField(bl, d, d2);
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.descLabel.setEnabled(bl);
        this.textField.setEnabled(bl);
    }

    public void setMinlength(int n) {
        this.textField.setMinlength(n);
    }

    public void addValidator(AbstractValidator abstractValidator) {
        this.textField.addValidator(abstractValidator);
    }

    public void clearValidators() {
        this.textField.ClearValidators();
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void requestFocusAndSelectAll() {
        this.textField.requestFocusAndSelectAll();
    }

    public void setAddKeyVisible(boolean bl) {
        this.textField.setAddKeyVisible(bl);
    }

    public void setTextAndTrigger(String string) {
        this.textField.setTextAndTrigger(string);
    }

    public void setValueAndTrigger(double d) {
        this.textField.setTextAndTrigger(RtDataFormat.toString(d));
    }

    public void triggerChange(boolean bl) {
        this.triggerChange(bl, false);
    }

    public Optional<ValidatorResult> triggerChange(boolean bl, boolean bl2) {
        return this.textField.triggerChange(bl, bl2);
    }

    public void resetTouchKeyboard() {
        this.textField.resetTouchKeyboard();
    }

    public void setEmptyText(String string) {
        this.textField.setEmptyText(string);
    }

    @Override
    public void setLabelWidth(int n) {
        Dimension dimension = new Dimension(n, this.textField.getPreferredSize().height);
        this.descLabel.setPreferredSize(dimension);
        this.descLabel.setMinimumSize(dimension);
    }

    @Override
    public void setValueWidth(int n) {
        this.textField.setPreferredSize(new Dimension(n, this.textField.getPreferredSize().height));
    }

    @Override
    public void setToolTipText(String string) {
        this.textField.setToolTipText(string);
    }

    public BreezeLabel getLabel() {
        return this.descLabel;
    }

    public BreezeTextField getTextField() {
        return this.textField;
    }

    @Override
    public void setUnitLabelWidth(int n) {
        Dimension dimension = new Dimension(n, this.textField.getPreferredSize().height);
        this.unitLabel.setPreferredSize(dimension);
        this.unitLabel.setMinimumSize(dimension);
    }

    public BreezeLabel getUnitLabel() {
        return this.unitLabel;
    }

    public void setUsage(String string) {
        this.usageLabel.setText(string);
    }

    public void setUsageReFormat(String string) {
        this.usageLabel.setText(string);
        this.reFormat();
    }

    public void setCrossPanelVisible(boolean bl) {
        this.textField.setCrossPanelVisible(bl);
    }

    public void setTriggerChangeOnCross(boolean bl) {
        this.textField.setTriggerChangeOnCross(bl);
    }

    public static class Number
    extends BreezeInputField {
        public Number(String string, String string2, String string3) {
            super(string, string2, string3);
            this.setMinlength(1);
            this.setNumberField(true);
        }

        public Number(String string, double d, String string2) {
            super(string, d, string2);
            this.setMinlength(1);
            this.setNumberField(true);
        }

        public Number(String string, String string2, double d, String string3) {
            this(string, d, string3);
            this.setUsage(string2);
        }

        public Number(String string, double d, String string2, TextActionEvent.TextActionListener textActionListener) {
            this(string, d, string2);
            this.addChangeListener(textActionListener);
        }

        public Number(String string, double d, String string2, TextActionEvent.TextActionListener textActionListener, BreezeInputFieldHelper.Format format) {
            this(string, d, string2, format);
            this.addChangeListener(textActionListener);
        }

        public Number(String string, double d, String string2, BreezeInputFieldHelper.Format format) {
            super(string, d, string2, format);
        }
    }
}

