/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.AbstractBreezeTextPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.validator.AbstractValidatorDocumentListener;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;
import se.prediktera.breeze.frontend.common.util.PanelUtils;
import se.prediktera.breeze.frontend.common.virtualkeyboard.gui.PanelVirtualKeyboardReal;
import se.prediktera.map.common.SwingTimer;

public class BreezeKeyboard
extends AbstractBreezeDialog {
    private AbstractBreezeTextPanel targetTextComponent;
    private final List<AbstractBreezeTextPanel> relatedBreezeTextComponents;
    private AbstractValidatorDocumentListener validatorDocumentListener;
    private MouseAdapter contextListener;
    private boolean isNumberField = false;
    private SwingTimer swingTimer = null;
    private int warningblink = 0;
    private JPanel bottomPanel;
    private BreezeScrollPane jScrollPane1;
    private JPanel keyboardPanel;
    private JLabel label;
    private BreezeButton nextButton;
    private JPanel nextPanel;
    private PanelVirtualKeyboardReal panelVirtualKeyboardReal1;
    private BreezeButton prevButton;
    private JPanel prevPanel;
    private JPanel seeThroughClosePanel;
    private BreezeTextArea textArea;
    private JPanel textPanel;
    private JLabel warningLabel;

    public BreezeKeyboard() {
        this(null, null, null);
    }

    public BreezeKeyboard(BreezeFrame breezeFrame, AbstractBreezeTextPanel abstractBreezeTextPanel, Color color) {
        super(breezeFrame, color);
        this.initComponents();
        this.textArea.setActivekeyboard(false);
        this.panelVirtualKeyboardReal1.setLayer(abstractBreezeTextPanel.getLayer());
        Color color2 = Color.lightGray;
        this.panelVirtualKeyboardReal1.setColor(color);
        this.panelVirtualKeyboardReal1.setBackground(color2);
        this.bottomPanel.setBackground(color2);
        this.textPanel.setBackground(color2);
        JButton jButton = new JButton();
        Font font = jButton.getFont();
        this.panelVirtualKeyboardReal1.setButtonFont(new Font(font.getName(), font.getStyle(), 24));
        boolean bl = abstractBreezeTextPanel.supportMultipleLines();
        this.panelVirtualKeyboardReal1.showEnter(bl);
        this.textArea.setRows(bl ? 4 : 1);
        this.panelVirtualKeyboardReal1.setBreezeKeyboard(this);
        this.panelVirtualKeyboardReal1.setTextComponent(this.textArea);
        this.keyboardPanel.add(this.panelVirtualKeyboardReal1);
        this.warningLabel.setText("");
        this.setTarget(abstractBreezeTextPanel);
        if (color != null) {
            this.prevButton.setBackground(color);
            this.prevButton.setBorderColor(color);
            this.nextButton.setBackground(color);
            this.nextButton.setBorderColor(color);
        }
        Locale locale = Locale.of("sv");
        this.panelVirtualKeyboardReal1.setLocaleL(locale);
        this.relatedBreezeTextComponents = PanelUtils.findAllRelatedInputfields(abstractBreezeTextPanel);
        this.removeInactiveComponents(this.relatedBreezeTextComponents);
        boolean bl2 = this.relatedBreezeTextComponents.size() > 1;
        this.prevButton.setVisible(bl2);
        this.nextButton.setVisible(bl2);
    }

    public void addAddKeyListener(MouseAdapter mouseAdapter) {
        this.contextListener = mouseAdapter;
        this.panelVirtualKeyboardReal1.addContextKeyListener(mouseAdapter);
    }

    public void cleanUpAddKeyListener() {
        if (this.contextListener != null) {
            this.panelVirtualKeyboardReal1.clearContextKeyListener();
        }
    }

    public boolean close() {
        if (!this.saveTextAndValidate()) {
            this.showFailedSavePopup();
            return false;
        }
        this.close(false, null);
        this.targetTextComponent.requestFocusAndSelectAll();
        return true;
    }

    public void closeWithoutSave() {
        this.close(false, null);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public boolean isAddKeyVisible() {
        return this.panelVirtualKeyboardReal1.isAddKeyVisible();
    }

    public boolean isNumberField() {
        return this.isNumberField;
    }

    public boolean saveTextAndValidate() {
        String string = this.textArea.getText();
        if (this.targetTextComponent.validateText(string) != null) {
            return false;
        }
        this.targetTextComponent.setTextAndTrigger(string);
        return true;
    }

    public void setAddKeyVisible(boolean bl) {
        this.panelVirtualKeyboardReal1.setAddKeyVisible(bl);
    }

    public void useSetListener() {
        this.cleanUpAddKeyListener();
        this.contextListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeKeyboard.this.close();
            }
        };
        this.addAddKeyListener(this.contextListener);
    }

    private void initComponents() {
        this.seeThroughClosePanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.textPanel = new JPanel();
        this.jScrollPane1 = new BreezeScrollPane();
        this.textArea = new BreezeTextArea();
        this.label = new JLabel();
        this.warningLabel = new JLabel();
        this.prevPanel = new JPanel();
        this.prevButton = new BreezeButton();
        this.nextPanel = new JPanel();
        this.nextButton = new BreezeButton();
        this.keyboardPanel = new JPanel();
        this.panelVirtualKeyboardReal1 = new PanelVirtualKeyboardReal();
        this.setLayout(new GridBagLayout());
        this.seeThroughClosePanel.setOpaque(false);
        this.seeThroughClosePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                BreezeKeyboard.this.seeThroughClosePanelMousePressed(mouseEvent);
            }
        });
        this.seeThroughClosePanel.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.seeThroughClosePanel, gridBagConstraints);
        this.bottomPanel.setLayout(new GridBagLayout());
        this.textPanel.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(306, 100));
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Tahoma", 0, 18));
        this.textArea.setRows(4);
        this.textArea.setText("Text");
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                BreezeKeyboard.this.textAreaKeyPressed(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.textPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.label.setFont(new Font("Tahoma", 0, 24));
        this.label.setForeground(new Color(51, 51, 51));
        this.label.setText("Label");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.textPanel.add((Component)this.label, gridBagConstraints);
        this.warningLabel.setFont(new Font("Tahoma", 0, 18));
        this.warningLabel.setForeground(new Color(255, 0, 0));
        this.warningLabel.setText("WarningLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 20, 0, 20);
        this.textPanel.add((Component)this.warningLabel, gridBagConstraints);
        this.prevPanel.setOpaque(false);
        this.prevPanel.setPreferredSize(new Dimension(110, 54));
        this.prevPanel.setLayout(new BorderLayout());
        this.prevButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/back2.png")));
        this.prevButton.setText("Prev");
        this.prevButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeKeyboard.this.prevButtonMouseClicked(mouseEvent);
            }
        });
        this.prevPanel.add((Component)this.prevButton, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.textPanel.add((Component)this.prevPanel, gridBagConstraints);
        this.nextPanel.setOpaque(false);
        this.nextPanel.setPreferredSize(new Dimension(110, 54));
        this.nextPanel.setLayout(new BorderLayout());
        this.nextButton.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/images/next2.png")));
        this.nextButton.setText("Next");
        this.nextButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeKeyboard.this.nextButtonMouseClicked(mouseEvent);
            }
        });
        this.nextPanel.add((Component)this.nextButton, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.textPanel.add((Component)this.nextPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.bottomPanel.add((Component)this.textPanel, gridBagConstraints);
        this.keyboardPanel.setLayout(new BorderLayout());
        this.panelVirtualKeyboardReal1.setPreferredSize(new Dimension(818, 400));
        this.keyboardPanel.add((Component)this.panelVirtualKeyboardReal1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 6, 12, 6);
        this.bottomPanel.add((Component)this.keyboardPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.add(this.bottomPanel, gridBagConstraints);
    }

    private void nextButtonMouseClicked(MouseEvent mouseEvent) {
        this.switchTargetTextComponent(true);
    }

    private void prevButtonMouseClicked(MouseEvent mouseEvent) {
        this.switchTargetTextComponent(false);
    }

    private List<AbstractBreezeTextPanel> removeInactiveComponents(List<AbstractBreezeTextPanel> list) {
        Iterator<AbstractBreezeTextPanel> iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBreezeTextPanel abstractBreezeTextPanel = iterator.next();
            if (abstractBreezeTextPanel.isVisible() && abstractBreezeTextPanel.isEnabled()) continue;
            iterator.remove();
        }
        return list;
    }

    private void requestFocusAndSelectAll() {
        SwingUtilities.invokeLater(() -> this.textArea.requestFocusAndSelectAll());
    }

    private void seeThroughClosePanelMousePressed(MouseEvent mouseEvent) {
        this.close();
    }

    private void setLabelTextFromLabel(JLabel jLabel) {
        this.label.setText(jLabel == null ? "" : jLabel.getText());
    }

    private void setTarget(AbstractBreezeTextPanel abstractBreezeTextPanel) {
        if (this.validatorDocumentListener != null) {
            this.textArea.getDocument().removeDocumentListener(this.validatorDocumentListener);
        }
        this.setLabelTextFromLabel(abstractBreezeTextPanel.getLabel());
        this.textArea.setText(abstractBreezeTextPanel.getText());
        this.requestFocusAndSelectAll();
        this.targetTextComponent = abstractBreezeTextPanel;
        this.validatorDocumentListener = new AbstractValidatorDocumentListener(abstractBreezeTextPanel){

            @Override
            public void validationResult(ValidatorResult validatorResult) {
                if (validatorResult != null) {
                    BreezeKeyboard.this.warningLabel.setText(validatorResult.getResult());
                } else {
                    BreezeKeyboard.this.warningLabel.setText("");
                }
            }
        };
        this.textArea.getDocument().addDocumentListener(this.validatorDocumentListener);
        this.isNumberField = abstractBreezeTextPanel.isNumberField();
        abstractBreezeTextPanel.touchKeyboardInit(this);
    }

    private void showFailedSavePopup() {
        this.warningblink = 0;
        if (this.swingTimer == null) {
            this.swingTimer = new SwingTimer(300, actionEvent -> {
                if (this.warningblink % 2 == 0) {
                    this.warningLabel.setOpaque(true);
                    this.warningLabel.setBackground(Color.red);
                    this.warningLabel.setForeground(Color.white);
                } else {
                    this.warningLabel.setOpaque(false);
                    this.warningLabel.setBackground(Color.white);
                    this.warningLabel.setForeground(Color.red);
                }
                if (++this.warningblink >= 4) {
                    this.swingTimer.stop();
                }
            });
            this.swingTimer.setRepeats(true);
        }
        this.swingTimer.restart();
    }

    private void switchTargetTextComponent(boolean bl) {
        int n;
        if (this.relatedBreezeTextComponents == null || this.relatedBreezeTextComponents.isEmpty()) {
            return;
        }
        if (!this.saveTextAndValidate()) {
            this.showFailedSavePopup();
            return;
        }
        if (bl) {
            n = this.relatedBreezeTextComponents.indexOf(this.targetTextComponent) + 1;
            if (n >= this.relatedBreezeTextComponents.size()) {
                n = 0;
            }
        } else {
            n = this.relatedBreezeTextComponents.indexOf(this.targetTextComponent) - 1;
            if (n < 0) {
                n = this.relatedBreezeTextComponents.size() - 1;
            }
        }
        this.setTarget(this.relatedBreezeTextComponents.get(n));
        this.setLabelTextFromLabel(this.targetTextComponent.getLabel());
        this.textArea.setText(this.targetTextComponent.getText());
        this.requestFocusAndSelectAll();
    }

    private void textAreaKeyPressed(KeyEvent keyEvent) {
        if (!this.targetTextComponent.supportMultipleLines() && keyEvent.getKeyCode() == 10) {
            this.close();
        }
    }
}

