/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeLabel
extends JLabel {
    private Direction direction = Direction.HORIZONTAL;
    private FontSize fontSize = FontSize.Text;
    private boolean needsRotate;
    private String fullText;
    private Color foreground = BreezeTheme.getInstance().getLabelForeground();

    public BreezeLabel() {
        this("");
    }

    public BreezeLabel(String string) {
        this(string, false, 16);
    }

    public BreezeLabel(String string, ImageIcon imageIcon) {
        this(string, imageIcon, 16);
    }

    public BreezeLabel(String string, ImageIcon imageIcon, int n) {
        this(string, false, n);
        this.setIcon(imageIcon);
    }

    public BreezeLabel(String string, boolean bl) {
        this(string, bl, 16);
    }

    public BreezeLabel(String string, boolean bl, int n) {
        super(string);
        this.setFont(new Font("Tahoma", bl ? 1 : 0, n));
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setForeground(breezeTheme.getLabelForeground());
    }

    public void setFontSize(FontSize fontSize) {
        this.fontSize = fontSize;
        this.setFontSize(fontSize.getSize());
    }

    public void setFontSize(int n) {
        Font font = this.getFont();
        this.setFont(new Font(font.getFontName(), font.getStyle(), n));
    }

    public void setFontStyle(int n) {
        Font font = this.getFont();
        this.setFont(new Font(font.getFontName(), n, font.getSize()));
    }

    public void setUnderline(boolean bl) {
        Font font = this.getFont();
        if (bl) {
            HashMap hashMap = new HashMap(font.getAttributes());
            hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            this.setFont(font.deriveFont(hashMap));
        } else {
            this.setFontSize(font.getSize());
        }
    }

    public void setResourceIcon(String string) {
        this.setIcon(ImageHelper.getResourceIcon(string));
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public void setAbbreviatedText(String string, int n) {
        this.fullText = string;
        try {
            this.setText(StringUtils.abbreviate((String)string, (int)BreezeLabel.lettersWithinSize(string, this.getFontMetrics(this.getFont()), n)));
        }
        catch (Exception exception) {
            this.setText("");
        }
    }

    private static int lettersWithinSize(String string, FontMetrics fontMetrics, int n) {
        for (int i = string.length(); i >= 1; --i) {
            if (fontMetrics.stringWidth(string.substring(0, i)) > n) continue;
            return i;
        }
        return 0;
    }

    @Override
    public String getToolTipText() {
        if (this.fullText != null) {
            return this.fullText;
        }
        return super.getToolTipText();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return switch (this.getDirection().ordinal()) {
            case 1, 2 -> new Dimension(dimension.height, dimension.width);
            default -> dimension;
        };
    }

    @Override
    public Dimension getSize() {
        if (!this.needsRotate) {
            return super.getSize();
        }
        Dimension dimension = super.getSize();
        return switch (this.getDirection().ordinal()) {
            case 1, 2 -> new Dimension(dimension.height, dimension.width);
            default -> super.getSize();
        };
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.direction != Direction.HORIZONTAL) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            switch (this.direction.ordinal()) {
                case 1: {
                    graphics2D.translate(0.0, this.getSize().getHeight());
                    graphics2D.transform(AffineTransform.getQuadrantRotateInstance(-1));
                    break;
                }
                case 2: {
                    graphics2D.transform(AffineTransform.getQuadrantRotateInstance(1));
                    graphics2D.translate(0.0, -this.getSize().getWidth());
                    break;
                }
            }
        }
        this.needsRotate = true;
        super.paintComponent(graphics2D);
        this.needsRotate = false;
    }

    @Override
    public void setForeground(Color color) {
        this.foreground = color;
        super.setForeground(this.foreground);
    }

    @Override
    public void setEnabled(boolean bl) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (bl) {
            super.setForeground(this.foreground);
        } else {
            super.setForeground(breezeTheme.getLabelForegroundMoreDifuse());
        }
    }

    public void adjustFontSizeForComponent(int n) {
        Font font = new Font(this.getFont().getFontName(), this.getFont().getStyle(), 18);
        int n2 = this.getFontMetrics(font).stringWidth(this.getText());
        double d = (double)n / (double)n2;
        this.setFont(new Font(font.getName(), this.getFont().getStyle(), Math.min(24, (int)(18.0 * d))));
    }

    @Generated
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Generated
    public Direction getDirection() {
        return this.direction;
    }

    @Generated
    public FontSize getFontSize() {
        return this.fontSize;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL_UP,
        VERTICAL_DOWN;

    }

    public static enum FontSize {
        H1(18),
        H2(16),
        H3(14),
        Text(12);

        private final int size;

        private FontSize(int n2) {
            this.size = n2;
        }

        @Generated
        public int getSize() {
            return this.size;
        }
    }

    public static class BreezeLabelPanel
    extends JPanel {
        private static final int ARC_WIDTH = 30;
        private static final int ARC_HEIGHT = 30;
        private static final Color BACKGROUND_COLOR = new Color(0, 0, 0, 120);
        private final BreezeLabel label;

        public BreezeLabelPanel(String string, boolean bl, int n) {
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.label = new BreezeLabel(string, bl, n);
            this.label.setForeground(Color.WHITE);
            this.label.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.add((Component)this.label, "Center");
        }

        public void setText(String string) {
            this.label.setText(string);
        }

        public void setIcon(ImageIcon imageIcon) {
            this.label.setIcon(imageIcon);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(BACKGROUND_COLOR);
            graphics2D.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 30, 30);
            graphics2D.dispose();
        }
    }

    public static class BreezeLabelHeader
    extends BreezeLabel {
        public BreezeLabelHeader(String string) {
            super(string, false, FontSize.H1.getSize());
            this.setForeground(BreezeTheme.getInstance().getLabelForegroundDifuse());
        }
    }
}

