/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.ButtonMouseAdapter;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeLabelButton
extends JPanel
implements BreezeButtonInterface {
    private final BreezeLabel label;
    private ImageIcon hoverIcon;
    private ImageIcon resourceIcon;
    private ImageIcon grayedIcon;
    private final String icon;
    private Color fgColor;

    public BreezeLabelButton(String string) {
        this(string, null, null);
    }

    public BreezeLabelButton(String string, String string2, final EntryMainHelper.ClickCallBack clickCallBack) {
        this.icon = string2;
        this.setOpaque(false);
        this.label = new BreezeLabel(string);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.updateIcon();
        if (clickCallBack != null) {
            this.addMouseListener(new OnClickMouseAdapter(this, this){
                final /* synthetic */ BreezeLabelButton this$0;
                {
                    this.this$0 = breezeLabelButton;
                    super(jPanel);
                }

                @Override
                public void onClicked(MouseEvent mouseEvent) {
                    clickCallBack.doClick();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (this.this$0.isEnabled()) {
                        if (this.this$0.hoverIcon != null) {
                            this.this$0.label.setIcon(this.this$0.hoverIcon);
                        }
                        this.this$0.label.setUnderline(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (this.this$0.isEnabled()) {
                        if (this.this$0.resourceIcon != null) {
                            this.this$0.label.setIcon(this.this$0.resourceIcon);
                        }
                        this.this$0.label.setUnderline(false);
                    }
                }
            });
        }
        this.add(this.label);
    }

    @Override
    public void doClick() {
        MouseListener[] mouseListenerArray;
        this.requestFocus();
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            if (!(mouseListener instanceof ButtonMouseAdapter)) continue;
            ((ButtonMouseAdapter)mouseListener).triggerEvent(new MouseEvent(this, 0, System.currentTimeMillis(), 0, 0, 0, 0, true, 1));
        }
    }

    public void updateIcon() {
        if (this.icon != null) {
            this.resourceIcon = ImageHelper.getResourceIcon(this.icon);
            this.hoverIcon = ImageHelper.createHoverIcon(this.resourceIcon);
            boolean bl = BreezeTheme.getInstance().isDarkMode();
            this.grayedIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.resourceIcon.getImage().getSource(), new GrayFilter(!bl, bl ? 95 : 50))));
            this.label.setIcon(this.resourceIcon);
        }
    }

    public void setFontStyle(int n) {
        this.label.setFontStyle(n);
    }

    public void setFontSize(int n) {
        this.label.setFontSize(n);
    }

    @Override
    public void setForeground(Color color) {
        this.fgColor = color;
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.label.setIcon(this.resourceIcon);
        } else {
            this.label.setIcon(this.grayedIcon);
        }
        this.label.setForeground(bl ? this.fgColor : BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
    }

    public static class OnClickMouseAdapter
    extends MouseAdapter {
        private static JPanel lastPressed = null;
        private final JPanel associatedPanel;

        public OnClickMouseAdapter(JPanel jPanel) {
            this.associatedPanel = jPanel;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            lastPressed = SwingUtilities.isLeftMouseButton(mouseEvent) ? this.associatedPanel : null;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (lastPressed == this.associatedPanel && this.associatedPanel.isEnabled() && this.isInsidePanel(mouseEvent)) {
                this.onClicked(mouseEvent);
                lastPressed = null;
            }
        }

        private boolean isInsidePanel(MouseEvent mouseEvent) {
            return mouseEvent.getX() >= 0 && mouseEvent.getX() < this.associatedPanel.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < this.associatedPanel.getHeight();
        }

        public void onClicked(MouseEvent mouseEvent) {
        }
    }
}

