/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.border.Border;
import lombok.Generated;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.DragMoverListener;
import se.prediktera.breeze.frontend.common.swing.BreezeListInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.common.cleanup.CleanUpList;

public class BreezeList
extends CleanUpList
implements BreezeListInterface {
    private boolean directclick = false;
    private boolean overborder = false;
    private Object mouseOverObject = null;
    private boolean mousePressed = false;
    private Border emptyBorder = null;
    private boolean toggle = false;

    public BreezeList() {
        super("BreezeList");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                BreezeList.this.setMouseOverObject(null);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (BreezeList.this.directclick) {
                    BreezeList.this.mousePressed = true;
                    BreezeList.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                BreezeList.this.mousePressed = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                try {
                    int n = BreezeList.this.locationToIndex(mouseEvent.getPoint());
                    BreezeList.this.setMouseOverObject(BreezeList.this.getModel().getElementAt(n));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        try {
            this.setCursor(BreezeFrame.getHandCursor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setForeground(breezeTheme.getLabelForeground());
        this.setSelectionBackground(breezeTheme.getEntrySelectionBackground());
        this.setSelectionForeground(breezeTheme.getLabelForeground());
    }

    public void addScroll() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            this.addMouseMotionListener(new DragMoverListener(jViewport, (JComponent)((Object)this)));
        }
    }

    public int getItemCount() {
        ListModel listModel = this.getModel();
        if (listModel != null) {
            return listModel.getSize();
        }
        return 0;
    }

    public Object getItemAt(int n) {
        ListModel listModel = this.getModel();
        if (listModel != null) {
            return listModel.getElementAt(n);
        }
        return null;
    }

    @Override
    public Object getObjectAt(Point point) {
        int n = this.locationToIndex(point);
        ListModel listModel = this.getModel();
        return listModel.getElementAt(n);
    }

    public void selectAll() {
        int n;
        ListModel listModel = this.getModel();
        if (listModel != null && (n = listModel.getSize() - 1) > 0) {
            this.setSelectionInterval(0, n);
        }
    }

    public void setDirectclick() {
        this.directclick = true;
        this.overborder = true;
    }

    public void setModel(List list) {
        this.setModel(new ArrayListModel(list));
    }

    public void updateBorder(Object object, JPanel jPanel, Color color) {
        if (this.overborder) {
            boolean bl = object.equals(this.mouseOverObject);
            if (bl) {
                jPanel.setBackground(Color.gray);
                if (this.mousePressed) {
                    jPanel.setBackground(Color.white);
                } else {
                    jPanel.setBorder(this.getEmptyBorder());
                }
            } else {
                jPanel.setBackground(color);
                jPanel.setBorder(this.getEmptyBorder());
            }
        }
    }

    protected void cleanUpChild() {
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.toggle) {
            int n = mouseEvent.getModifiersEx();
            if ((n & 0x40) == 0) {
                n |= 0x180;
            }
            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), n, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            super.processMouseEvent(mouseEvent2);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    private Border getEmptyBorder() {
        if (this.emptyBorder == null) {
            this.emptyBorder = BorderFactory.createEmptyBorder();
        }
        return this.emptyBorder;
    }

    private void setMouseOverObject(Object object) {
        if (this.mouseOverObject != object) {
            this.mouseOverObject = object;
            this.repaint();
            if (this.directclick) {
                this.clearSelection();
            }
        }
    }

    public int getIndexOf(String string) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).toString().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object e;
        int n = this.locationToIndex(mouseEvent.getPoint());
        if (n > -1 && (e = this.getModel().getElementAt(n)) instanceof Entry) {
            return e.toString();
        }
        return null;
    }

    @Generated
    public Object getMouseOverObject() {
        return this.mouseOverObject;
    }

    @Generated
    public boolean isToggle() {
        return this.toggle;
    }

    @Generated
    public void setToggle(boolean bl) {
        this.toggle = bl;
    }
}

