/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeList;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeListScrollButton
extends JPanel {
    private BreezeButton leftButton;
    private BreezeList list;
    private BreezeButton rightButton;
    private BreezeScrollPane scrollPane;

    public BreezeListScrollButton() {
        this.initComponents();
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        this.leftButton.setPreferredSize(new Dimension(20, 0));
        this.rightButton.setPreferredSize(new Dimension(20, 0));
        this.leftButton.setIconVisible(false);
        this.rightButton.setIconVisible(false);
        this.setOpaque(false);
        this.list.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                BreezeListScrollButton.this.checkIfIconsNeeded();
            }
        });
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.list.setBackground(breezeTheme.getPanelBackground());
        this.list.setForeground(breezeTheme.getLabelForeground());
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public void checkIfIconsNeeded() {
        Dimension dimension = this.list.getPreferredScrollableViewportSize();
        int n = this.scrollPane.getWidth();
        if (dimension.width <= n) {
            this.leftButton.setIconVisible(false);
            this.rightButton.setIconVisible(false);
        } else {
            this.leftButton.setIconVisible(true);
            this.rightButton.setIconVisible(true);
        }
    }

    public void cleanUp() {
        this.list.cleanUp();
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return this.list.getListSelectionListeners();
    }

    public ListModel getModel() {
        return this.list.getModel();
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public int getIndexOf(String string) {
        return this.list.getIndexOf(string);
    }

    public Object getSelectedValue() {
        return this.list.getSelectedValue();
    }

    public int getSelectionMode() {
        return this.list.getSelectionMode();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.list != null) {
            this.list.setBackground(color);
        }
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.list.setCellRenderer(listCellRenderer);
    }

    public void setLayoutOrientation(int n) {
        this.list.setLayoutOrientation(n);
    }

    public void setListOpaque(boolean bl) {
        this.list.setOpaque(bl);
    }

    public void setModel(ListModel listModel) {
        this.list.setModel(listModel);
    }

    public void setModel(List list) {
        this.list.setModel(list);
    }

    public void setSelectedIndex(int n) {
        this.list.setSelectedIndex(n);
    }

    public void setSelectedValue(Object object, boolean bl) {
        this.list.setSelectedValue(object, bl);
    }

    public void setSelectionBackground(Color color) {
        this.list.setSelectionBackground(color);
    }

    public void setSelectionForeground(Color color) {
        this.list.setSelectionForeground(color);
    }

    public Color getSelectionBackground() {
        return this.list.getSelectionBackground();
    }

    public Color getSelectionForeground() {
        return this.list.getSelectionForeground();
    }

    public void setListBackground(Color color) {
        this.list.setBackground(color);
    }

    public void setListForeground(Color color) {
        this.list.setForeground(color);
    }

    public Color getListBackground() {
        return this.list.getBackground();
    }

    public Color getListForeground() {
        return this.list.getForeground();
    }

    public void setListFont(Font font) {
        this.list.setFont(font);
    }

    public Font getListFont() {
        return this.list.getFont();
    }

    public void setSelectionMode(int n) {
        this.list.setSelectionMode(n);
    }

    public void setVisibleRowCount(int n) {
        this.list.setVisibleRowCount(n);
    }

    public void ensureIndexIsVisible(int n) {
        this.list.ensureIndexIsVisible(n);
    }

    public int getItemCount() {
        return this.list.getItemCount();
    }

    public Object getItemAt(int n) {
        return this.list.getItemAt(n);
    }

    private void initComponents() {
        this.leftButton = new BreezeButton();
        this.scrollPane = new BreezeScrollPane();
        this.list = new BreezeList();
        this.rightButton = new BreezeButton();
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.leftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/arrowleft.png")));
        this.leftButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeListScrollButton.this.leftButtonMouseClicked(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.leftButton, gridBagConstraints);
        this.scrollPane.setBorder(null);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView((Component)((Object)this.list));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.rightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/arrowright.png")));
        this.rightButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeListScrollButton.this.rightButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.rightButton, gridBagConstraints);
    }

    private void leftButtonMouseClicked(MouseEvent mouseEvent) {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        int n = jScrollBar.getValue();
        jScrollBar.setValue(n - jScrollBar.getBlockIncrement());
    }

    private void rightButtonMouseClicked(MouseEvent mouseEvent) {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        int n = jScrollBar.getValue();
        jScrollBar.setValue(n + jScrollBar.getBlockIncrement());
    }

    @Generated
    public BreezeList getList() {
        return this.list;
    }
}

