/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.RoundedBorder;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeMultiSelectInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeMultiSelect
extends JPanel {
    private final JPanel badgePanel;
    private final Map<String, Boolean> selections = new HashMap<String, Boolean>();
    private final Map<String, BreezeContextMenu.BreezeMenuButton> popupMenuButtons = new HashMap<String, BreezeContextMenu.BreezeMenuButton>();
    private final BreezeFrame breezeFrame;
    private final BreezeButton dropdownButton;
    private List<String> options;
    private BreezeMultiSelectInputField.MultiSelectCallback callback;

    public BreezeMultiSelect(BreezeFrame breezeFrame, String string2, List<String> list, boolean bl, int n, List<String> list2) {
        super(new GridBagLayout());
        this.breezeFrame = breezeFrame;
        this.setOpaque(false);
        this.dropdownButton = new BreezeButton(string2, this::showPopupMenu);
        this.dropdownButton.setTextFontSize(n);
        this.dropdownButton.setPadding(4);
        this.badgePanel = new JPanel(new GridBagLayout());
        this.badgePanel.setOpaque(false);
        this.setOptions(list);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints.anchor = 18;
        this.add((Component)this.dropdownButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.badgePanel, gridBagConstraints);
        if (bl) {
            list.forEach(string -> this.selections.put((String)string, true));
        } else if (ObjectUtils.isNotEmpty(list2)) {
            list.forEach(string -> this.selections.put((String)string, list2.contains(string)));
        } else {
            list.forEach(string -> this.selections.put((String)string, false));
        }
        this.updateBadges();
    }

    public void setCallBack(BreezeMultiSelectInputField.MultiSelectCallback multiSelectCallback) {
        this.callback = multiSelectCallback;
    }

    private void invokeCallBack() {
        if (this.callback != null) {
            this.callback.onMultiSelect(this.getSelectedValues());
        }
    }

    public void setOptions(List<String> list) {
        this.selections.clear();
        this.options = list;
        this.updateBadges();
    }

    public void showPopupMenu() {
        int n = this.dropdownButton.getWidth() / 4 * 3;
        int n2 = this.dropdownButton.getHeight();
        MouseEvent mouseEvent = new MouseEvent(this.dropdownButton, 501, System.currentTimeMillis(), 0, n, n2, 1, false);
        SwingUtilities.invokeLater(() -> this.createContextMenu().show(mouseEvent));
    }

    private BreezeContextMenu createContextMenu() {
        this.popupMenuButtons.clear();
        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.breezeFrame, Color.black);
        for (final String string : this.options) {
            boolean bl = this.selections.getOrDefault(string, false);
            BreezeContextMenu.BreezeMenuButton breezeMenuButton = breezeContextMenu.addButton(string, () -> {
                this.selections.put(string, this.selections.getOrDefault(string, false) == false);
                this.updateMenuIcon(string);
                this.updateBadges();
                this.invokeCallBack();
            }, bl ? "checkbox/selected.png" : "checkbox/normal.png");
            this.popupMenuButtons.put(string, breezeMenuButton);
            breezeMenuButton.getIconLabel().addMouseListener(new MouseAdapter(this){
                final /* synthetic */ BreezeMultiSelect this$0;
                {
                    this.this$0 = breezeMultiSelect;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$0.selections.put(string, this.this$0.selections.getOrDefault(string, false) == false);
                    this.this$0.updateMenuIcon(string);
                    this.this$0.updateBadges();
                    this.this$0.invokeCallBack();
                    mouseEvent.consume();
                }
            });
        }
        return breezeContextMenu;
    }

    private void updateMenuIcon(String string) {
        String string2 = this.selections.get(string) != false ? "checkbox/selected.png" : "checkbox/normal.png";
        this.popupMenuButtons.get(string).getIconLabel().setIcon(ImageHelper.getResourceIcon(string2));
    }

    public List<String> getSelectedValues() {
        return this.selections.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private void updateBadges() {
        this.badgePanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        int n = 0;
        for (String string : this.options) {
            if (!this.selections.getOrDefault(string, false).booleanValue()) continue;
            Badge badge = new Badge(string);
            gridBagConstraints.gridx = n++;
            gridBagConstraints.gridy = 0;
            this.badgePanel.add((Component)badge, gridBagConstraints);
        }
        this.badgePanel.revalidate();
        this.badgePanel.repaint();
    }

    @Generated
    public BreezeButton getDropdownButton() {
        return this.dropdownButton;
    }

    private class Badge
    extends JPanel {
        private static final int CORNER_RADIUS = 13;
        private static final int ALPHA = 64;

        public Badge(final String string) {
            super(new GridBagLayout());
            this.setOpaque(false);
            Color color = RtPerfectSpread.generateColor(BreezeMultiSelect.this.options.indexOf(string));
            this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 64));
            this.setBorder(new RoundedBorder(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse(), 13, 1));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            this.add((Component)new BreezeLabel(string, false, 11), gridBagConstraints);
            JLabel jLabel = new JLabel("X");
            jLabel.setFont(new Font("Tahoma", 1, 11));
            jLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
            jLabel.setCursor(Cursor.getPredefinedCursor(12));
            jLabel.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ Badge this$1;
                {
                    this.this$1 = badge;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$1.BreezeMultiSelect.this.selections.put(string, false);
                    this.this$1.BreezeMultiSelect.this.invokeCallBack();
                    this.this$1.BreezeMultiSelect.this.updateBadges();
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 5);
            this.add((Component)jLabel, gridBagConstraints);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 13, 13);
            graphics2D.dispose();
            super.paintComponent(graphics);
        }
    }
}

