/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;

public class BreezePasswordField
extends JPanel {
    private final JPanel bordered = new JPanel(new BorderLayout());
    private final JPasswordField field = new JPasswordField();
    private final JLabel toggle = new JLabel();
    private boolean showing = false;

    private static Font resolveSymbolFont(Font font) {
        int n = Math.max(16, font.getSize() + 2);
        for (String string : new String[]{"Segoe UI Symbol", "Noto Sans Symbols2", "Noto Sans Symbols", "Apple Symbols", "DejaVu Sans"}) {
            Font font2 = new Font(string, 0, n);
            if (!font2.getFamily().equals(string)) continue;
            return font2;
        }
        return font.deriveFont((float)n);
    }

    public BreezePasswordField() {
        super(new GridBagLayout());
        this.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.bordered, gridBagConstraints);
        Border border = BorderFactory.createEmptyBorder(0, 8, 0, 8);
        Border border2 = BorderFactory.createLineBorder(breezeTheme.getLabelForegroundMoreDifuse());
        this.bordered.setBorder(BorderFactory.createCompoundBorder(border2, border));
        this.bordered.setOpaque(false);
        this.field.setFont(new Font("Tahoma", 0, 14));
        this.field.setForeground(breezeTheme.getLabelForeground());
        this.field.setBackground(breezeTheme.getPanelBackground());
        this.field.setCaretColor(breezeTheme.getLabelForeground());
        this.field.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.initToggle(this.field.getFont());
        this.toggle.setCursor(Cursor.getPredefinedCursor(12));
        this.toggle.setOpaque(false);
        this.toggle.setForeground(breezeTheme.getLabelForeground());
        this.toggle.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 0));
        this.toggle.setToolTipText("Show password");
        this.toggle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezePasswordField.this.showing = !BreezePasswordField.this.showing;
                BreezePasswordField.this.updateEchoChar();
                BreezePasswordField.this.updateToggleGlyph();
            }
        });
        this.bordered.add((Component)this.field, "Center");
        this.bordered.add((Component)this.toggle, "East");
    }

    private void initToggle(Font font) {
        this.toggle.setText("\ud83d\udc41");
        this.toggle.setFont(BreezePasswordField.resolveSymbolFont(font));
        this.toggle.putClientProperty("SwingRenderingHints", RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private void updateEchoChar() {
        this.field.setEchoChar(this.showing ? (char)'\u0000' : '\u2022');
    }

    private void updateToggleGlyph() {
        this.toggle.setText(this.showing ? "\ud83d\ude48" : "\ud83d\udc41");
        this.toggle.setToolTipText(this.showing ? "Hide password" : "Show password");
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.field.setEnabled(bl);
        this.toggle.setEnabled(bl);
    }

    @Override
    public void requestFocus() {
        SwingUtilities.invokeLater(this.field::requestFocus);
    }

    public void selectAll() {
        this.field.selectAll();
    }

    public void setText(String string) {
        this.field.setText(string);
    }

    public String getText() {
        return new String(this.field.getPassword());
    }

    public char[] getPassword() {
        return this.field.getPassword();
    }

    public String getValue() {
        char[] cArray = this.field.getPassword();
        if (cArray.length > 0) {
            return BreezeUserManager.md5(new String(cArray));
        }
        return "";
    }

    public boolean isEmpty() {
        return this.field.getPassword().length == 0;
    }

    @Override
    public void setToolTipText(String string) {
        this.field.setToolTipText(string);
    }

    public JPasswordField getInnerField() {
        return this.field;
    }
}

