/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicProgressBarUI;
import se.prediktera.breeze.frontend.RoundedBorder;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeProgressBar
extends JProgressBar {
    private static final long radius = 10L;

    public BreezeProgressBar() {
        UIManager.put("ProgressBar.foreground", BreezeTheme.getInstance().getProgressBarColor());
        UIManager.put("ProgressBar.background", BreezeTheme.getInstance().getSettingPanelBackground());
        UIManager.put("ProgressBar.selectionForeground", Color.white);
        UIManager.put("ProgressBar.repaintInterval", 25);
        UIManager.put("ProgressBar.cycleTime", 6000);
        UIManager.put("ProgressBar.border", new RoundedBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse(), 10, 1));
        UIManager.put("ProgressBar.cellSpacing", 0);
        UIManager.put("ProgressBar.cellLength", 1);
        UIManager.put("ProgressBar.font", new Font("Tahoma", 0, 12));
        this.setStringPainted(true);
        this.setDoubleBuffered(true);
        this.setUI(new BreezeProgressBarUI());
    }

    @Override
    public void setIndeterminate(boolean bl) {
        super.setIndeterminate(bl);
        this.setStringPainted(!bl);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Test BreezeProgressBar");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(400, 100);
            BreezeProgressBar breezeProgressBar = new BreezeProgressBar();
            breezeProgressBar.setIndeterminate(false);
            breezeProgressBar.setValue(0);
            breezeProgressBar.setStringPainted(true);
            jFrame.setLayout(new BorderLayout());
            jFrame.add((Component)breezeProgressBar, "Center");
            Timer timer = new Timer(50, actionEvent -> {
                int n = breezeProgressBar.getValue() + 1;
                breezeProgressBar.setValue(n);
                if (n >= 100) {
                    breezeProgressBar.setIndeterminate(true);
                    breezeProgressBar.setStringPainted(false);
                    ((Timer)actionEvent.getSource()).stop();
                }
            });
            timer.start();
            jFrame.setVisible(true);
        });
    }

    private static class BreezeProgressBarUI
    extends BasicProgressBarUI {
        private int animationIndex = 0;

        private BreezeProgressBarUI() {
        }

        @Override
        protected int getBoxLength(int n, int n2) {
            return n;
        }

        @Override
        protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
            long l;
            Object object = this.setClippingAndGetBorder(graphics);
            if (!(object instanceof Result)) {
                return;
            }
            Result result = object;
            object = result.g2();
            int n = result.barRectWidth();
            int n2 = result.barRectHeight();
            Insets insets = result.b();
            int n3 = (int)Math.round((double)n * this.progressBar.getPercentComplete());
            long l2 = l = this.progressBar.getPercentComplete() < 100.0 ? 0L : 10L;
            if (n3 > 0) {
                ((Graphics)object).setColor(this.progressBar.getForeground());
                ((Graphics2D)object).fill(new RoundRectangle2D.Float(insets.left, insets.top, n3, n2, l, l));
            }
            if (this.progressBar.isStringPainted()) {
                this.paintText((Graphics)object, insets.left, insets.top, n, n2);
            }
        }

        @Override
        protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
            Object object = this.setClippingAndGetBorder(graphics);
            if (!(object instanceof Result)) {
                return;
            }
            Result result = object;
            object = result.g2();
            int n = result.barRectWidth();
            Insets insets = result.b();
            int n2 = result.barRectHeight();
            ((Graphics2D)object).setPaint(this.getGradientPaint(n, insets));
            ((Graphics2D)object).fill(new RoundRectangle2D.Float(insets.left, insets.top, n, n2, 10.0f, 10.0f));
            if (this.progressBar.isStringPainted()) {
                this.paintText((Graphics)object, insets.left, insets.top, n, n2);
            }
        }

        private GradientPaint getGradientPaint(int n, Insets insets) {
            int n2 = n / 2;
            int n3 = insets.left + (this.animationIndex += 10);
            if (n3 > n) {
                this.animationIndex = 0;
            }
            return new GradientPaint(n3, insets.top, this.progressBar.getForeground(), n3 + n2, insets.top, BreezeTheme.getInstance().getProgressGradientBackground(), true);
        }

        private Result setClippingAndGetBorder(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                return null;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Insets insets = this.progressBar.getInsets();
            int n = this.progressBar.getWidth() - (insets.right + insets.left);
            int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
            if (n <= 0 || n2 <= 0) {
                return null;
            }
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(insets.left, insets.top, n, n2, 10.0f, 10.0f);
            graphics2D.setClip(float_);
            graphics2D.setColor(BreezeTheme.getInstance().getProgressBackground());
            graphics2D.fill(float_);
            return new Result(graphics2D, insets, n, n2);
        }

        protected void paintText(Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            String string = this.progressBar.getString();
            Point point = this.getStringPlacement(graphics2D, string, n3, n4);
            graphics2D.setColor(BreezeTheme.getInstance().getProgressForeground());
            graphics2D.drawString(string, point.x + n, point.y + n2);
        }

        protected Point getStringPlacement(Graphics graphics, String string, int n, int n2) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.progressBar.getFont());
            int n3 = fontMetrics.stringWidth(string);
            int n4 = (n - n3) / 2;
            int n5 = (n2 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2;
            return new Point(n4, n5);
        }

        private record Result(Graphics2D g2, Insets b, int barRectWidth, int barRectHeight) {
        }
    }
}

