/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeRadioButton
extends JRadioButton {
    public BreezeRadioButton() {
        this("", (ButtonGroup)null);
    }

    public BreezeRadioButton(String string, ButtonGroup buttonGroup) {
        this(string, buttonGroup, false);
    }

    public BreezeRadioButton(String string, ButtonGroup buttonGroup, boolean bl) {
        this(string, buttonGroup, bl, null);
    }

    public BreezeRadioButton(String string, ButtonGroup buttonGroup, boolean bl, RadioButtonCallback radioButtonCallback) {
        this(string, 16, buttonGroup, bl, radioButtonCallback);
    }

    public BreezeRadioButton(String string, int n, ButtonGroup buttonGroup, boolean bl, RadioButtonCallback radioButtonCallback) {
        super(string, bl);
        this.setOpaque(false);
        this.setFont(new Font(this.getFont().getFontName(), 0, n));
        this.setCursor(BreezeFrame.getHandCursor());
        this.setFocusable(false);
        if (buttonGroup != null) {
            buttonGroup.add(this);
        }
        this.setCallback(radioButtonCallback);
        this.setForeground(BreezeTheme.getInstance().getLabelForeground());
    }

    public void setCallback(RadioButtonCallback radioButtonCallback) {
        if (radioButtonCallback != null) {
            this.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    radioButtonCallback.selected(this, this.isSelected());
                }
            });
        }
    }

    static void main() {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("BreezeRadioButton Example");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(400, 300);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBackground(Color.WHITE);
            ButtonGroup buttonGroup = new ButtonGroup();
            BreezeRadioButton breezeRadioButton2 = new BreezeRadioButton("Option 1", buttonGroup, true, (breezeRadioButton, bl) -> System.out.println("Option 1 selected: " + bl));
            BreezeRadioButton breezeRadioButton3 = new BreezeRadioButton("Option 2", buttonGroup, false, (breezeRadioButton, bl) -> System.out.println("Option 2 selected: " + bl));
            BreezeRadioButton breezeRadioButton4 = new BreezeRadioButton("Option 3", buttonGroup, false, (breezeRadioButton, bl) -> System.out.println("Option 3 selected: " + bl));
            jPanel.add(Box.createVerticalStrut(20));
            jPanel.add(breezeRadioButton2);
            jPanel.add(Box.createVerticalStrut(10));
            jPanel.add(breezeRadioButton3);
            jPanel.add(Box.createVerticalStrut(10));
            jPanel.add(breezeRadioButton4);
            jFrame.add(jPanel);
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        });
    }

    public static interface RadioButtonCallback {
        public void selected(BreezeRadioButton var1, boolean var2);
    }
}

