/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import javax.swing.JFrame;
import javax.swing.JSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSliderUI;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeRangeSlider
extends JSlider {
    public BreezeRangeSlider(int n, int n2, int n3, int n4) {
        super(n, n2);
        this.setOpaque(false);
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.setOrientation(0);
        this.setValue(n3);
        this.setUpperValue(n4);
        this.setFocusable(false);
    }

    @Override
    public void updateUI() {
        this.setUI(new BreezeRangeSliderUI(this));
        this.updateLabelUIs();
    }

    @Override
    public int getValue() {
        return super.getValue();
    }

    @Override
    public void setValue(int n) {
        int n2 = this.getValue();
        if (n2 == n) {
            return;
        }
        int n3 = this.getExtent();
        int n4 = Math.min(Math.max(this.getMinimum(), n), n2 + n3);
        int n5 = n3 + n2 - n4;
        this.getModel().setRangeProperties(n4, n5, this.getMinimum(), this.getMaximum(), this.getValueIsAdjusting());
    }

    public int getUpperValue() {
        return this.getValue() + this.getExtent();
    }

    public void setUpperValue(int n) {
        int n2 = this.getValue();
        int n3 = Math.min(Math.max(0, n - n2), this.getMaximum() - n2);
        this.setExtent(n3);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Range Slider Example");
        BreezeRangeSlider breezeRangeSlider = new BreezeRangeSlider(0, 100, 20, 50);
        jFrame.add(breezeRangeSlider);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

