/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;

public class BreezeRangeSliderPanel
extends JPanel {
    private final BreezeRangeSlider slider;
    private final BreezeInputField.Number lowValueField;
    private final BreezeInputField.Number highValueField;
    private final float decimalFactor;
    private final SliderCallback callback;
    private boolean changeFromInputField;

    public BreezeRangeSliderPanel(float f, float f2, float f3, float f4, float f5, SliderCallback sliderCallback) {
        this(f, f2, f3, f4, f5, sliderCallback, BreezeInputFieldHelper.Format.TwoRows);
    }

    public BreezeRangeSliderPanel(float f, float f2, float f3, float f4, float f5, SliderCallback sliderCallback, BreezeInputFieldHelper.Format format) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.decimalFactor = f5;
        this.callback = sliderCallback;
        int n = (int)(f * f5);
        int n2 = (int)(f2 * f5);
        int n3 = (int)(f3 * f5);
        int n4 = (int)(f4 * f5);
        this.slider = new BreezeRangeSlider(n, n2, n3, n4);
        this.lowValueField = new BreezeInputField.Number("", f3, " ");
        this.lowValueField.setNumberField(true, f, f2);
        this.lowValueField.addValidator(new NumericMinMaxValidator(f, f2));
        this.highValueField = new BreezeInputField.Number("", f4, " ");
        this.highValueField.setNumberField(true, f, f2);
        this.highValueField.addValidator(new NumericMinMaxValidator(f, f2));
        this.initSlider(n3, n4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.lowValueField.getTextField().setPreferredSize(new Dimension(75, 25));
        this.add((Component)this.lowValueField, gridBagConstraints);
        if (format == BreezeInputFieldHelper.Format.TwoRows) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridx = 1;
            this.highValueField.getTextField().setPreferredSize(new Dimension(75, 25));
            this.add((Component)this.highValueField, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        if (format == BreezeInputFieldHelper.Format.TwoRows) {
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(3, 4, 0, 4);
        }
        this.add((Component)this.slider, gridBagConstraints);
        if (format == BreezeInputFieldHelper.Format.OneRow) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            this.highValueField.getTextField().setPreferredSize(new Dimension(75, 25));
            this.add((Component)this.highValueField, gridBagConstraints);
        }
    }

    private void initSlider(int n, int n2) {
        this.slider.setOrientation(0);
        this.slider.setValue(n);
        this.slider.setUpperValue(n2);
        this.slider.updateUI();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.slider.addChangeListener(changeEvent -> {
            JSlider jSlider;
            if (atomicBoolean.get()) {
                return;
            }
            float f = (float)this.slider.getValue() / this.decimalFactor;
            float f2 = (float)this.slider.getUpperValue() / this.decimalFactor;
            if (!this.changeFromInputField) {
                this.lowValueField.setValue(f);
                this.highValueField.setValue(f2);
            }
            if (!(jSlider = (JSlider)changeEvent.getSource()).getValueIsAdjusting()) {
                this.highValueField.clearValidators();
                this.highValueField.addValidator(new NumericMinMaxValidator(f, (float)this.slider.getMaximum() / this.decimalFactor));
                this.lowValueField.clearValidators();
                this.lowValueField.addValidator(new NumericMinMaxValidator((float)this.slider.getMinimum() / this.decimalFactor, f2));
                MinMax minMax = this.callback.onChange(new MinMax(f, f2));
                atomicBoolean.set(true);
                try {
                    this.lowValueField.setValue(this.decimalFactor == 1.0f ? (double)minMax.min().intValue() : (double)minMax.min().floatValue());
                    this.highValueField.setValue(this.decimalFactor == 1.0f ? (double)minMax.max().intValue() : (double)minMax.max().floatValue());
                    this.slider.setUpperValue((int)(minMax.max().floatValue() * this.decimalFactor));
                    this.slider.setValue((int)(minMax.min().floatValue() * this.decimalFactor));
                }
                finally {
                    atomicBoolean.set(false);
                }
            }
        });
        this.lowValueField.addChangeListener(textActionEvent -> {
            float f = this.lowValueField.getNumberFloat() * this.decimalFactor;
            this.changeFromInputField = true;
            this.slider.setValue((int)f);
            this.changeFromInputField = false;
        });
        this.highValueField.addChangeListener(textActionEvent -> {
            float f = this.highValueField.getNumberFloat() * this.decimalFactor;
            this.changeFromInputField = true;
            this.slider.setUpperValue((int)f);
            this.changeFromInputField = false;
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Range Slider Example");
        BreezeRangeSliderPanel breezeRangeSliderPanel = new BreezeRangeSliderPanel(0.0f, 1.0f, 0.2f, 0.3f, 10.0f, minMax -> {
            System.out.println(minMax.formatRange());
            return new MinMax(minMax.min().floatValue() - 0.1f, minMax.max().floatValue());
        }, BreezeInputFieldHelper.Format.OneRow);
        BreezeRangeSliderPanel breezeRangeSliderPanel2 = new BreezeRangeSliderPanel(0.0f, 100.0f, 20.0f, 49.0f, 1.0f, minMax -> {
            System.out.println(minMax.formatRange());
            return new MinMax(minMax.min().floatValue() - 1.0f, minMax.max().floatValue());
        }, BreezeInputFieldHelper.Format.OneRow);
        jFrame.add(breezeRangeSliderPanel2);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setPreferredSize(new Dimension(500, 150));
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static interface SliderCallback {
        public MinMax onChange(MinMax var1);
    }
}

