/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSlider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.BreezeSliderUI;

public class BreezeRangeSliderUI
extends BasicSliderUI {
    private final Color rangeColor = BreezeTheme.getInstance().getProgressBarColor();
    private final Color sliderThumbColor = BreezeTheme.getInstance().getSliderThumbColor();
    private Rectangle upperThumbRect;
    private boolean upperThumbSelected;
    private transient boolean lowerDragging;
    private transient boolean upperDragging;

    public BreezeRangeSliderUI(BreezeRangeSlider breezeRangeSlider) {
        super(breezeRangeSlider);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.upperThumbRect = new Rectangle();
        super.installUI(jComponent);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    @Override
    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler();
    }

    @Override
    protected void calculateThumbSize() {
        super.calculateThumbSize();
        this.upperThumbRect.setSize(this.thumbRect.width, this.thumbRect.height);
    }

    @Override
    protected void calculateThumbLocation() {
        int n;
        super.calculateThumbLocation();
        if (this.slider.getSnapToTicks()) {
            int n2 = n = this.slider.getValue() + this.slider.getExtent();
            int n3 = this.slider.getMajorTickSpacing();
            int n4 = this.slider.getMinorTickSpacing();
            int n5 = 0;
            if (n4 > 0) {
                n5 = n4;
            } else if (n3 > 0) {
                n5 = n3;
            }
            if (n5 != 0) {
                if ((n - this.slider.getMinimum()) % n5 != 0) {
                    float f = (float)(n - this.slider.getMinimum()) / (float)n5;
                    int n6 = Math.round(f);
                    n2 = this.slider.getMinimum() + n6 * n5;
                }
                if (n2 != n) {
                    this.slider.setExtent(n2 - this.slider.getValue());
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = n - this.upperThumbRect.width / 2;
            this.upperThumbRect.y = this.trackRect.y;
        } else {
            n = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
            this.upperThumbRect.x = this.trackRect.x;
            this.upperThumbRect.y = n - this.upperThumbRect.height / 2;
        }
    }

    @Override
    protected Dimension getThumbSize() {
        return BreezeSliderUI.THUMB_SIZE;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(graphics, jComponent);
        Rectangle rectangle = graphics.getClipBounds();
        if (this.upperThumbSelected) {
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
        } else {
            if (rectangle.intersects(this.upperThumbRect)) {
                this.paintUpperThumb(graphics);
            }
            if (rectangle.intersects(this.thumbRect)) {
                this.paintLowerThumb(graphics);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTrack(Graphics graphics) {
        super.paintTrack(graphics);
        Rectangle rectangle = this.trackRect;
        int n = this.thumbRect.x + this.thumbRect.width / 2;
        int n2 = this.upperThumbRect.x + this.upperThumbRect.width / 2;
        int n3 = rectangle.height / 2 - 2;
        graphics.translate(rectangle.x, rectangle.y + n3);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            int n4 = rectangle.width;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n4, 4.0, 5.0, 5.0);
            Color color = BreezeTheme.getInstance().getLabelForegroundMoreDifuse();
            graphics2D.setColor(color);
            graphics2D.fill(double_);
            graphics2D.setClip(double_);
            graphics2D.setColor(this.rangeColor);
            graphics2D.fillRect(n - rectangle.x, 0, n2 - n, 4);
        }
        finally {
            graphics2D.dispose();
        }
        graphics.translate(-rectangle.x, -(rectangle.y + n3));
    }

    @Override
    public void paintThumb(Graphics graphics) {
    }

    private void paintLowerThumb(Graphics graphics) {
        this.paintAThumb(graphics, this.thumbRect, this.sliderThumbColor);
    }

    private void paintUpperThumb(Graphics graphics) {
        this.paintAThumb(graphics, this.upperThumbRect, this.sliderThumbColor);
    }

    private void paintAThumb(Graphics graphics, Rectangle rectangle, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, rectangle.width, rectangle.height);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(rectangle.x, rectangle.y);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        graphics2D.dispose();
    }

    private void setUpperThumbLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.upperThumbRect);
        this.upperThumbRect.setLocation(n, n2);
        SwingUtilities.computeUnion(this.upperThumbRect.x, this.upperThumbRect.y, this.upperThumbRect.width, this.upperThumbRect.height, rectangle);
        this.slider.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByBlock(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n2 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n2 = 1;
            }
            int n3 = n2 * (n > 0 ? 1 : -1);
            if (this.upperThumbSelected) {
                int n4 = ((BreezeRangeSlider)this.slider).getUpperValue();
                ((BreezeRangeSlider)this.slider).setUpperValue(n4 + n3);
            } else {
                int n5 = this.slider.getValue();
                this.slider.setValue(n5 + n3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollByUnit(int n) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n2;
            int n3 = n2 = n > 0 ? 1 : -1;
            if (this.upperThumbSelected) {
                int n4 = ((BreezeRangeSlider)this.slider).getUpperValue();
                ((BreezeRangeSlider)this.slider).setUpperValue(n4 + n2);
            } else {
                int n5 = this.slider.getValue();
                this.slider.setValue(n5 + n2);
            }
        }
    }

    public class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        public RangeTrackListener() {
            super(BreezeRangeSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!BreezeRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BreezeRangeSliderUI.this.slider.isRequestFocusEnabled()) {
                BreezeRangeSliderUI.this.slider.requestFocus();
            }
            boolean bl = false;
            boolean bl2 = false;
            if (BreezeRangeSliderUI.this.upperThumbSelected || BreezeRangeSliderUI.this.slider.getMinimum() == BreezeRangeSliderUI.this.slider.getValue()) {
                if (BreezeRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl2 = true;
                } else if (BreezeRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                    bl = true;
                }
            } else if (BreezeRangeSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl = true;
            } else if (BreezeRangeSliderUI.this.upperThumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                bl2 = true;
            }
            if (bl) {
                switch (BreezeRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.x;
                    }
                }
                BreezeRangeSliderUI.this.upperThumbSelected = false;
                BreezeRangeSliderUI.this.lowerDragging = true;
                return;
            }
            BreezeRangeSliderUI.this.lowerDragging = false;
            if (bl2) {
                switch (BreezeRangeSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BreezeRangeSliderUI.this.upperThumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BreezeRangeSliderUI.this.upperThumbRect.x;
                    }
                }
                BreezeRangeSliderUI.this.upperThumbSelected = true;
                BreezeRangeSliderUI.this.upperDragging = true;
                return;
            }
            BreezeRangeSliderUI.this.upperDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BreezeRangeSliderUI.this.lowerDragging = false;
            BreezeRangeSliderUI.this.upperDragging = false;
            BreezeRangeSliderUI.this.slider.setValueIsAdjusting(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!BreezeRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (BreezeRangeSliderUI.this.lowerDragging) {
                BreezeRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveLowerThumb();
            } else if (BreezeRangeSliderUI.this.upperDragging) {
                BreezeRangeSliderUI.this.slider.setValueIsAdjusting(true);
                this.moveUpperThumb();
            }
        }

        @Override
        public boolean shouldScroll(int n) {
            return false;
        }

        private void moveLowerThumb() {
            int n = 0;
            switch (BreezeRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.y;
                    int n5 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.y + (((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.height - 1);
                    int n6 = BreezeRangeSliderUI.this.yPositionForValue(BreezeRangeSliderUI.this.slider.getValue() + BreezeRangeSliderUI.this.slider.getExtent());
                    if (BreezeRangeSliderUI.this.drawInverted()) {
                        n5 = n6;
                    } else {
                        n4 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    BreezeRangeSliderUI.this.setThumbLocation(((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    BreezeRangeSliderUI.this.slider.setValue(BreezeRangeSliderUI.this.valueForYPosition(n));
                    break;
                }
                case 0: {
                    int n7 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.x;
                    int n10 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.x + (((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.width - 1);
                    int n11 = BreezeRangeSliderUI.this.xPositionForValue(BreezeRangeSliderUI.this.slider.getValue() + BreezeRangeSliderUI.this.slider.getExtent());
                    if (BreezeRangeSliderUI.this.drawInverted()) {
                        n9 = n11;
                    } else {
                        n10 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    BreezeRangeSliderUI.this.setThumbLocation(n8, ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    BreezeRangeSliderUI.this.slider.setValue(BreezeRangeSliderUI.this.valueForXPosition(n));
                    break;
                }
            }
        }

        private void moveUpperThumb() {
            int n = 0;
            switch (BreezeRangeSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n2 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.height / 2;
                    int n3 = this.currentMouseY - this.offset;
                    int n4 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.y;
                    int n5 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.y + (((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.height - 1);
                    int n6 = BreezeRangeSliderUI.this.yPositionForValue(BreezeRangeSliderUI.this.slider.getValue());
                    if (BreezeRangeSliderUI.this.drawInverted()) {
                        n4 = n6;
                    } else {
                        n5 = n6;
                    }
                    n3 = Math.max(n3, n4 - n2);
                    n3 = Math.min(n3, n5 - n2);
                    BreezeRangeSliderUI.this.setUpperThumbLocation(((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.x, n3);
                    n = n3 + n2;
                    BreezeRangeSliderUI.this.slider.setExtent(BreezeRangeSliderUI.this.valueForYPosition(n) - BreezeRangeSliderUI.this.slider.getValue());
                    break;
                }
                case 0: {
                    int n7 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.width / 2;
                    int n8 = this.currentMouseX - this.offset;
                    int n9 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.x;
                    int n10 = ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.x + (((BreezeRangeSliderUI)BreezeRangeSliderUI.this).trackRect.width - 1);
                    int n11 = BreezeRangeSliderUI.this.xPositionForValue(BreezeRangeSliderUI.this.slider.getValue());
                    if (BreezeRangeSliderUI.this.drawInverted()) {
                        n10 = n11;
                    } else {
                        n9 = n11;
                    }
                    n8 = Math.max(n8, n9 - n7);
                    n8 = Math.min(n8, n10 - n7);
                    BreezeRangeSliderUI.this.setUpperThumbLocation(n8, ((BreezeRangeSliderUI)BreezeRangeSliderUI.this).thumbRect.y);
                    n = n8 + n7;
                    BreezeRangeSliderUI.this.slider.setExtent(BreezeRangeSliderUI.this.valueForXPosition(n) - BreezeRangeSliderUI.this.slider.getValue());
                    break;
                }
            }
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!BreezeRangeSliderUI.this.lowerDragging && !BreezeRangeSliderUI.this.upperDragging) {
                BreezeRangeSliderUI.this.calculateThumbLocation();
                BreezeRangeSliderUI.this.slider.repaint();
            }
        }
    }
}

