/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class BreezeResizableImagePanel
extends JPanel {
    private BufferedImage originalImage;
    private Image scaledImage;
    private final String resourcePath;

    public BreezeResizableImagePanel(String string) {
        this.resourcePath = string;
        try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
            this.originalImage = ImageIO.read(inputStream);
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(this.originalImage.getWidth(), this.originalImage.getHeight()));
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    BreezeResizableImagePanel.this.resizeImage();
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void resizeImage() {
        Dimension dimension;
        Component component = this.findViewportOrParent(this);
        if (component instanceof JViewport) {
            JViewport jViewport = (JViewport)component;
            dimension = jViewport.getExtentSize();
        } else {
            dimension = component.getSize();
        }
        double d = (double)dimension.width * 0.8;
        double d2 = (double)dimension.height * 0.7;
        int n = this.originalImage.getWidth();
        int n2 = this.originalImage.getHeight();
        double d3 = Math.min(d / (double)n, d2 / (double)n2);
        d3 = Math.min(1.0, d3);
        int n3 = (int)Math.max(10.0, (double)n * d3);
        int n4 = (int)Math.max(10.0, (double)n2 * d3);
        this.scaledImage = this.originalImage.getScaledInstance(n3, n4, 4);
        this.setPreferredSize(new Dimension(n3, n4));
        this.revalidate();
        this.repaint();
    }

    private Component findViewportOrParent(Component component) {
        if (component instanceof JViewport) {
            return component;
        }
        Container container = component.getParent();
        if (container != null) {
            return this.findViewportOrParent(container);
        }
        return container != null ? container : this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.scaledImage != null) {
            int n = (this.getWidth() - this.scaledImage.getWidth(null)) / 2;
            int n2 = (this.getHeight() - this.scaledImage.getHeight(null)) / 2;
            graphics.drawImage(this.scaledImage, n, n2, this);
        }
    }

    @Override
    public String toString() {
        return this.resourcePath;
    }
}

