/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BreezeResponsivePanel
extends JPanel {
    private final ArrayList<JPanel> childPanels = new ArrayList();
    private final int preferredChildWidth;
    private final Component parenComponent;

    public BreezeResponsivePanel(Component component, int n) {
        this.parenComponent = component;
        this.preferredChildWidth = n;
        this.setLayout(new GridBagLayout());
        component.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BreezeResponsivePanel.this.updateLayout();
            }
        });
        this.setOpaque(false);
    }

    public void addChildPanel(JPanel jPanel) {
        this.childPanels.add(jPanel);
        this.updateLayout();
    }

    private void updateLayout() {
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        int n = this.parenComponent.getWidth();
        int n2 = n / this.preferredChildWidth;
        if (n2 == 0) {
            n2 = 1;
        }
        for (int i = 0; i < this.childPanels.size(); ++i) {
            JPanel jPanel = this.childPanels.get(i);
            gridBagConstraints.gridx = i % n2;
            gridBagConstraints.gridy = i / n2;
            this.add((Component)jPanel, gridBagConstraints);
        }
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Responsive Panel Example");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(400, 400);
            BreezeResponsivePanel breezeResponsivePanel = new BreezeResponsivePanel(jFrame.getContentPane(), 100);
            for (int i = 0; i < 10; ++i) {
                JPanel jPanel = new JPanel();
                jPanel.setBackground(new Color((int)(Math.random() * 1.6777216E7)));
                breezeResponsivePanel.addChildPanel(jPanel);
            }
            jFrame.add(new JScrollPane(breezeResponsivePanel));
            jFrame.setVisible(true);
        });
    }
}

