/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicScrollBarUI;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeScrollPane
extends JScrollPane {
    public BreezeScrollPane() {
        this(null, false);
    }

    public BreezeScrollPane(Component component) {
        this(component, false);
    }

    public BreezeScrollPane(Component component, boolean bl) {
        super(component);
        if (!bl) {
            this.setBorder(null);
            this.setViewportBorder(null);
        }
        this.getVerticalScrollBar().setUnitIncrement(16);
        BreezeScrollPane.setTheme(this);
    }

    public static void setTheme(JScrollPane jScrollPane) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        jScrollPane.setBackground(breezeTheme.getPanelBackground());
        jScrollPane.getVerticalScrollBar().setBackground(breezeTheme.getSettingPanelBackground());
        jScrollPane.getHorizontalScrollBar().setBackground(breezeTheme.getSettingPanelBackground());
        jScrollPane.getVerticalScrollBar().setUI(BreezeScrollPane.createUI(breezeTheme));
        jScrollPane.getHorizontalScrollBar().setUI(BreezeScrollPane.createUI(breezeTheme));
    }

    private static BasicScrollBarUI createUI(final BreezeTheme breezeTheme) {
        return new BasicScrollBarUI(){

            @Override
            protected void configureScrollBarColors() {
                this.thumbColor = breezeTheme.getPanelBackground150();
            }

            @Override
            protected JButton createDecreaseButton(int n) {
                JButton jButton = super.createDecreaseButton(n);
                jButton.setBackground(breezeTheme.getSettingPanelBackground());
                jButton.setBorder(BorderFactory.createEmptyBorder());
                return jButton;
            }

            @Override
            protected JButton createIncreaseButton(int n) {
                JButton jButton = super.createIncreaseButton(n);
                jButton.setBackground(breezeTheme.getSettingPanelBackground());
                jButton.setBorder(BorderFactory.createEmptyBorder());
                return jButton;
            }
        };
    }

    public void setLineBorder() {
        this.setViewportBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
    }

    public void scrollToTop() {
        SwingUtilities.invokeLater(() -> this.getVerticalScrollBar().setValue(0));
    }

    public void scrollToBottom() {
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Adjustable adjustable = adjustmentEvent.getAdjustable();
                adjustable.setValue(adjustable.getMaximum());
                BreezeScrollPane.this.getVerticalScrollBar().removeAdjustmentListener(this);
            }
        };
        this.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
    }

    public static class VerticalOnly
    extends BreezeScrollPane {
        public VerticalOnly(Component component) {
            super(component);
            this.setHorizontalScrollBarPolicy(31);
        }
    }
}

