/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRangeSliderPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.util.BreezeSliderUI;
import se.prediktera.breeze.hardware.camera.RemoteCameraSettings;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class BreezeSlider
extends JSlider {
    public static BreezeSliderInputField getSliderWithMinAndMaxFromServer(RemoteCameraSettings remoteCameraSettings, String string, String string2, SliderCallback sliderCallback, float f) {
        TcpManager.DataSettings dataSettings = remoteCameraSettings.getDataSettingsForProperty(string);
        if (!dataSettings.available().booleanValue()) {
            return null;
        }
        if (!dataSettings.hasSettings()) {
            return new BreezeSliderInputField(string2, 0.0f, 100.0f, f, sliderCallback);
        }
        float f2 = 0.0f;
        if (!dataSettings.min().isNaN()) {
            f2 = dataSettings.min().floatValue();
        }
        float f3 = 0.0f;
        if (!dataSettings.max().isNaN()) {
            f3 = dataSettings.max().floatValue();
        }
        boolean bl = dataSettings.inc().isNaN() || dataSettings.inc().floatValue() < 1.0f;
        BreezeSliderInputField breezeSliderInputField = new BreezeSliderInputField(string2, f2, f3, f, sliderCallback, bl ? 10.0f : 1.0f);
        if (!dataSettings.inc().isNaN()) {
            breezeSliderInputField.getSlider().setSnapToTicks(true);
            breezeSliderInputField.getSlider().setMinorTickSpacing(dataSettings.inc().intValue());
        }
        return breezeSliderInputField;
    }

    public BreezeSlider() {
        this(0, 100);
    }

    public BreezeSlider(int n, int n2) {
        this(n, n2, 25);
    }

    public BreezeSlider(int n, int n2, int n3) {
        super(n, n2);
        this.setOpaque(false);
        this.setUI(new BreezeSliderUI(this));
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.setRequestFocusEnabled(false);
        this.setPreferredSize(new Dimension(0, 12));
        this.setMinimumSize(new Dimension(0, 12));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("SLIDER");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().setBackground(BreezeTheme.getInstance().getPanelBackground());
        BreezeSliderInputField breezeSliderInputField = new BreezeSliderInputField("Snap", 0.0f, 10.0f, 1.5f, f -> System.out.println("slider1:" + f), 1.0f);
        breezeSliderInputField.getSlider().snapToTicks = true;
        BreezeSliderInputField breezeSliderInputField2 = new BreezeSliderInputField("Decimal", 0.0f, 10.0f, 1.5f, f -> System.out.println("slider2:" + f), 10.0f);
        BreezeSliderInputField breezeSliderInputField3 = new BreezeSliderInputField("Range", 0.0f, 10.0f, 1.5f, f -> System.out.println("slider3:" + f), 10.0f);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)breezeSliderInputField, "North");
        jFrame.getContentPane().add((Component)breezeSliderInputField2, "Center");
        jFrame.getContentPane().add((Component)new BreezeRangeSliderPanel(0.0f, 1.0f, 0.2f, 0.3f, 10.0f, minMax -> {
            System.out.println(minMax.formatRange());
            return minMax;
        }, BreezeInputFieldHelper.Format.OneRow), "South");
        jFrame.setSize(1000, 500);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    public static class BreezeSliderInputField
    extends JPanel {
        private boolean changingTextField = false;
        private final BreezeSlider slider;

        public BreezeSliderInputField(String string, float f, float f2, float f3, SliderCallback sliderCallback) {
            this(string, f, f2, f3, sliderCallback, 1.0f);
        }

        public BreezeSliderInputField(String string, float f, float f2, float f3, SliderCallback sliderCallback, float f4) {
            super(new GridBagLayout());
            this.setOpaque(false);
            int n = (int)(f * f4);
            int n2 = (int)(f2 * f4);
            int n3 = (int)(f3 * f4);
            this.slider = new BreezeSlider(n, n2);
            this.slider.setValue(n3);
            BreezeTextField breezeTextField = new BreezeTextField();
            this.slider.addChangeListener(changeEvent -> {
                if (!this.changingTextField) {
                    float f2 = (float)this.slider.getValue() / f4;
                    breezeTextField.setFormatedNumber(f2);
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    if (!jSlider.getValueIsAdjusting()) {
                        sliderCallback.onChange(f2);
                    }
                }
            });
            breezeTextField.setNumberField(true, f, f2);
            breezeTextField.setFormatedNumber(f4 == 1.0f ? (double)((int)f3) : (double)f3);
            breezeTextField.setBackground(BreezeTheme.getInstance().getPanelBackground());
            breezeTextField.addValidator(new NumericMinMaxValidator(f, f2));
            breezeTextField.setPreferredSize(new Dimension(75, 25));
            breezeTextField.addChangeListener(textActionEvent -> {
                this.changingTextField = true;
                float f2 = textActionEvent.getValueFloat() * f4;
                int n = (int)f2;
                this.slider.setValue(n);
                float f3 = (float)n / f4;
                sliderCallback.onChange(f3);
                breezeTextField.setFormatedNumber(f3);
                this.changingTextField = false;
            });
            if (string != null) {
                BreezeLabel breezeLabel = new BreezeLabel(string, false, 14);
                breezeLabel.setPreferredSize(new Dimension(270, 18));
                this.add((Component)breezeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.add((Component)this.slider, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)breezeTextField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.slider.setEnabled(bl);
        }

        @Generated
        public BreezeSlider getSlider() {
            return this.slider;
        }
    }

    public static interface SliderCallback {
        public void onChange(float var1);
    }
}

