/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.map.common.SwingTimer;

public class BreezeSpinner
extends JSpinner {
    protected boolean isUpdating = false;
    protected boolean isArrowKeyPressed = false;

    public BreezeSpinner(SpinnerNumberModel spinnerNumberModel) {
        super(spinnerNumberModel);
        this.setFont(new Font("Tahoma", 0, 14));
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBorder(BorderFactory.createLineBorder(breezeTheme.getPanelBackground150()));
        this.setBackground(breezeTheme.getPanelBackground());
        this.setForeground(breezeTheme.getLabelForeground());
        this.setPreferredSize(new Dimension(100, 25));
        Serializable serializable = this.getTextField();
        if (serializable instanceof JFormattedTextField) {
            final JFormattedTextField jFormattedTextField = serializable;
            serializable = NumberFormat.getNumberInstance(Locale.US);
            ((NumberFormat)serializable).setGroupingUsed(false);
            NumberFormatter numberFormatter = new NumberFormatter((NumberFormat)serializable){

                @Override
                public Object stringToValue(String string) throws ParseException {
                    if (string != null) {
                        string = string.replace(',', '.');
                    }
                    return super.stringToValue(string);
                }
            };
            numberFormatter.setAllowsInvalid(true);
            numberFormatter.setValueClass(Double.class);
            jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter));
            jFormattedTextField.setBackground(breezeTheme.getPanelBackground());
            jFormattedTextField.setForeground(breezeTheme.getLabelForeground());
            jFormattedTextField.setCaretColor(breezeTheme.getLabelForeground());
            jFormattedTextField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            jFormattedTextField.addFocusListener(new FocusAdapter(this){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    SwingUtilities.invokeLater(jFormattedTextField::selectAll);
                }
            });
            jFormattedTextField.setFocusable(true);
            jFormattedTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                        BreezeSpinner.this.isArrowKeyPressed = true;
                    }
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                        BreezeSpinner.this.isArrowKeyPressed = false;
                    }
                }

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }
            });
        }
        this.addChangeListener(this::validateAndClampValue);
    }

    private JFormattedTextField getTextField() {
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            return defaultEditor.getTextField();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAndClampValue(ChangeEvent changeEvent) {
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        try {
            JFormattedTextField jFormattedTextField;
            SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
            Double d = (Double)spinnerNumberModel.getMinimum();
            Double d2 = (Double)spinnerNumberModel.getMaximum();
            try {
                double d3 = ((Number)this.getValue()).doubleValue();
                if (d3 < d) {
                    this.setValue(d);
                } else if (d3 > d2) {
                    this.setValue(d2);
                }
            }
            catch (Exception exception) {
                this.setValue(spinnerNumberModel.getMinimum());
            }
            JFormattedTextField jFormattedTextField2 = this.getTextField();
            if (jFormattedTextField2 instanceof JFormattedTextField && (jFormattedTextField = jFormattedTextField2).hasFocus()) {
                SwingUtilities.invokeLater(() -> jFormattedTextField.setCaretPosition(jFormattedTextField.getText().length()));
            }
        }
        finally {
            this.isUpdating = false;
        }
    }

    public void setMinimum(float f) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        if ((double)f > (Double)spinnerNumberModel.getMaximum()) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum. Min:" + f + " Max:" + String.valueOf(spinnerNumberModel.getMaximum()));
        }
        this.isUpdating = true;
        try {
            spinnerNumberModel.setMinimum(Double.valueOf(f));
        }
        finally {
            this.isUpdating = false;
            this.validateAndClampValue(null);
        }
    }

    public void setMaximum(float f) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        if ((double)f < (Double)spinnerNumberModel.getMinimum()) {
            throw new IllegalArgumentException("Maximum cannot be less than minimum. Max:" + f + " Min:" + String.valueOf(spinnerNumberModel.getMinimum()));
        }
        this.isUpdating = true;
        try {
            spinnerNumberModel.setMaximum(Double.valueOf(f));
        }
        finally {
            this.isUpdating = false;
            this.validateAndClampValue(null);
        }
    }

    public void setStep(float f) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        this.isUpdating = true;
        try {
            spinnerNumberModel.setStepSize(f);
        }
        finally {
            this.isUpdating = false;
            this.validateAndClampValue(null);
        }
    }

    public void setNumberInputLocation(NumberInputLocation numberInputLocation) {
        Objects.requireNonNull(this.getTextField()).setHorizontalAlignment(numberInputLocation == NumberInputLocation.LEFT ? 2 : 4);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof JButton)) continue;
            component.setEnabled(this.isEnabled());
        }
    }

    public static enum NumberInputLocation {
        LEFT,
        RIGHT;

    }

    public static class NumberSpinner
    extends BreezeSpinner {
        private final List<BreezeComboBox.ItemCallback<Double>> callbacks = new ArrayList<BreezeComboBox.ItemCallback<Double>>();
        private final SwingTimer changeTimer = new SwingTimer(250, actionEvent -> this.triggerCallbacks(), false);

        public NumberSpinner(double d, double d2, double d3, double d4, BreezeComboBox.ItemCallback<Double> itemCallback) {
            super(new SpinnerNumberModel(d, d2, d3, d4));
            this.setValue(d);
            this.addChangeListener(changeEvent -> {
                if (this.isUpdating) {
                    return;
                }
                if (this.isArrowKeyPressed) {
                    this.changeTimer.restart();
                } else {
                    this.changeTimer.stop();
                    this.triggerCallbacks();
                }
            });
            if (itemCallback != null) {
                this.addCallback(itemCallback);
            }
        }

        public void addCallback(BreezeComboBox.ItemCallback<Double> itemCallback) {
            this.callbacks.add(itemCallback);
        }

        private void triggerCallbacks() {
            double d = this.getValueDouble();
            for (BreezeComboBox.ItemCallback<Double> itemCallback : this.callbacks) {
                itemCallback.onItem(d);
            }
        }

        public void setValueNoTrigger(double d) {
            try {
                this.isUpdating = true;
                this.setValue(d);
            }
            finally {
                this.isUpdating = false;
            }
        }

        public int getValueInt() {
            Object object = this.getValue();
            if (object instanceof Number) {
                Number number = (Number)object;
                return number.intValue();
            }
            throw new ClassCastException("Unsupported number type: " + this.getValue().getClass().getName());
        }

        public double getValueDouble() {
            SpinnerModel spinnerModel = this.getModel();
            if (spinnerModel instanceof SpinnerNumberModel) {
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)spinnerModel;
                double d = ((Number)this.getValue()).doubleValue();
                double d2 = ((Number)((Object)spinnerNumberModel.getMinimum())).doubleValue();
                double d3 = ((Number)((Object)spinnerNumberModel.getMaximum())).doubleValue();
                return Math.max(d2, Math.min(d3, d));
            }
            throw new ClassCastException("Unsupported number type: " + this.getValue().getClass().getName());
        }
    }

    public static class PercentSpinner
    extends NumberSpinner {
        public PercentSpinner(double d, BreezeComboBox.ItemCallback<Double> itemCallback) {
            super(d, 0.0, 1.0, 0.01, itemCallback);
        }
    }
}

