/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinner;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeSpinnerInputPanel
extends JPanel {
    private final BreezeSpinner.NumberSpinner spinner;
    private final BreezeLabel descLabel = new BreezeLabel("Name");
    private final BreezeLabel unitLabel = new BreezeLabel("");
    private final BreezeLabel usageLabel = new BreezeLabel("");
    private BreezeInputFieldHelper.Format format;

    public BreezeSpinnerInputPanel(String string, String string2, float f, float f2, float f3, float f4, String string3) {
        this(string, string2, f, f2, f3, f4, string3, null);
    }

    public BreezeSpinnerInputPanel(String string, String string2, float f, float f2, float f3, float f4, String string3, BreezeComboBox.ItemCallback<Double> itemCallback) {
        this(string, string2, f, f2, f3, f4, BreezeInputFieldHelper.Format.TwoRows, BreezeSpinner.NumberInputLocation.LEFT, string3, itemCallback);
    }

    public BreezeSpinnerInputPanel(String string, String string2, float f, float f2, float f3, float f4, BreezeInputFieldHelper.Format format, BreezeSpinner.NumberInputLocation numberInputLocation, String string3) {
        this(string, string2, f, f2, f3, f4, format, numberInputLocation, string3, null);
    }

    public BreezeSpinnerInputPanel(String string, String string2, float f, float f2, float f3, float f4, BreezeInputFieldHelper.Format format, BreezeSpinner.NumberInputLocation numberInputLocation, String string3, BreezeComboBox.ItemCallback<Double> itemCallback) {
        super(new GridBagLayout());
        this.format = format;
        this.setOpaque(false);
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.spinner = new BreezeSpinner.NumberSpinner(f4, f, f2, f3, itemCallback);
        this.descLabel.setText(string);
        this.usageLabel.setText(string2);
        this.unitLabel.setText(string3);
        BreezeInputFieldHelper.format(this, this.descLabel, this.spinner, this.unitLabel, this.usageLabel, format);
        this.spinner.setNumberInputLocation(numberInputLocation);
    }

    public void setMin(float f) {
        this.spinner.setMinimum(f);
    }

    public void setMax(float f) {
        this.spinner.setMaximum(f);
    }

    public void setStep(float f) {
        this.spinner.setStep(f);
    }

    public void setLabelWidth(int n) {
        this.descLabel.setPreferredSize(new Dimension(n, this.spinner.getPreferredSize().height));
    }

    public void setFormat(BreezeInputFieldHelper.Format format) {
        this.format = format;
        BreezeInputFieldHelper.format(this, this.descLabel, this.spinner, this.unitLabel, this.usageLabel, this.format);
    }

    public void setUsageWidth(int n) {
        this.usageLabel.setPreferredSize(new Dimension(n, this.spinner.getPreferredSize().height));
    }

    public void setUsage(String string) {
        this.usageLabel.setText(string);
        this.setFormat(this.format);
    }

    public void setUnitLabelWidth(int n) {
        this.unitLabel.setPreferredSize(new Dimension(n, this.spinner.getPreferredSize().height));
    }

    public void setUnit(String string) {
        this.unitLabel.setText(string);
        this.unitLabel.setVisible(!string.isEmpty());
    }

    public String getUnit() {
        return this.unitLabel.getText();
    }

    public JFormattedTextField getTextArea() {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        return defaultEditor.getTextField();
    }

    public void setText(String string) {
        this.getTextArea().setText(string);
    }

    public void setValueWidth(int n) {
        this.spinner.setPreferredSize(new Dimension(n, this.spinner.getPreferredSize().height));
    }

    public void addCallback(BreezeComboBox.ItemCallback<Double> itemCallback) {
        this.spinner.addCallback(itemCallback);
    }

    public int getValueInt() {
        return this.spinner.getValueInt();
    }

    public double getValueDouble() {
        return this.spinner.getValueDouble();
    }

    public float getValueFloat() {
        return (float)this.spinner.getValueDouble();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.spinner.setEnabled(bl);
        this.usageLabel.setEnabled(bl);
        this.unitLabel.setEnabled(bl);
        this.descLabel.setEnabled(bl);
    }

    public void setValue(int n) {
        this.spinner.setValue(n);
    }

    public void setValue(double d) {
        this.spinner.setValue(d);
    }

    public void setValueNoTrigger(double d) {
        this.spinner.setValueNoTrigger(d);
    }

    public void requestFocusAndSelectAll() {
        this.getTextArea().selectAll();
        this.getTextArea().requestFocus();
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("BreezeSpinnerPanel Demo");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(400, 300);
            jFrame.setLayout(new FlowLayout());
            BreezeSpinnerInputPanel breezeSpinnerInputPanel = new BreezeSpinnerInputPanel("Description", "usage", 0.0f, 10.0f, 0.1f, 9.0f, BreezeInputFieldHelper.Format.TwoRows, BreezeSpinner.NumberInputLocation.LEFT, "mm", System.out::println);
            jFrame.add(breezeSpinnerInputPanel);
            breezeSpinnerInputPanel.setMax(8.0f);
            jFrame.add(new JButton("Click me"));
            jFrame.setVisible(true);
        });
    }
}

