/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeSplitPane
extends JSplitPane {
    public BreezeSplitPane() {
        this(1);
    }

    public BreezeSplitPane(int n) {
        super(n);
        this.setBorder(BorderFactory.createEmptyBorder());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        BasicSplitPaneDivider basicSplitPaneDivider = this.getDivider();
        basicSplitPaneDivider.setBackground(breezeTheme.getSettingPanelBackground());
        basicSplitPaneDivider.setBorder(BorderFactory.createEmptyBorder());
    }

    public BasicSplitPaneDivider getDivider() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof BasicSplitPaneDivider)) continue;
            return (BasicSplitPaneDivider)this.getComponent(i);
        }
        return null;
    }

    public static class BreezeLegendSplitPane
    extends BreezeSplitPane {
        private static int legendLastDividerSize;
        private Component legend;

        public BreezeLegendSplitPane(int n) {
            legendLastDividerSize = n;
            this.setResizeWeight(1.0);
            this.setDividerSize(0);
        }

        public void showLegend(boolean bl) {
            SwingUtilities.invokeLater(() -> {
                if (bl) {
                    this.legend.setVisible(true);
                    this.setDividerLocation(this.getSize().width - legendLastDividerSize);
                    this.setDividerSize(5);
                } else {
                    this.legend.setVisible(false);
                    this.setDividerSize(0);
                    this.setDividerLocation(Integer.MAX_VALUE);
                }
            });
        }

        public void setLegend(Component component) {
            this.legend = component;
            component.setPreferredSize(new Dimension(legendLastDividerSize, 100));
            component.setMinimumSize(new Dimension(100, 100));
            this.setRightComponent(component);
            this.addPropertyChangeListener("dividerLocation", propertyChangeEvent -> {
                if (component.isVisible()) {
                    legendLastDividerSize = this.getSize().width - this.getDividerLocation();
                }
            });
            component.setVisible(false);
        }
    }
}

