/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.swing.BreezeListScrollButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.TabEntry;

public class BreezeTabList
extends JPanel {
    private final TabEntry tabEntry = new TabEntry(this);
    private final LabelEntry labelEntry = new LabelEntry(150, 30, 16, false);
    private Object source;
    private final List<ActionListener> actionListenerList = new ArrayList<ActionListener>();
    private boolean updating = false;
    private final JList list = new JList();
    private final BreezeScrollPane listScrollPane = new BreezeScrollPane();
    private final BreezeListScrollButton tabList = new BreezeListScrollButton();

    public BreezeTabList() {
        super(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.tabList.setModel(new ArrayListModel(new ArrayList()));
        this.tabList.setSelectionMode(0);
        this.tabList.setLayoutOrientation(2);
        this.tabList.setMinimumSize(new Dimension(27, 30));
        this.tabList.setPreferredSize(new Dimension(27, 30));
        this.tabList.setSelectionBackground(new Color(210, 210, 210));
        this.tabList.setSelectionForeground(new Color(30, 30, 30));
        this.tabList.setVisibleRowCount(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.tabList, gridBagConstraints);
        this.listScrollPane.setBorder(null);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.list.setModel(new ArrayListModel(new ArrayList()));
        this.list.setLayoutOrientation(2);
        this.list.setSelectionBackground(new Color(150, 150, 150));
        this.list.setVisibleRowCount(0);
        this.list.addListSelectionListener(this::listValueChanged);
        this.list.setCellRenderer(this.labelEntry);
        this.list.setBackground(breezeTheme.getPanelBackground());
        this.list.setForeground(breezeTheme.getLabelForeground());
        this.listScrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane, gridBagConstraints);
        this.setTabCellRenderer(this.tabEntry);
        this.tabList.addListSelectionListener(this::tabListValueChanged);
    }

    public void addChangeListener(ActionListener actionListener) {
        this.actionListenerList.add(actionListener);
    }

    public ListModel getModel() {
        return this.tabList.getModel();
    }

    public Object getSource() {
        return this.source;
    }

    public void removeChangeListener(ActionListener actionListener) {
        this.actionListenerList.remove(actionListener);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.tabList != null) {
            this.tabList.setBackground(color);
        }
        if (this.tabEntry != null) {
            this.tabEntry.setBackground(color);
        }
    }

    public BreezeListScrollButton getTabList() {
        return this.tabList;
    }

    public JList getList() {
        return this.list;
    }

    public void setSelectionBackground(Color color) {
        if (this.tabList != null) {
            this.tabList.setSelectionBackground(color);
        }
        this.list.setSelectionBackground(color);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.list.setEnabled(bl);
    }

    public void setList(List list, Object object) {
        this.source = object;
        Object object2 = this.tabList.getSelectedValue();
        this.setModel(new ArrayListModel(list));
        if (object2 != null) {
            this.tabList.setSelectedValue(object2, true);
        }
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.list.setCellRenderer(listCellRenderer);
    }

    public void setModel(ListModel listModel) {
        this.updating = true;
        this.tabList.setModel(listModel);
        if (listModel.getSize() > 0) {
            this.tabList.setVisible(true);
            this.tabList.setSelectedIndex(0);
            this.listScrollPane.setVisible(true);
        } else {
            this.tabList.setVisible(false);
            this.list.setModel(new ArrayListModel(new ArrayList()));
            this.listScrollPane.setVisible(false);
        }
        this.updating = false;
    }

    public void setTabCellRenderer(ListCellRenderer listCellRenderer) {
        this.tabList.setCellRenderer(listCellRenderer);
    }

    private void listValueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        if (!this.updating && !listSelectionEvent.getValueIsAdjusting() && (object = this.tabList.getSelectedValue()) instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)object;
            Object e = this.list.getSelectedValue();
            if (e != null) {
                categoryFactor.setValue(e.toString(), (Sample)this.source);
                this.tabList.repaint();
                this.triggerChange("valuechanged");
            }
        }
    }

    private void tabListValueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = this.tabList.getSelectedValue();
        if (object instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)object;
            CatClass catClass = null;
            Object object2 = this.source;
            if (object2 instanceof Sample) {
                Sample sample = (Sample)object2;
                catClass = new CatClass(categoryFactor.getEntryString(sample), categoryFactor);
            } else {
                Object e;
                List list;
                object2 = this.source;
                if (object2 instanceof List && (list = (List)object2).size() == 1 && (e = list.get(0)) instanceof Sample) {
                    object2 = (Sample)e;
                    catClass = new CatClass(categoryFactor.getEntryString((BasicSample)object2), categoryFactor);
                }
            }
            this.list.setModel(new ArrayListModel(categoryFactor.getClasses()));
            if (catClass != null) {
                this.list.setSelectedValue(catClass, true);
            }
        } else {
            this.list.setModel(new ArrayListModel(new ArrayList()));
        }
    }

    private void triggerChange(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 0, string);
        for (ActionListener actionListener : this.actionListenerList) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

