/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class BreezeTabbedPanel
extends JTabbedPane {
    public BreezeTabbedPanel() {
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setUI(new BreezeTabbedPaneUI());
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = BreezeTabbedPanel.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n >= 0) {
                    BreezeTabbedPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    BreezeTabbedPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public int getLastTabIndex() {
        return this.getTabCount() - 1;
    }

    @Override
    public void addTab(String string, Component component) {
        int n = this.getTabCount();
        super.addTab(string, component);
        BreezeLabel breezeLabel = new BreezeLabel(string, false, 14);
        breezeLabel.setPreferredSize(new Dimension(150, 25));
        this.setTabComponentAt(n, breezeLabel);
    }

    public static class BreezeTabbedPaneUI
    extends BasicTabbedPaneUI {
        @Override
        protected void installDefaults() {
            Color color;
            super.installDefaults();
            this.lightHighlight = color = BreezeTheme.getInstance().getLabelForegroundMoreDifuse();
            this.shadow = BreezeTheme.getInstance().getPanelBackground();
            this.darkShadow = color;
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            Rectangle rectangle = this.tabPane.getBounds();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            super.paint(graphics, jComponent);
        }
    }
}

