/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import se.prediktera.breeze.frontend.common.swing.AbstractBreezeTextPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CrossPanel;

public class BreezeTextArea
extends AbstractBreezeTextPanel {
    private final CrossPanel crossPanel;
    private final BreezeScrollPane scrollPane;
    private final JTextArea textArea = new JTextArea();

    public BreezeTextArea(String string, boolean bl) {
        this(10, bl);
        this.textArea.setText(string);
    }

    public BreezeTextArea() {
        this(10, false);
    }

    public BreezeTextArea(int n, boolean bl) {
        this.crossPanel = new CrossPanel();
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Tahoma", 0, 16));
        this.textArea.setRows(5);
        this.textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                BreezeTextArea.this.textAreaMousePressed(mouseEvent);
            }
        });
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BreezeTextArea.this.textAreaFocusGained(focusEvent);
            }
        });
        this.scrollPane = new BreezeScrollPane.VerticalOnly(this.textArea);
        this.scrollPane.setBorder(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.scrollPane, gridBagConstraints);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.crossPanel.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.crossPanel.setMinimumSize(new Dimension(20, 20));
        this.crossPanel.setPreferredSize(new Dimension(20, 20));
        this.crossPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeTextArea.this.crossPanelMouseClicked(mouseEvent);
            }
        });
        this.crossPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add((Component)this.crossPanel, gridBagConstraints);
        this.textArea.setRows(n);
        this.textArea.setLineWrap(n > 1);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setForeground(breezeTheme.getLabelForeground());
        this.textArea.setCaretColor(breezeTheme.getLabelForeground());
        Color color = breezeTheme.getSettingPanelBackground();
        if (bl) {
            color = breezeTheme.getDialogBackground();
        }
        this.crossPanel.setBackground(color);
        this.setBackground(color);
        this.textArea.setBackground(color);
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().addDocumentListener(documentListener);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.textArea.addKeyListener(keyListener);
    }

    @Override
    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public void setTextBackground(Color color) {
        this.textArea.setBackground(color);
        this.crossPanel.setBackground(color);
        this.setBackground(color);
    }

    public void setTextForeground(Color color) {
        this.textArea.setForeground(color);
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    @Override
    public Object getSelectedText() {
        return this.textArea.getSelectedText();
    }

    @Override
    public String getText() {
        return this.textArea.getText();
    }

    @Override
    public boolean isEnabled() {
        return this.textArea.isEnabled();
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.textArea.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void replaceSelection(String string) {
        this.textArea.replaceSelection(string);
    }

    @Override
    public void requestFocusAndSelectAll() {
        if (this.textArea.isEditable()) {
            this.textArea.requestFocus();
            this.textArea.selectAll();
        }
    }

    public void setLineWrap(boolean bl) {
        this.textArea.setLineWrap(bl);
    }

    @Override
    public void setCaretPosition(int n) {
        this.textArea.setCaretPosition(n);
    }

    public void hideCaret() {
        this.textArea.setCaretColor(this.getBackground());
    }

    public void setColumns(int n) {
        this.textArea.setColumns(n);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textArea.setEnabled(bl);
        this.crossPanel.setVisible(bl && this.isEditable());
    }

    public void setRows(int n) {
        this.textArea.setRows(n);
    }

    public void setFontSize(int n) {
        this.textArea.setFont(new Font("Tahoma", 0, n));
    }

    @Override
    protected void setTextInComponent(String string) {
        this.textArea.setText(string);
    }

    public void hideVerticalScrollBar() {
        this.scrollPane.setVerticalScrollBarPolicy(21);
    }

    @Override
    public boolean supportMultipleLines() {
        return true;
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
        this.crossPanel.setVisible(bl);
    }

    private void crossPanelMouseClicked(MouseEvent mouseEvent) {
        this.textArea.setText("");
    }

    private void textAreaFocusGained(FocusEvent focusEvent) {
        if (this.textArea.isEditable()) {
            this.textArea.selectAll();
        }
    }

    private void textAreaMousePressed(MouseEvent mouseEvent) {
        this.showKeyboard();
    }
}

