/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.AbstractBreezeTextPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextFieldEmptyText;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CrossPanel;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.swing.validator.NumericValidator;
import se.prediktera.map.common.NiceDataFormat;
import se.prediktera.map.common.error.Logg;

public class BreezeTextField
extends AbstractBreezeTextPanel {
    private boolean numberField = false;
    private final BreezeTextFieldEmptyText textField;
    private final JLabel warningLabel;
    private JComponent crossPanel;
    private String defaultValue;
    private boolean crossPanelVisible = true;
    private boolean triggerChangeOnCross = true;
    private final List<Runnable> crossPanelListeners = new ArrayList<Runnable>();

    public BreezeTextField(String string, TextActionEvent.TextActionListener textActionListener) {
        this();
        this.setText(string);
        this.addChangeListener(textActionListener);
    }

    public BreezeTextField() {
        this(25);
    }

    public BreezeTextField(int n) {
        this.textField = new BreezeTextFieldEmptyText();
        this.crossPanel = new CrossPanel();
        this.warningLabel = new JLabel();
        this.updateTheme(BreezeTheme.getInstance());
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(34, n));
        this.textField.setPreferredSize(new Dimension(34, n));
        this.textField.setFont(new Font("Tahoma", 0, 14));
        this.textField.setText("Text");
        this.textField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.textField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (BreezeTextField.this.textField.isEditable() && BreezeTextField.this.textField.isEnabled()) {
                    BreezeTextField.this.showKeyboard();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                BreezeTextField.this.textField.selectAll();
            }
        });
        this.add((Component)this.textField, "Center");
        this.crossPanel.setMinimumSize(new Dimension(n, n));
        this.crossPanel.setPreferredSize(new Dimension(n, n));
        this.crossPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeTextField.this.textField.setText(this.getDefaultValue());
                if (BreezeTextField.this.triggerChangeOnCross) {
                    BreezeTextField.this.triggerChange(false);
                }
                for (Runnable runnable : BreezeTextField.this.crossPanelListeners) {
                    runnable.run();
                }
            }

            private String getDefaultValue() {
                if (BreezeTextField.this.defaultValue != null) {
                    return BreezeTextField.this.defaultValue;
                }
                if (BreezeTextField.this.isNumberField()) {
                    return "0";
                }
                return "";
            }
        });
        this.crossPanel.setLayout(new BorderLayout());
        this.add((Component)this.crossPanel, "After");
        this.warningLabel.setFont(new Font("Tahoma", 0, 12));
        this.warningLabel.setForeground(new Color(255, 0, 0));
        this.add((Component)this.warningLabel, "Last");
        this.addTextFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BreezeTextField.this.triggerChange(true);
            }
        });
        this.addTextKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    BreezeTextField.this.triggerChange(false);
                }
            }
        });
    }

    public void updateTheme(BreezeTheme breezeTheme) {
        this.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundMoreDifuse()));
        this.textField.setForeground(breezeTheme.getLabelForeground());
        this.textField.setDisabledTextColor(breezeTheme.getLabelForegroundDifuse());
        this.textField.setBackground(breezeTheme.getPanelBackground());
        this.textField.setCaretColor(breezeTheme.getLabelForeground());
        this.crossPanel.setBackground(breezeTheme.getPanelBackground());
        this.crossPanel.setForeground(breezeTheme.getLabelForegroundDifuse());
    }

    @Override
    public void addDocumentListener(DocumentListener documentListener) {
        this.textField.getDocument().addDocumentListener(documentListener);
    }

    public void addKeyListener(KeyAdapter keyAdapter) {
        this.textField.addKeyListener(keyAdapter);
    }

    public void addTextFocusListener(FocusListener focusListener) {
        this.textField.addFocusListener(focusListener);
    }

    public void addTextKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public double getNumber() {
        return NiceDataFormat.toNumber((String)this.getText());
    }

    public float getNumberFloat() {
        return (float)this.getNumber();
    }

    public int getNumberInt() {
        return (int)this.getNumber();
    }

    @Override
    public String getText() {
        return this.textField.getText();
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public boolean isNumberField() {
        return this.numberField;
    }

    @Override
    public void removeDocumentListener(DocumentListener documentListener) {
        this.textField.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void requestFocusAndSelectAll() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.textField.requestFocus();
                this.textField.selectAll();
            }
            catch (Exception exception) {
                Logg.error((String)"Exception when selecting text field", (Throwable)exception);
            }
        });
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setCrossPanelVisible(boolean bl) {
        this.crossPanelVisible = bl;
        this.crossPanel.setVisible(this.crossPanelVisible);
    }

    public void replaceCrossPanel(JComponent jComponent) {
        this.remove(this.crossPanel);
        this.crossPanel = jComponent;
        this.add((Component)this.crossPanel, "After");
        this.setCrossPanelVisible(this.textField.isEnabled() && this.textField.isEditable());
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
        this.setCrossPanelVisible(bl);
    }

    public void setEmptyText(String string) {
        this.textField.setEmptyText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.textField.setEnabled(bl);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (bl) {
            this.textField.setBackground(breezeTheme.getPanelBackground());
            this.crossPanel.setBackground(breezeTheme.getPanelBackground());
        } else {
            this.textField.setBackground(breezeTheme.getSettingPanelBackground());
            this.crossPanel.setBackground(breezeTheme.getSettingPanelBackground());
        }
        this.setCrossPanelVisible(bl && this.crossPanelVisible);
    }

    @Override
    public void setFormatedNumber(double d) {
        this.setText(NiceDataFormat.toString((double)d, (int)8));
    }

    public void setNumber(double d) {
        this.setText(String.valueOf(d));
    }

    public void setNumberField(boolean bl) {
        this.numberField = bl;
        this.addValidator(new NumericValidator());
        this.setLayer(0);
    }

    public void setNumberField(boolean bl, double d, double d2) {
        this.setNumberField(true);
        this.addValidator(new NumericMinMaxValidator(d, d2));
    }

    @Override
    public void setText(String string) {
        if (this.isNumberField() && string != null) {
            string = NiceDataFormat.convertDelimiters((String)string);
        }
        super.setText(string);
    }

    @Override
    protected void setTextInComponent(String string) {
        this.textField.setText(string);
    }

    public void setWarningLabelText(String string) {
        this.warningLabel.setText(string);
    }

    @Override
    public void setToolTipText(String string) {
        this.textField.setToolTipText(string);
    }

    @Override
    public boolean supportMultipleLines() {
        return false;
    }

    @Override
    public String toString() {
        return this.getText();
    }

    @Override
    public void triggerChange(boolean bl) {
        if (!BreezeFrame.touchscreen && this.isNumberField()) {
            this.setTextInComponent(NiceDataFormat.convertDelimiters((String)this.getText()));
        }
        super.triggerChange(bl);
    }

    public void setTriggerChangeOnCross(boolean bl) {
        this.triggerChangeOnCross = bl;
    }

    public BreezeTextFieldEmptyText getTextField() {
        return this.textField;
    }

    public void addCrossPanelListener(Runnable runnable) {
        this.crossPanelListeners.add(runnable);
    }
}

