/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.swing.validator.TextValidator;

public class BreezeTextFieldTest {
    @Test
    public void itShouldSetText() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.setText("hejsvej");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"hejsvej"));
    }

    @Test
    public void itShouldInvokeListenerOnTextChangeFromGui() {
        BoolHolder boolHolder = new BoolHolder(false);
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addChangeListener(textActionEvent -> {
            boolHolder.setTrue();
            MatcherAssert.assertThat((Object)textActionEvent.getText(), (Matcher)CoreMatchers.is((Object)"hejhopp"));
        });
        breezeTextField.setTextAndTrigger("hejhopp");
        MatcherAssert.assertThat((Object)boolHolder.getValue(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void itShouldInvokeListenerOnTextChangeFromGuiWhenOrigTextIsNull() {
        BoolHolder boolHolder = new BoolHolder(false);
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.setText(null);
        breezeTextField.addChangeListener(textActionEvent -> {
            boolHolder.setTrue();
            MatcherAssert.assertThat((Object)textActionEvent.getText(), (Matcher)CoreMatchers.is((Object)""));
        });
        breezeTextField.setTextAndTrigger("");
        MatcherAssert.assertThat((Object)boolHolder.getValue(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void numberFieldShouldInvokeListenerOnTextChangeFromGui() {
        BoolHolder boolHolder = new BoolHolder(false);
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.setNumberField(true);
        breezeTextField.addChangeListener(textActionEvent -> {
            boolHolder.setTrue();
            MatcherAssert.assertThat((Object)textActionEvent.getValueInt(), (Matcher)CoreMatchers.is((Object)2235));
        });
        breezeTextField.setTextAndTrigger("2235");
        MatcherAssert.assertThat((Object)boolHolder.getValue(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void numberFieldShouldConvertDelimitersOnEnter() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.setNumberField(true);
        breezeTextField.setTextAndTrigger("1,2");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"1.2"));
    }

    @Test
    public void itShouldRevertTextOnChangeListenerException() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addChangeListener(textActionEvent -> {
            throw new RuntimeException();
        });
        breezeTextField.setText("originaltext");
        try {
            breezeTextField.setTextAndTrigger("exceptiontext");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"originaltext"));
    }

    @Test
    public void itShouldRevertTextOnValidationError() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addValidator(new TextValidator(1, false));
        breezeTextField.setText("originaltext");
        try {
            breezeTextField.setTextAndTrigger("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"originaltext"));
    }

    @Test
    public void itShouldSetMinimumValueOnValidationError() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addValidator(new NumericMinMaxValidator(1.0, 2.0, "MinMax"));
        breezeTextField.setText("2");
        breezeTextField.setTextAndTrigger("");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"1"));
    }

    @Test
    public void itShouldErrorOnOverMaxValidationError() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addValidator(new NumericMinMaxValidator(1.0, 2.0, "MinMax"));
        breezeTextField.setTextAndTrigger("3");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"2"));
    }

    @Test
    public void itShouldErrorOnUnderMinValidationError() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addValidator(new NumericMinMaxValidator(1.0, 2.0, "MinMax"));
        breezeTextField.setTextAndTrigger("0");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"1"));
    }

    @Test
    public void itShouldSet0OnValidationError() {
        BreezeTextField breezeTextField = new BreezeTextField();
        breezeTextField.addValidator(new NumericMinMaxValidator(-1.0, 2.0, "MinMax"));
        breezeTextField.setTextAndTrigger("");
        MatcherAssert.assertThat((Object)breezeTextField.getText(), (Matcher)CoreMatchers.is((Object)"0"));
    }
}

