/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public abstract class BreezeTheme {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final Color WHITE_TEXT = new Color(225, 225, 225);
    public static final Color PROJECT_COLOR = new Color(108, 163, 103);
    public static final Color MODEL_COLOR = new Color(33, 84, 136);
    public static final Color PLAY_COLOR = new Color(47, 71, 45);
    public static final Color SETTINGS_COLOR = new Color(120, 75, 157);
    public static final Color CONNECT_COLOR = new Color(31, 139, 66);
    public static final Color RECORDINGS_COLOR = new Color(119, 67, 66);
    public static final Color RECORDER_BUTTON_COLOR = new Color(194, 40, 45);
    public static final Color RECORDER_COLOR = new Color(150, 112, 187);
    public static final Color GEO_COLOR = new Color(196, 103, 64);
    public static final Color CORESCANNER_COLOR = new Color(196, 154, 64);
    public static final Color RUNTIME_COLOR = new Color(246, 209, 0);
    public static final Color HYSPEX_COLOR = new Color(191, 18, 56);
    public static final Color DARK_BACKGROUND_COLOR = new Color(30, 30, 30);
    public static final Color PREDIKTERA_COLOR = new Color(31, 214, 156);
    public static final Color BREEZE_COLOR = new Color(0, 193, 222);
    private static BreezeTheme instance;

    public static BreezeTheme getInstance() {
        if (instance == null) {
            try {
                String string = BreezeTheme.getTheme();
                instance = string.equalsIgnoreCase("dark") ? new BreezeThemeDark() : new BreezeThemeClassic();
            }
            catch (Exception exception) {
                instance = new BreezeThemeClassic();
            }
        }
        return instance;
    }

    public static String getTheme() {
        try {
            return BreezeProperties.getInstance().getTheme();
        }
        catch (Exception exception) {
            return "classic";
        }
    }

    public boolean isDarkMode() {
        return false;
    }

    public static void changeTheme(String string) {
        BreezeProperties.getInstance().setTheme(string);
        instance = null;
    }

    public abstract Color getLabelForeground();

    public abstract Color getProgressForeground();

    public abstract Color getProgressBackground();

    public abstract Color getProgressGradientBackground();

    public abstract Color getLabelForegroundDifuse();

    public abstract Color getLabelForegroundLittleMoreDifuse();

    public abstract Color getLabelForegroundMoreDifuse();

    public abstract Color getLabelForegroundMax();

    public abstract Color getIndentationLineColor();

    public abstract Color getButtonForeground();

    public abstract Color getPanelBackground();

    public abstract Color getActiveGlow();

    public abstract Color getPanelBackground150();

    public abstract Color getPanelTitleBackground();

    public abstract Color getPanelSelectedTitleBackground();

    public abstract Color getPanelGradientBackground1();

    public abstract Color getPanelGradientBackground2();

    public abstract Color getPreviewPanelBackground();

    public abstract Color getImageBackground();

    public abstract Color getImage2Background();

    public abstract Color getSettingPanelBackground();

    public abstract Color getMainPanelGradientBackground();

    public abstract Color getTreeBackground();

    public abstract Color getIconBackground();

    public abstract Color getPlotGridColor();

    public abstract Color getDialogBackground();

    public abstract Color getDialogForeground();

    public abstract Color getLinkForeground();

    public abstract Color getEntryBackground();

    public abstract Color getDescriptorColor();

    public abstract Color darker(Color var1);

    public abstract Color brighter(Color var1);

    public abstract Color getTableGridColor();

    public abstract Color getToggleButtonSelectedColor();

    public abstract Color getToggleButtonHoverColor();

    public Color getNoteColor() {
        return new Color(0, 120, 215);
    }

    public Color getTipColor() {
        return new Color(0, 128, 0);
    }

    public Color getImportantColor() {
        return new Color(128, 0, 128);
    }

    public Color getWarningColor() {
        return new Color(184, 134, 11);
    }

    public Color getCautionColor() {
        return new Color(178, 34, 34);
    }

    public Color getSliderThumbColor() {
        return new Color(0, 120, 215);
    }

    public Color getSliderThumbFocusColor() {
        return new Color(105, 190, 255);
    }

    public Color getWarningBackgroundColor() {
        return new Color(243, 222, 154, 255);
    }

    public Color getSuccessBackgroundColor() {
        return new Color(7, 204, 111, 197);
    }

    public Color getErrorBackgroundColor() {
        return new Color(229, 163, 163);
    }

    public Color getInfoBackgroundColor() {
        return new Color(230, 230, 230);
    }

    public Color getMainPanelBackground() {
        return this.getPanelBackground();
    }

    public abstract Color getSelectionBackground();

    public abstract Color getEntrySelectionBackground();

    public abstract Color getEntrySelectionHoverBackground();

    public abstract Color getWizardFinishButtonBackground();

    public abstract Color getWizardFinishButtonForeground();

    public Color getSelectionBorder() {
        if (this.isDarkMode()) {
            return Color.yellow;
        }
        return Color.orange;
    }

    public Color getProgressBarColor() {
        return new Color(0, 195, 222);
    }

    public Color getHighlighted() {
        return new Color(253, 238, 165);
    }

    public Color getPredikteraMainColor() {
        return new Color(27, 47, 82);
    }

    public static class BreezeThemeDark
    extends BreezeTheme {
        @Override
        public Color getWizardFinishButtonForeground() {
            return WHITE_TEXT;
        }

        @Override
        public Color getWizardFinishButtonBackground() {
            return new Color(60, 97, 140);
        }

        @Override
        public Color getIndentationLineColor() {
            return new Color(205, 205, 205);
        }

        @Override
        public Color getLabelForeground() {
            return new Color(225, 225, 225);
        }

        @Override
        public Color getProgressForeground() {
            return WHITE_TEXT;
        }

        @Override
        public Color getProgressBackground() {
            return new Color(80, 84, 86);
        }

        @Override
        public Color getProgressGradientBackground() {
            return WHITE_TEXT;
        }

        @Override
        public Color getActiveGlow() {
            return new Color(255, 215, 0, 128);
        }

        @Override
        public Color getLabelForegroundMax() {
            return Color.white;
        }

        @Override
        public Color getLabelForegroundDifuse() {
            return new Color(205, 205, 205);
        }

        @Override
        public Color getLabelForegroundLittleMoreDifuse() {
            return new Color(155, 155, 155);
        }

        @Override
        public Color getLabelForegroundMoreDifuse() {
            return new Color(105, 105, 105);
        }

        @Override
        public Color getPanelBackground() {
            return DARK_BACKGROUND_COLOR;
        }

        @Override
        public Color getPanelGradientBackground1() {
            return this.getPanelBackground();
        }

        @Override
        public Color getPanelGradientBackground2() {
            return new Color(80, 80, 80);
        }

        @Override
        public Color getTreeBackground() {
            return new Color(27, 27, 27);
        }

        @Override
        public Color getMainPanelGradientBackground() {
            return new Color(120, 120, 120);
        }

        @Override
        public Color getIconBackground() {
            return new Color(25, 25, 25);
        }

        @Override
        public Color getPlotGridColor() {
            return Color.darkGray;
        }

        @Override
        public Color getSettingPanelBackground() {
            return new Color(45, 45, 45);
        }

        @Override
        public Color getButtonForeground() {
            return new Color(45, 45, 45);
        }

        @Override
        public Color getPreviewPanelBackground() {
            return this.getSettingPanelBackground();
        }

        @Override
        public Color getPanelBackground150() {
            return new Color(105, 105, 105);
        }

        @Override
        public Color getPanelTitleBackground() {
            return new Color(70, 70, 70);
        }

        @Override
        public Color getImageBackground() {
            return this.getSettingPanelBackground();
        }

        @Override
        public Color getImage2Background() {
            return new Color(190, 190, 190);
        }

        @Override
        public Color getDialogBackground() {
            return this.getSettingPanelBackground();
        }

        @Override
        public Color getDialogForeground() {
            return this.getLabelForegroundDifuse();
        }

        @Override
        public Color getPanelSelectedTitleBackground() {
            return Color.lightGray;
        }

        @Override
        public Color getLinkForeground() {
            return new Color(150, 200, 255);
        }

        @Override
        public Color getEntryBackground() {
            return new Color(150, 150, 150);
        }

        @Override
        public Color getMainPanelBackground() {
            return this.getSettingPanelBackground();
        }

        @Override
        public Color getHighlighted() {
            return new Color(153, 138, 65);
        }

        @Override
        public Color getDescriptorColor() {
            return new Color(54, 96, 120);
        }

        @Override
        public Color getTableGridColor() {
            return this.getPanelBackground150();
        }

        @Override
        public Color getToggleButtonSelectedColor() {
            return new Color(95, 98, 100);
        }

        @Override
        public Color getToggleButtonHoverColor() {
            return new Color(80, 83, 85);
        }

        @Override
        public boolean isDarkMode() {
            return true;
        }

        @Override
        public Color darker(Color color) {
            return color.brighter();
        }

        @Override
        public Color brighter(Color color) {
            return color.darker();
        }

        @Override
        public Color getSelectionBackground() {
            return new Color(26, 65, 105);
        }

        @Override
        public Color getEntrySelectionBackground() {
            return new Color(79, 79, 79);
        }

        @Override
        public Color getEntrySelectionHoverBackground() {
            return new Color(60, 60, 60);
        }
    }

    public static class BreezeThemeClassic
    extends BreezeTheme {
        @Override
        public Color getLabelForeground() {
            return Color.black;
        }

        @Override
        public Color getProgressForeground() {
            return this.getLabelForeground();
        }

        @Override
        public Color getProgressBackground() {
            return Color.white;
        }

        @Override
        public Color getProgressGradientBackground() {
            return Color.WHITE;
        }

        @Override
        public Color getLabelForegroundMax() {
            return Color.black;
        }

        @Override
        public Color getIndentationLineColor() {
            return new Color(150, 150, 150);
        }

        @Override
        public Color getLabelForegroundDifuse() {
            return new Color(50, 50, 50);
        }

        @Override
        public Color getLabelForegroundLittleMoreDifuse() {
            return new Color(100, 100, 100);
        }

        @Override
        public Color getLabelForegroundMoreDifuse() {
            return new Color(150, 150, 150);
        }

        @Override
        public Color getPanelBackground() {
            return Color.white;
        }

        @Override
        public Color getActiveGlow() {
            return new Color(0, 166, 255, 128);
        }

        @Override
        public Color getPanelGradientBackground1() {
            return this.getPanelBackground();
        }

        @Override
        public Color getPanelGradientBackground2() {
            return new Color(205, 205, 205);
        }

        @Override
        public Color getTreeBackground() {
            return new Color(27, 27, 27);
        }

        @Override
        public Color getMainPanelGradientBackground() {
            return new Color(170, 170, 170);
        }

        @Override
        public Color getIconBackground() {
            return new Color(230, 230, 230);
        }

        @Override
        public Color getPlotGridColor() {
            return Color.lightGray;
        }

        @Override
        public Color getSettingPanelBackground() {
            return new Color(240, 240, 240);
        }

        @Override
        public Color getButtonForeground() {
            return new Color(110, 110, 110);
        }

        @Override
        public Color getPreviewPanelBackground() {
            return Color.gray;
        }

        @Override
        public Color getPanelBackground150() {
            return new Color(150, 150, 150);
        }

        @Override
        public Color getPanelTitleBackground() {
            return new Color(210, 210, 210);
        }

        @Override
        public Color getImageBackground() {
            return this.getPanelBackground();
        }

        @Override
        public Color getImage2Background() {
            return new Color(210, 210, 210);
        }

        @Override
        public Color getDialogBackground() {
            return this.getPanelBackground();
        }

        @Override
        public Color getDialogForeground() {
            return this.getLabelForeground();
        }

        @Override
        public Color getPanelSelectedTitleBackground() {
            return Color.white;
        }

        @Override
        public Color getLinkForeground() {
            return new Color(3, 74, 149);
        }

        @Override
        public Color getEntryBackground() {
            return new Color(240, 240, 240);
        }

        @Override
        public Color getDescriptorColor() {
            return new Color(102, 171, 210);
        }

        @Override
        public Color getTableGridColor() {
            return new Color(192, 192, 192);
        }

        @Override
        public Color getToggleButtonSelectedColor() {
            return new Color(204, 204, 204);
        }

        @Override
        public Color getToggleButtonHoverColor() {
            return new Color(224, 224, 224);
        }

        @Override
        public Color darker(Color color) {
            return color.darker();
        }

        @Override
        public Color brighter(Color color) {
            return color.brighter();
        }

        @Override
        public Color getSelectionBackground() {
            return new Color(224, 238, 251);
        }

        @Override
        public Color getEntrySelectionBackground() {
            return new Color(205, 203, 203);
        }

        @Override
        public Color getEntrySelectionHoverBackground() {
            return new Color(234, 234, 234);
        }

        @Override
        public Color getWizardFinishButtonBackground() {
            return new Color(59, 130, 198);
        }

        @Override
        public Color getWizardFinishButtonForeground() {
            return Color.WHITE;
        }
    }
}

