/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.FilteredImageSource;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToggleButton;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class BreezeToggleButton
extends JToggleButton {
    private ImageIcon icon;
    private ImageIcon grayedIcon;
    private boolean isHover;
    private final Color bgColor;
    private final int radius = 10;
    private int borderWidth = 1;

    public BreezeToggleButton(String string) {
        super(string);
        this.setFocusable(false);
        this.setFont(new Font("Tahoma", 0, 12));
        this.bgColor = StringUtils.isEmpty((CharSequence)string) ? BreezeTheme.getInstance().getSettingPanelBackground() : BreezeTheme.getInstance().getPanelBackground();
        this.init();
    }

    public BreezeToggleButton(String string, String string2) {
        this(string);
        this.setToolTipText(string2);
    }

    public BreezeToggleButton(String string, String string2, ButtonGroup buttonGroup, boolean bl, Runnable runnable) {
        this(string);
        buttonGroup.add(this);
        this.setCallback(runnable);
        this.setResourceIcon(string2);
        if (bl) {
            buttonGroup.setSelected(this.getModel(), true);
        }
        this.init();
    }

    private void init() {
        this.setForeground(BreezeTheme.getInstance().getLabelForeground());
        this.setContentAreaFilled(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                BreezeToggleButton.this.isHover = false;
                BreezeToggleButton.this.borderWidth = 1;
                BreezeToggleButton.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                BreezeToggleButton.this.isHover = true;
                BreezeToggleButton.this.borderWidth = 2;
                BreezeToggleButton.this.repaint();
            }
        });
        this.setBorderPainted(false);
    }

    private Color getBackgroundColor() {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (!this.isEnabled()) {
            return breezeTheme.getPanelBackground();
        }
        if (this.isHover) {
            return breezeTheme.getToggleButtonHoverColor();
        }
        if (this.isSelected()) {
            return breezeTheme.getToggleButtonSelectedColor();
        }
        return this.bgColor;
    }

    @Override
    public boolean isRolloverEnabled() {
        return true;
    }

    public void setCallback(Runnable runnable) {
        this.addActionListener(actionEvent -> runnable.run());
    }

    public void setResourceIcon(String string) {
        URL uRL;
        if (string != null && (uRL = EntryMainPanel.class.getResource("/images/" + string + ".png")) != null) {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.icon = new ImageIcon(uRL);
            if (breezeTheme.isDarkMode() && ImageHelper.isGrayscaleIcon(this.icon, false)) {
                this.icon = ImageHelper.changeGrayBrightnessDarkTheme(this.icon);
            }
            this.setIcon(this.icon);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setFont(new Font("Tahoma", 0, 12));
            this.setMargin(new Insets(4, 2, 4, 2));
        }
    }

    private ImageIcon getGrayedIcon() {
        if (this.icon != null && this.grayedIcon == null) {
            this.grayedIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(this.icon.getImage().getSource(), new GrayFilter(!BreezeTheme.getInstance().isDarkMode(), 50))));
        }
        return this.grayedIcon;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.icon != null) {
            if (bl) {
                this.setIcon(this.icon);
            } else {
                this.setIcon(this.getGrayedIcon());
            }
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.getBackgroundColor());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 10.0f, 10.0f);
        graphics2D.fill(float_);
        if (StringUtils.isNotEmpty((CharSequence)this.getText())) {
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(this.borderWidth));
            RoundRectangle2D.Float float_2 = new RoundRectangle2D.Float((float)this.borderWidth / 2.0f, (float)this.borderWidth / 2.0f, this.getWidth() - this.borderWidth, this.getHeight() - this.borderWidth, 10.0f, 10.0f);
            graphics2D.draw(float_2);
        }
        super.paintComponent(graphics2D);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Toggle button");
        jFrame.setDefaultCloseOperation(3);
        BreezePanel breezePanel = new BreezePanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        BreezeToggleButton breezeToggleButton = new BreezeToggleButton("zoom out", "explore/zoom_out", buttonGroup, false, () -> System.out.println("Toggle"));
        breezeToggleButton.setEnabled(false);
        EntryMainHelper.addComponent(breezePanel, EntryMainHelper.createButton("All", "explore/zoom_all", () -> System.out.println("reg")));
        EntryMainHelper.addComponent(breezePanel, new BreezeToggleButton("zoom in", "explore/zoom_in", buttonGroup, false, () -> System.out.println("Toggle")), false, 0, 0);
        EntryMainHelper.addComponent(breezePanel, breezeToggleButton, false, 0, 0);
        EntryMainHelper.addComponent(breezePanel, new BreezeToggleButton("zoom out"), false, 0, 0);
        EntryMainHelper.addComponent(breezePanel, new BreezeToggleButton(null, "delete", buttonGroup, false, () -> System.out.println("no text icon")), false, 0, 0);
        jFrame.getContentPane().add((Component)breezePanel, "Center");
        jFrame.setSize(200, 200);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

