/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.DragMoverListener;
import se.prediktera.breeze.frontend.common.swing.BreezeListInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.map.common.cleanup.CleanUpTree;

public class BreezeTree
extends CleanUpTree
implements BreezeListInterface {
    private Color selectionBackground;
    private Color selectionForeground = Color.white;
    private CustomTreeUI treeUI;
    private BreezeFilter breezeFilter;

    public BreezeTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(defaultMutableTreeNode);
        this.setRootVisible(false);
        this.setRowHeight(0);
        this.setForeground(BreezeTheme.getInstance().getLabelForeground());
    }

    public BreezeTree() {
        this(null);
    }

    public void addScroll() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            this.addMouseMotionListener(new DragMoverListener(jViewport, (JComponent)((Object)this)));
        }
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                boolean bl = false;
                TreePath treePath = BreezeTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    Rectangle rectangle = BreezeTree.this.getPathBounds(treePath);
                    bl = rectangle.contains(mouseEvent.getPoint());
                }
                if (bl) {
                    BreezeTree.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    BreezeTree.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    public void collapseAll() {
        ArrayTreeModel arrayTreeModel = (ArrayTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)arrayTreeModel.getRoot();
        TreePath treePath = new TreePath(defaultMutableTreeNode);
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode.getChildAt(i));
            this.collapsePath(treePath2);
        }
    }

    public void expandAll() {
        this.expandAll(true);
    }

    public void expandAll(boolean bl) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        this.expandAll(defaultMutableTreeNode, bl);
    }

    public void expandAll(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.expandRow(i);
            }
        } else {
            TreePath treePath = new TreePath(defaultMutableTreeNode);
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                TreePath treePath2 = treePath.pathByAddingChild(defaultMutableTreeNode);
                this.expandPath(treePath2);
            }
        }
    }

    public int getItemCount() {
        return this.getRowCount();
    }

    public List getList() {
        return ((ArrayTreeModel)this.getModel()).getList();
    }

    public List getFilteredList() {
        List list = this.getList();
        if (this.breezeFilter != null) {
            return list.stream().filter(this.breezeFilter::matches).toList();
        }
        return list;
    }

    @Override
    public Object getObjectAt(Point point) {
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            return this.getObjectFromPath(treePath);
        }
        return null;
    }

    @Override
    public Object getSelectedValue() {
        TreePath treePath = this.getSelectionPath();
        if (treePath != null) {
            return this.getObjectFromPath(treePath);
        }
        return null;
    }

    public Object[] getSelectedValues() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray != null) {
            Object[] objectArray = new Object[treePathArray.length];
            for (int i = 0; i < treePathArray.length; ++i) {
                objectArray[i] = this.getObjectFromPath(treePathArray[i]);
            }
            return objectArray;
        }
        return null;
    }

    public void insertElement(Object object) {
        ((ArrayTreeModel)this.getModel()).insertElement(this, object);
    }

    public boolean removeItem(Object object) {
        return ((ArrayTreeModel)this.getModel()).removeElement(this, object);
    }

    public Object setFilter(BreezeFilter breezeFilter, Object object, int n) {
        this.breezeFilter = breezeFilter;
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof ArrayTreeModel) {
            ArrayTreeModel arrayTreeModel = (ArrayTreeModel)treeModel;
            ArrayTreeModel.BasicTreeNode basicTreeNode = arrayTreeModel.setFilter(breezeFilter, object, n);
            if (basicTreeNode == null && !arrayTreeModel.getList().isEmpty()) {
                basicTreeNode = arrayTreeModel.setFilter(breezeFilter, arrayTreeModel.getList().getFirst(), n);
            }
            this.select(basicTreeNode, false);
            if (basicTreeNode != null) {
                return basicTreeNode.getUserObject();
            }
        }
        return null;
    }

    public void setModel(List list) {
        this.setModel(new ArrayTreeModel(list));
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        this.treeUI = new CustomTreeUI(jScrollPane);
        this.setUI(this.treeUI);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BreezeTree.this.treeUI.updateLayout();
            }
        });
    }

    public void setSelectedIndex(int n) {
        this.setSelectionRow(n);
    }

    public void setSelectedValueByName(String string) {
        this.setSelectedValue(this.getNodeByName(string));
    }

    public void setSelectedValue(Object object) {
        this.setSelectedValue(object, false);
    }

    public void setSelectedValue(Object object, boolean bl) {
        Object object2 = this.getModel();
        if (object2 instanceof ArrayTreeModel) {
            ArrayTreeModel arrayTreeModel = (ArrayTreeModel)object2;
            object2 = arrayTreeModel.update(object);
            this.select((DefaultMutableTreeNode)object2, bl);
            this.requestFocus();
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        if (objectArray.length > 0) {
            this.setSelectedValue(objectArray[0], false);
        }
        for (int i = 1; i < objectArray.length; ++i) {
            this.setSelectedValue(objectArray[i], true);
        }
    }

    public void sort() {
        ((ArrayTreeModel)this.getModel()).sort(this);
    }

    public void sort(ListHelper.SortType sortType, boolean bl) {
        ((ArrayTreeModel)this.getModel()).sort(this, sortType, bl);
    }

    protected void cleanUpChild() {
        TreeModel treeModel = this.getModel();
        if (treeModel instanceof ArrayTreeModel) {
            ArrayTreeModel arrayTreeModel = (ArrayTreeModel)treeModel;
            arrayTreeModel.cleanUp();
        }
    }

    private Object getObjectFromPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object = treePath.getLastPathComponent();
        if (object instanceof MutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null) {
            return defaultMutableTreeNode.getUserObject();
        }
        return object;
    }

    private void select(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            if (bl) {
                if (this.isPathSelected(treePath)) {
                    this.removeSelectionPath(treePath);
                } else {
                    this.addSelectionPath(treePath);
                }
            } else {
                this.setSelectionPath(treePath);
            }
            SwingUtilities.invokeLater(() -> this.scrollPathToVisible(treePath));
        }
    }

    public void selectAll() {
        this.setSelectionInterval(0, this.getItemCount());
    }

    public void moveSelected(boolean bl) {
        ObjectWithChildrenAndParent objectWithChildrenAndParent;
        ObjectWithChildrenAndParent objectWithChildrenAndParent2;
        Object object = this.getSelectedValue();
        if (object == null) {
            return;
        }
        ArrayTreeModel arrayTreeModel = (ArrayTreeModel)this.getModel();
        List list = this.getList();
        int n = arrayTreeModel.indexOf(object);
        if (object instanceof ObjectWithChildrenAndParent && (objectWithChildrenAndParent2 = (ObjectWithChildrenAndParent)(objectWithChildrenAndParent = (ObjectWithChildrenAndParent)object).getParent()) != null) {
            list = objectWithChildrenAndParent2.getChildList();
            n = objectWithChildrenAndParent2.getChildIndex(objectWithChildrenAndParent);
        }
        if (bl) {
            if (n >= 0 && n < list.size() - 1) {
                this.setSelectedValue(arrayTreeModel.swapElement(list, n, n + 1));
            }
        } else if (n > 0) {
            this.setSelectedValue(arrayTreeModel.swapElement(list, n, n - 1));
        }
    }

    public Object getNodeByName(String string) {
        return this.getNodeByName((DefaultMutableTreeNode)this.getModel().getRoot(), string);
    }

    private Object getNodeByName(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (defaultMutableTreeNode != null) {
            FunctionTreeNode functionTreeNode;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof FunctionTreeNode && (functionTreeNode = (FunctionTreeNode)object).getAliasOrNodeString().equals(string)) {
                return object;
            }
            if (object.toString().equals(string)) {
                return object;
            }
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                Object object2 = this.getNodeByName(defaultMutableTreeNode2, string);
                if (object2 == null) continue;
                return object2;
            }
        }
        return null;
    }

    public int getNumberOfNodes() {
        TreeModel treeModel = this.getModel();
        if (this.isRootVisible()) {
            return this.getNumberOfNodes(treeModel, treeModel.getRoot());
        }
        return this.getNumberOfNodes(treeModel, treeModel.getRoot()) - 1;
    }

    private int getNumberOfNodes(TreeModel treeModel, Object object) {
        int n = 1;
        int n2 = treeModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            n += this.getNumberOfNodes(treeModel, treeModel.getChild(object, i));
        }
        return n;
    }

    public Entry getEntryByNameOrFirst(String string) {
        List list = this.getList();
        if (list.isEmpty()) {
            return null;
        }
        for (Object e : list) {
            Entry entry = (Entry)e;
            if (!entry.getName().equals(string)) continue;
            return entry;
        }
        return (Entry)list.getFirst();
    }

    @Generated
    public void setSelectionBackground(Color color) {
        this.selectionBackground = color;
    }

    @Generated
    public void setSelectionForeground(Color color) {
        this.selectionForeground = color;
    }

    @Generated
    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    @Generated
    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public static class CustomTreeUI
    extends BasicTreeUI {
        private final JScrollPane scrollPane;

        public CustomTreeUI(JScrollPane jScrollPane) {
            this.scrollPane = jScrollPane;
        }

        public void updateLayout() {
            CustomTreeUI customTreeUI = this;
            SwingUtilities.invokeLater(() -> customTreeUI.configureLayoutCache());
        }

        @Override
        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
                    Rectangle rectangle2 = super.getNodeDimensions(object, n, n2, bl, rectangle);
                    int n3 = scrollPane.getViewport().getWidth();
                    rectangle2.width = n3 - this.getRowX(n, n2);
                    return rectangle2;
                }
            };
        }

        @Override
        protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        }

        @Override
        protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        }
    }
}

