/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeSpinnerInputPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.InputFieldHelper;

public class CollapsePanel
extends JPanel {
    public static int DefaultLabelWidth = 250;
    public static int DefaultUnitWidth = 80;
    protected final BreezeButton expandButton = new BreezeButton();
    protected final BreezeLabel label = new BreezeLabel();
    private final JPanel panel = new JPanel();
    private final BreezeSeparator separator = new BreezeSeparator();
    private CollapseCallback collapseCallback;
    public int labelWidth = DefaultLabelWidth;
    public int unitWidth = DefaultUnitWidth;

    public CollapsePanel() {
        this("Advanced", true);
    }

    public CollapsePanel(String string) {
        this(string, true);
    }

    public CollapsePanel(String string, boolean bl) {
        this(string, bl, bl, 10);
    }

    public CollapsePanel(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, 10);
    }

    public CollapsePanel(String string, boolean bl, boolean bl2, int n) {
        this.setLayout(new GridBagLayout());
        this.panel.setOpaque(false);
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        this.add((Component)this.panel, gridBagConstraints);
        this.expandButton.setResourceIcon("keyboard_arrow_right");
        this.expandButton.addClickCallBack(() -> this.setCollapsed(this.panel.isVisible()));
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(3, 0, 0, 0);
            this.add((Component)this.expandButton, gridBagConstraints);
        }
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.label.setForeground(breezeTheme.getLabelForegroundDifuse());
        this.label.setFontSize(16);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, bl ? 20 : 0, 0, 0);
        this.add((Component)this.label, gridBagConstraints);
        this.setTitle(string);
        this.setCollapsed(bl2);
        if (bl) {
            this.label.setCursor(Cursor.getPredefinedCursor(12));
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (CollapsePanel.this.label.isEnabled()) {
                        CollapsePanel.this.setCollapsed(CollapsePanel.this.panel.isVisible());
                    }
                }
            });
        }
        this.setOpaque(false);
    }

    public void setUnitWidth(int n) {
        this.unitWidth = n;
    }

    public void setLabelWidth(int n) {
        this.labelWidth = n;
    }

    public void setTitle(String string) {
        this.label.setText(string);
    }

    @Override
    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
        super.setFont(font);
    }

    public void setLabelFontSize(int n) {
        if (this.label != null) {
            this.label.setFontSize(n);
        }
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void triggerCollapseCallback() {
        if (this.collapseCallback != null) {
            this.collapseCallback.onChange(this.panel.isVisible());
        }
    }

    public void updateTheme(BreezeTheme breezeTheme) {
        if (this.isCollapsed()) {
            this.expandButton.setResourceIcon("keyboard_arrow_right");
        } else {
            this.expandButton.setResourceIcon("expand_more");
        }
        this.separator.setColor(breezeTheme.getPanelBackground150());
        this.label.setForeground(breezeTheme.getLabelForegroundDifuse());
    }

    public void setCollapsed(boolean bl) {
        if (bl) {
            this.separator.setVisible(false);
            this.panel.setVisible(false);
            this.expandButton.setResourceIcon("keyboard_arrow_right");
        } else {
            this.separator.setVisible(true);
            this.panel.setVisible(true);
            this.expandButton.setResourceIcon("expand_more");
        }
        this.triggerCollapseCallback();
    }

    public boolean isCollapsed() {
        return !this.isExpanded();
    }

    public boolean isExpanded() {
        return this.panel.isVisible();
    }

    public void refresh() {
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void addPanel(BreezeInputField breezeInputField) {
        this.addPanel(breezeInputField, (TextActionEvent.TextActionListener)null);
    }

    public void addPanel(BreezeInputField breezeInputField, TextActionEvent.TextActionListener textActionListener) {
        this.addPanel(breezeInputField, textActionListener, this.labelWidth);
    }

    public void addPanel(BreezeInputField breezeInputField, TextActionEvent.TextActionListener textActionListener, int n) {
        breezeInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        breezeInputField.setLabelWidth(n);
        breezeInputField.setUnitLabelWidth(this.unitWidth);
        InputFieldHelper.addPanel(this.panel, breezeInputField, textActionListener);
    }

    public void addPanel(BreezeComboBoxInputField breezeComboBoxInputField) {
        this.addPanel(breezeComboBoxInputField, this.labelWidth);
    }

    public void addPanel(BreezeComboBoxInputField breezeComboBoxInputField, int n) {
        breezeComboBoxInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        breezeComboBoxInputField.setLabelWidth(n);
        breezeComboBoxInputField.setUnitLabelWidth(this.unitWidth);
        InputFieldHelper.addPanel(this.panel, breezeComboBoxInputField);
    }

    public void addPanel(BreezeSpinnerInputPanel breezeSpinnerInputPanel) {
        breezeSpinnerInputPanel.setLabelWidth(this.labelWidth);
        breezeSpinnerInputPanel.setUnitLabelWidth(this.unitWidth);
        InputFieldHelper.addPanel(this.panel, breezeSpinnerInputPanel);
    }

    public void addPanel(BreezeCheckBoxInputField breezeCheckBoxInputField) {
        breezeCheckBoxInputField.setFormat(BreezeInputFieldHelper.Format.OneRow);
        breezeCheckBoxInputField.setLabelWidth(this.labelWidth);
        InputFieldHelper.addPanel(this.panel, breezeCheckBoxInputField);
    }

    public void addPanel(JPanel jPanel, JComponent jComponent) {
        InputFieldHelper.addPanel(jPanel, jComponent);
    }

    public void addPanel(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        InputFieldHelper.addPanel(this.panel, jComponent);
    }

    public void addPanel(JComponent jComponent, Insets insets) {
        InputFieldHelper.addPanel(this.panel, jComponent, true, insets);
    }

    public void addPanel(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        this.panel.add((Component)jComponent, gridBagConstraints);
    }

    public void addPanelNoFillHorizontal(JComponent jComponent) {
        InputFieldHelper.addPanel(this.panel, jComponent, false, null);
    }

    public void setExpandEnabled(boolean bl) {
        this.expandButton.setEnabled(bl);
        this.label.setEnabled(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        for (int i = 0; i < this.panel.getComponentCount(); ++i) {
            Component component = this.panel.getComponent(i);
            component.setEnabled(bl);
        }
    }

    public void hideIfEmpty() {
        this.setVisible(CollapsePanel.hasVisibleComponents(this.panel));
    }

    public static boolean hasVisibleComponents(JComponent jComponent) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            JPanel jPanel;
            Component component = jComponent.getComponent(i);
            if (component instanceof JPanel && (jPanel = (JPanel)component).getComponentCount() == 0 || !component.isVisible()) continue;
            return true;
        }
        return false;
    }

    @Generated
    public BreezeLabel getLabel() {
        return this.label;
    }

    @Generated
    public JPanel getPanel() {
        return this.panel;
    }

    @Generated
    public BreezeSeparator getSeparator() {
        return this.separator;
    }

    @Generated
    public void setCollapseCallback(CollapseCallback collapseCallback) {
        this.collapseCallback = collapseCallback;
    }

    public static interface CollapseCallback {
        public void onChange(boolean var1);
    }

    public static class NoExpandCollapsePanel
    extends CollapsePanel {
        public NoExpandCollapsePanel(String string) {
            super(string, false);
        }
    }
}

