/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.ButtonMouseAdapter;

public class CrossPanel
extends JPanel {
    private static final BasicStroke stroke = new BasicStroke(2.0f, 0, 0, 10.0f);
    private ButtonMouseAdapter mouseAdapter;

    public CrossPanel() {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseAdapter = new ButtonMouseAdapter(this, mouseListener){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                CrossPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                CrossPanel.this.repaint();
            }
        };
        super.addMouseListener(this.mouseAdapter);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = Math.min(n, n2);
        int n4 = (int)((double)n3 * 0.2);
        int n5 = n / 2;
        int n6 = n2 / 2;
        int n7 = n5 - n4;
        int n8 = n6 - n4;
        int n9 = n5 + n4;
        int n10 = n6 + n4;
        if (this.mouseAdapter != null && this.mouseAdapter.mouseinside) {
            graphics2D.setColor(BreezeTheme.getInstance().getSettingPanelBackground());
            graphics2D.fillOval(n7 - 2, n8 - 2, n5 + 1, n5 + 1);
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
        } else {
            graphics2D.setColor(this.getForeground());
        }
        graphics2D.setStroke(stroke);
        graphics2D.drawLine(n7, n8, n9, n10);
        graphics2D.drawLine(n7, n10, n9, n8);
    }
}

