/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.DataSlicingDescriptor;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeColorChooser;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class DeleteCatClassInputField
extends JPanel {
    private final BreezeInputField labelField = new BreezeInputField("Name", "", "", BreezeInputFieldHelper.Format.OneRow);
    protected final JPanel inputPanel = new JPanel(new BorderLayout());
    private final JComponent actionComponent;
    private final BreezeColorChooser.ColorChoosePanel colorPanel;
    protected final int labelWidth = 40;

    public DeleteCatClassInputField(CatClass catClass, OnChangeCallback onChangeCallback) {
        this(catClass, new BreezeButton(), onChangeCallback);
    }

    public DeleteCatClassInputField(CatClass catClass, JComponent jComponent, final OnChangeCallback onChangeCallback) {
        super(new GridBagLayout());
        Serializable serializable;
        this.actionComponent = jComponent;
        this.setOpaque(false);
        this.labelField.setText(catClass.getName());
        this.labelField.setLabelWidth(40);
        this.labelField.addChangeListener(textActionEvent -> {
            catClass.setName(textActionEvent.getText());
            onChangeCallback.onChange(this);
        });
        this.labelField.setCrossPanelVisible(false);
        this.colorPanel = new BreezeColorChooser.ColorChoosePanel(catClass.getColor(), color -> {
            catClass.setColor(color);
            onChangeCallback.onChange(this);
        });
        this.colorPanel.setPreferredSize(new Dimension(15, 15));
        this.colorPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForeground()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.getComponentCount();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.colorPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = this.getComponentCount();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.labelField, gridBagConstraints2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.setPreferredSize(new Dimension(25, 25));
        if (jComponent instanceof BreezeButton) {
            serializable = (BreezeButton)jComponent;
            serializable.setResourceIcon("delete");
            jComponent.setPreferredSize(new Dimension(20, 25));
        } else {
            jComponent.setPreferredSize(new Dimension(25, 25));
        }
        jComponent.setToolTipText("Delete");
        jComponent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                onChangeCallback.action();
            }
        });
        jPanel.add((Component)jComponent, "West");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = this.getComponentCount();
        ((GridBagConstraints)serializable).anchor = 11;
        ((GridBagConstraints)serializable).insets = new Insets(1, 5, 0, 0);
        this.add((Component)jPanel, serializable);
        this.inputPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridwidth = 1;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.inputPanel, gridBagConstraints3);
    }

    public BreezeInputField getLabelField() {
        return this.labelField;
    }

    public JComponent getActionComponent() {
        return this.actionComponent;
    }

    public String getValue() {
        return "";
    }

    public Color getColor() {
        return this.colorPanel.getBackground();
    }

    @Override
    public synchronized void addFocusListener(FocusListener focusListener) {
        this.labelField.getTextField().getTextField().addFocusListener(focusListener);
    }

    public void setEditable(boolean bl) {
        this.colorPanel.setEnabled(bl);
        this.labelField.setEnabled(bl);
        this.actionComponent.setEnabled(bl);
    }

    public static interface OnChangeCallback {
        public void onChange(DeleteCatClassInputField var1);

        public void action();
    }

    public static class DataSliceDeleteCatClassInputField
    extends DeleteCatClassInputField {
        private final BreezeInputField fromField = new BreezeInputField.Number("Range", 0.0, "", BreezeInputFieldHelper.Format.OneRow);
        private final BreezeInputField toField = new BreezeInputField.Number("    -", 0.0, "", BreezeInputFieldHelper.Format.OneRow);

        public DataSliceDeleteCatClassInputField(DataSlicingDescriptor.DataSlicingParameter.DataSliceCatClass dataSliceCatClass, OnChangeCallback onChangeCallback) {
            super(dataSliceCatClass, onChangeCallback);
            this.inputPanel.setLayout(new GridBagLayout());
            this.fromField.setLabelWidth(40);
            this.fromField.setCrossPanelVisible(false);
            this.fromField.addChangeListener(textActionEvent -> {
                dataSliceCatClass.from = textActionEvent.getValue();
                onChangeCallback.onChange(this);
            });
            this.fromField.setValue(dataSliceCatClass.from);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.inputPanel.add((Component)this.fromField, gridBagConstraints);
            this.toField.getLabel().setHorizontalAlignment(0);
            this.toField.setCrossPanelVisible(false);
            this.toField.addChangeListener(textActionEvent -> {
                dataSliceCatClass.to = textActionEvent.getValue();
                onChangeCallback.onChange(this);
            });
            this.toField.setValue(dataSliceCatClass.to);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            this.inputPanel.add((Component)this.toField, gridBagConstraints2);
        }

        public BreezeInputField getValueField() {
            return this.fromField;
        }

        @Override
        public synchronized void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.fromField.getTextField().getTextField().addFocusListener(focusListener);
            this.toField.getTextField().getTextField().addFocusListener(focusListener);
        }
    }

    public static class ExpressionDeleteCatClassInputField
    extends DeleteCatClassInputField {
        private final BreezeInputField inputField = new BreezeInputField("Exp.", "", "", BreezeInputFieldHelper.Format.OneRow);

        public ExpressionDeleteCatClassInputField(CatClass catClass, String string, OnChangeCallback onChangeCallback) {
            super(catClass, onChangeCallback);
            this.inputField.setText(string);
            this.inputField.setLabelWidth(40);
            this.inputField.addChangeListener(textActionEvent -> onChangeCallback.onChange(this));
            this.inputPanel.add((Component)this.inputField, "Center");
        }

        public BreezeInputField getValueField() {
            return this.inputField;
        }

        @Override
        public String getValue() {
            return this.inputField.getValue();
        }

        @Override
        public synchronized void addFocusListener(FocusListener focusListener) {
            super.addFocusListener(focusListener);
            this.inputField.getTextField().getTextField().addFocusListener(focusListener);
        }
    }
}

