/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JPanel;
import lombok.Generated;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.validator.NoSpacesPathValidator;
import se.prediktera.breeze.util.FilePathString;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class FileInputField
extends JPanel {
    private final BreezeInputField inputField;
    private final BreezeButton browseButton;

    public FileInputField(Component component, String string, String string2) {
        this(component, string, string2, (TextActionEvent textActionEvent) -> {}, true);
    }

    public FileInputField(Component component, String string, String string2, TextActionEvent.TextActionListener textActionListener) {
        this(component, string, string2, textActionListener, true);
    }

    public FileInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener) {
        this(component, string, file, textActionListener, true);
    }

    public FileInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener, boolean bl) {
        this(component, string, new FilePathString(file).toString(), textActionListener, bl, BreezeInputFieldHelper.Format.OneRow);
    }

    public FileInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener, boolean bl, BreezeInputFieldHelper.Format format) {
        this(component, string, new FilePathString(file).toString(), textActionListener, bl, format);
    }

    public FileInputField(Component component, String string, String string2, TextActionEvent.TextActionListener textActionListener, boolean bl) {
        this(component, string, string2, textActionListener, bl, BreezeInputFieldHelper.Format.OneRow);
    }

    public FileInputField(Component component, String string, String string2, TextActionEvent.TextActionListener textActionListener, boolean bl, BreezeInputFieldHelper.Format format) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.inputField = new BreezeInputField(string, string2, "", format);
        if (string.isEmpty()) {
            this.inputField.getLabel().setVisible(false);
        }
        if (format.equals((Object)BreezeInputFieldHelper.Format.OneRow)) {
            this.inputField.setLabelWidth(250);
        }
        if (textActionListener != null) {
            this.inputField.addChangeListener(textActionListener);
        }
        if (!bl) {
            this.inputField.addValidator(new NoSpacesPathValidator());
        }
        this.getTextField().addCrossPanelListener(this::onFileSelected);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.inputField, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        if (format.equals((Object)BreezeInputFieldHelper.Format.OneRow)) {
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(2, this.useIcon() ? 0 : 5, 0, 0);
        } else {
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(20, 5, this.useIcon() ? 1 : 2, 0);
        }
        if (this.useIcon()) {
            this.browseButton = EntryMainHelper.createButton("browse", "", "material/file_open", () -> this.browseClicked(component, string));
            this.add((Component)this.browseButton, gridBagConstraints2);
        } else {
            this.browseButton = EntryMainHelper.createSmallTextButton("Browse", () -> this.browseClicked(component, string));
            this.add((Component)this.browseButton, gridBagConstraints2);
        }
    }

    protected boolean useIcon() {
        return false;
    }

    private void browseClicked(Component component, String string) {
        this.onBrowse();
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, component);
        File file = this.getFile();
        if (file != null) {
            if (file.isDirectory()) {
                jopensaveDialog2.setCurrentDirectory(file);
            } else {
                jopensaveDialog2.setSelectedFile(file);
            }
        } else {
            File file2 = this.getDefaultDirectory();
            if (file2 != null) {
                jopensaveDialog2.setCurrentDirectory(file2);
            }
        }
        jopensaveDialog2.setPreview(null, true);
        this.customizeDialog(jopensaveDialog2);
        if (jopensaveDialog2.openshow()) {
            this.fileSelected(jopensaveDialog2.getSelectedFile());
            this.onFileSelected();
        }
    }

    protected File getDefaultDirectory() {
        return null;
    }

    protected void onBrowse() {
    }

    protected void onFileSelected() {
    }

    public void save(Component component, String string, String string2, SaveCallback saveCallback) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog(string, component);
        this.customizeDialog(jopensaveDialog2);
        jopensaveDialog2.setFileName(string2);
        if (jopensaveDialog2.saveshow()) {
            saveCallback.onSave(jopensaveDialog2.getSelectedFile());
        }
    }

    protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
        jopensaveDialog2.addExtension("txt", "Text format");
        jopensaveDialog2.addAllFiles();
    }

    protected void fileSelected(File file) {
        this.inputField.setTextAndTrigger(file.getAbsolutePath());
    }

    public String getDesc() {
        return this.inputField.getDescription();
    }

    public BreezeTextField getTextField() {
        return this.inputField.getTextField();
    }

    public void setFormat(BreezeInputFieldHelper.Format format) {
        this.inputField.setFormat(format);
    }

    public void setFile(File file) {
        if (file != null) {
            this.inputField.setValue(file.getAbsolutePath());
        } else {
            this.inputField.setValue("");
        }
    }

    public File getFile() {
        return this.getFile(null);
    }

    public File getFile(Workflow workflow) {
        return FileHelper.getFileUsingConstants(workflow, this.getValue());
    }

    public boolean hasValue() {
        return !this.inputField.getValue().isEmpty();
    }

    public String getValue() {
        String string = this.inputField.getValue();
        if (!string.isEmpty()) {
            return string;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setEditable(bl);
    }

    public void setEditable(boolean bl) {
        this.inputField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    public void setUsage(String string) {
        this.inputField.setUsage(string);
        this.inputField.reFormat();
    }

    @Generated
    public BreezeInputField getInputField() {
        return this.inputField;
    }

    @Generated
    public BreezeButton getBrowseButton() {
        return this.browseButton;
    }

    public static interface SaveCallback {
        public void onSave(File var1);
    }

    public static class FolderInputField
    extends FileInputField {
        public FolderInputField(Component component, String string, File file) {
            this(component, string, file, (TextActionEvent textActionEvent) -> {}, true);
        }

        public FolderInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener) {
            this(component, string, file, textActionListener, true);
        }

        public FolderInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener, boolean bl) {
            this(component, string, file, textActionListener, bl, BreezeInputFieldHelper.Format.OneRow);
        }

        public FolderInputField(Component component, String string, File file, TextActionEvent.TextActionListener textActionListener, boolean bl, BreezeInputFieldHelper.Format format) {
            super(component, string, new FilePathString(file).toString(), textActionListener, bl, format);
        }

        @Override
        protected void customizeDialog(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.setFileSelectionMode(1);
        }
    }
}

