/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class ImageRenderPanel
extends JPanel {
    public static final Timer loadTimer = new Timer("LoadTimer", false);
    protected Image image = null;
    protected double scale;
    protected int sw;
    protected int sh;
    protected int sx;
    protected int sy;
    private int loadIndex;
    private boolean taskScheduled;

    public ImageRenderPanel() {
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.image != null) {
            if (d > 0.0 && d2 > 0.0) {
                double d3 = this.image.getWidth(null);
                double d4 = this.image.getHeight(null);
                this.scale = 1.0;
                this.sw = (int)(this.scale * d3);
                this.sh = (int)(this.scale * d4);
                this.sx = (int)(d / 2.0 - (double)(this.sw / 2));
                this.sy = (int)(d2 / 2.0 - (double)(this.sh / 2));
                graphics.drawImage(this.image, this.sx, this.sy, this.sw, this.sh, null);
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = (int)(d / 6.0);
            int n2 = (int)(d / 10.0);
            int n3 = (int)(d / 2.0 - (double)n - (double)(n2 / 2));
            int n4 = (int)(d2 / 2.0 - (double)(n2 / 2));
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            graphics2D.fillOval(n3 + this.loadIndex * n, n4, n2, n2);
            for (int i = 0; i < 3; ++i) {
                graphics2D.drawOval(n3 + i * n, n4, n2, n2);
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public void setImage(Image image, final Runnable runnable) {
        this.image = image;
        if (this.image == null && !this.taskScheduled) {
            this.taskScheduled = true;
            if (++this.loadIndex == 3) {
                this.loadIndex = 0;
            }
            loadTimer.schedule(new TimerTask(this){
                final /* synthetic */ ImageRenderPanel this$0;
                {
                    this.this$0 = imageRenderPanel;
                }

                @Override
                public void run() {
                    runnable.run();
                    this.this$0.taskScheduled = false;
                }
            }, 300L);
        }
    }
}

