/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.TextActionEvent;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.information.InformationPanel;
import se.prediktera.breeze.hardware.camera.RemoteCameraSettings;

public class InputFieldHelper {
    public static BreezeInputField addPanel(JPanel jPanel, BreezeInputField breezeInputField, TextActionEvent.TextActionListener textActionListener) {
        InputFieldHelper.addPanel(jPanel, breezeInputField);
        if (textActionListener != null) {
            breezeInputField.addChangeListener(textActionListener);
        }
        return breezeInputField;
    }

    public static JComponent addPanel(JPanel jPanel, JComponent jComponent) {
        return InputFieldHelper.addPanel(jPanel, jComponent, true, null);
    }

    public static JComponent addPanel(JPanel jPanel, JComponent jComponent, boolean bl, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            gridBagConstraints.fill = 2;
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.insets = insets != null ? insets : new Insets(6, 0, 0, 0);
        jComponent.setOpaque(false);
        jPanel.add((Component)jComponent, gridBagConstraints);
        return jComponent;
    }

    public static JComponent addButton(JPanel jPanel, JComponent jComponent) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        return jComponent;
    }

    public static void addBottomFillPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = jPanel.getComponentCount();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(new BorderLayout()), gridBagConstraints);
    }

    public static void addWarningsPanel(JPanel jPanel, RemoteCameraSettings remoteCameraSettings) {
        JPanel jPanel2 = InformationPanel.createWarningsPanel(remoteCameraSettings.getWarnings());
        if (jPanel2 != null) {
            InputFieldHelper.addPanel(jPanel, jPanel2);
        }
    }
}

