/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public final class SelectionMemory {
    private static final Map<String, Object> STORE = new ConcurrentHashMap<String, Object>();
    private static final Map<Object, String> PARENT_CLASS_CACHE = new WeakHashMap<Object, String>();

    private SelectionMemory() {
    }

    private static String key(Object object2, String string) {
        if (object2 == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException("componentKey must not be null/blank");
        }
        String string2 = PARENT_CLASS_CACHE.computeIfAbsent(object2, object -> object.getClass().getName());
        return string2 + "#" + string;
    }

    public static <T> void remember(Object object, String string, T t) {
        String string2 = SelectionMemory.key(object, string);
        if (t == null) {
            STORE.remove(string2);
        } else {
            STORE.put(string2, t);
        }
    }

    public static <T> Optional<T> recall(Object object, String string, Class<T> clazz) {
        Object object2 = STORE.get(SelectionMemory.key(object, string));
        return object2 != null && clazz.isInstance(object2) ? Optional.of(object2) : Optional.empty();
    }

    public static void rememberIdentity(Object object, String string, Object object2) {
        SelectionMemory.remember(object, string, object2 == null ? null : new WeakReference<Object>(object2));
    }

    private static String requireName(JComponent jComponent) {
        String string = jComponent.getName();
        if (string == null || string.isBlank()) {
            throw new IllegalArgumentException(jComponent.getClass().getSimpleName() + " must have setName(...) or pass an explicit componentKey.");
        }
        return string;
    }

    public static void applyCheckBox(Object object, JCheckBox jCheckBox, String string) {
        SelectionMemory.applyCheckBox(object, jCheckBox, string, false);
    }

    public static void applyCheckBox(Object object, JCheckBox jCheckBox, String string, boolean bl) {
        SelectionMemory.recall(object, string, Boolean.class).ifPresentOrElse(jCheckBox::setSelected, () -> jCheckBox.setSelected(bl));
    }

    public static void applyCheckBox(Object object, JCheckBox jCheckBox) {
        SelectionMemory.applyCheckBox(object, jCheckBox, SelectionMemory.requireName(jCheckBox));
    }

    public static void applyCheckBox(Object object, JCheckBox jCheckBox, boolean bl) {
        SelectionMemory.applyCheckBox(object, jCheckBox, SelectionMemory.requireName(jCheckBox), bl);
    }

    public static <T> void applyComboBoxIdentity(Object object, JComboBox<T> jComboBox, String string) {
        SelectionMemory.applyComboBoxIdentity(object, jComboBox, string, null);
    }

    public static <T> void applyComboBoxIdentity(Object object, JComboBox<T> jComboBox, String string, T t) {
        Object object2;
        Object object3;
        Object object4 = STORE.get(SelectionMemory.key(object, string));
        if (object4 instanceof WeakReference) {
            object3 = (WeakReference)object4;
            v0 = ((Reference)object3).get();
        } else {
            v0 = object2 = object4;
        }
        if (object2 != null) {
            object3 = jComboBox.getModel();
            for (int i = 0; i < object3.getSize(); ++i) {
                Object e = object3.getElementAt(i);
                if (e != object2) continue;
                jComboBox.setSelectedItem(e);
                return;
            }
        }
        if (t != null) {
            jComboBox.setSelectedItem(t);
        }
    }

    public static <T> void applyComboBoxIdentity(Object object, JComboBox<T> jComboBox) {
        SelectionMemory.applyComboBoxIdentity(object, jComboBox, SelectionMemory.requireName(jComboBox));
    }

    public static <T> void applyComboBoxIdentity(Object object, JComboBox<T> jComboBox, T t) {
        SelectionMemory.applyComboBoxIdentity(object, jComboBox, SelectionMemory.requireName(jComboBox), t);
    }
}

