/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class WaitCursor
implements AutoCloseable {
    private Component glassPane;
    private boolean wasVisible;
    private Cursor oldCursor;
    private static final MouseAdapter BLOCKER = new MouseAdapter(){};

    public WaitCursor() {
        Window window;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        JRootPane jRootPane = null;
        if (component != null) {
            jRootPane = SwingUtilities.getRootPane(component);
        }
        if (jRootPane == null && (window = keyboardFocusManager.getActiveWindow()) instanceof RootPaneContainer) {
            RootPaneContainer rootPaneContainer = (RootPaneContainer)((Object)window);
            jRootPane = rootPaneContainer.getRootPane();
        }
        if (jRootPane != null) {
            this.glassPane = jRootPane.getGlassPane();
            this.oldCursor = this.glassPane.getCursor();
            this.wasVisible = this.glassPane.isVisible();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.glassPane.addMouseListener(BLOCKER);
            this.glassPane.setVisible(true);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    @Override
    public void close() {
        if (this.glassPane != null) {
            this.glassPane.setCursor(this.oldCursor);
            this.glassPane.setVisible(this.wasVisible);
            this.glassPane.removeMouseListener(BLOCKER);
        }
    }
}

