/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.contextmenu;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.map.plot.axisplot.windows.LegendWindow;

public class BreezeContextMenu
extends AbstractBreezeDialog {
    private static final int Insets = 6;
    private final PopupContentPanel contentPanel;
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    private final JPanel southPanel;
    private String direction;
    private final int arrowHeight = 10;
    private final int fontSize = 14;
    private final BreezeContextMenu parentMenu;
    private int selectedColumn = -1;

    public BreezeContextMenu(BreezeFrame breezeFrame, Color color) {
        this(breezeFrame, color, null);
    }

    public BreezeContextMenu(final BreezeFrame breezeFrame, Color color, final BreezeContextMenu breezeContextMenu) {
        super(breezeFrame, color, true, false, -1);
        this.parentMenu = breezeContextMenu;
        this.contentPanel = new PopupContentPanel();
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.contentPanel.setBackground(breezeTheme.getSettingPanelBackground());
        this.contentPanel.setForeground(breezeTheme.getSettingPanelBackground());
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.setOpaque(false);
        this.centerPanel.setOpaque(false);
        this.contentPanel.add((Component)this.centerPanel, "Center");
        this.southPanel = new JPanel();
        this.southPanel.setOpaque(false);
        this.add(this.contentPanel);
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ BreezeContextMenu this$0;
            {
                this.this$0 = breezeContextMenu3;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (breezeContextMenu != null) {
                    MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BreezeContextMenu.getComponent(mouseEvent), mouseEvent, breezeFrame.getContentPane());
                    this.this$0.close(mouseEvent2.getPoint());
                } else {
                    this.this$0.close(null);
                }
            }
        });
        this.contentPanel.setDoPaint(false);
    }

    public void addComponent(JComponent jComponent) {
        this.addComponent(jComponent, new Insets(6, 6, 6, 6));
    }

    private void addComponent(BreezeMenuButton breezeMenuButton, int n) {
        int n2 = this.centerPanel.getComponentCount();
        if (n2 > 0 && this.centerPanel.getComponent(n2 - 1) instanceof BreezeMenuButton) {
            this.addComponent(new SepartorPanel(BreezeTheme.getInstance().darker(BreezeTheme.getInstance().getSettingPanelBackground()), 1), new Insets(0, 0, 0, 0));
        }
        this.addComponent((JComponent)breezeMenuButton, new Insets(n, 6, n, 6));
    }

    public void addComponent(JComponent jComponent, Insets insets) {
        int n = this.centerPanel.getComponentCount();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.centerPanel.add((Component)jComponent, gridBagConstraints);
    }

    public void addTitle(String string) {
        this.addComponent(new BreezeLabel(string, false, 14), new Insets(6, 6, 0, 6));
    }

    public BreezeMenuButton addButton(String string, EntryMainHelper.ClickCallBack clickCallBack, String string2) {
        BreezeMenuButton breezeMenuButton = new BreezeMenuButton(string, clickCallBack, 14, false, string2);
        this.addComponent(breezeMenuButton, 2);
        return breezeMenuButton;
    }

    public BreezeMenuButton addButtonCloseClick(String string, EntryMainHelper.ClickCallBack clickCallBack) {
        return this.addButtonCloseClick(string, clickCallBack, null);
    }

    public BreezeMenuButton addButtonCloseClick(String string, EntryMainHelper.ClickCallBack clickCallBack, String string2) {
        return this.addButton(string, () -> {
            this.close(null);
            clickCallBack.doClick();
        }, string2);
    }

    public BreezeMenuButton addSubMenu(String string, PopupCallback popupCallback) {
        return this.addSubMenu(string, popupCallback, null);
    }

    public BreezeMenuButton addSubMenu(String string, PopupCallback popupCallback, String string2) {
        BreezeMenuButton breezeMenuButton = new BreezeMenuButton(string, null, 14, true, string2);
        breezeMenuButton.addClickCallBack(() -> {
            BreezeContextMenu breezeContextMenu = new BreezeContextMenu(this.frame, Color.red, this);
            popupCallback.addCustom(breezeContextMenu);
            if (breezeContextMenu.resize()) {
                Point point = new Point(this.getLocation());
                SwingUtilities.convertPointToScreen(point, breezeMenuButton);
                SwingUtilities.convertPointFromScreen(point, this.frame.getContentPane());
                breezeContextMenu.setPositionLater((int)point.getX() + breezeMenuButton.getWidth(), (int)point.getY() + breezeMenuButton.getHeight() / 2);
                this.frame.addPage((JPanel)((Object)breezeContextMenu));
            }
        });
        this.addComponent(breezeMenuButton, 2);
        return breezeMenuButton;
    }

    public boolean resize() {
        return this.centerPanel.getComponentCount() > 0;
    }

    public void setDrawArrow(boolean bl) {
        this.contentPanel.setDrawArrow(bl);
    }

    public void show(MouseEvent mouseEvent) {
        this.frame.add((Component)((Object)this));
        this.setPositionLater(mouseEvent);
    }

    public void setPositionLater(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BreezeContextMenu.getComponent(mouseEvent), mouseEvent, this.frame);
        this.setPositionLater(mouseEvent2.getX() - this.frame.getInsets().left, mouseEvent2.getY() - this.frame.getInsets().top);
    }

    private static Component getComponent(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component instanceof LegendWindow) {
            LegendWindow legendWindow = (LegendWindow)component;
            return legendWindow.getParent();
        }
        return component;
    }

    public void setPositionLater(Point point) {
        SwingUtilities.invokeLater(() -> this.setPosition(point.x, point.y));
    }

    public void setPositionLater(int n, int n2) {
        SwingUtilities.invokeLater(() -> this.setPosition(n, n2));
    }

    private void setPosition(int n, int n2) {
        double d = this.frame.getWidth();
        double d2 = this.frame.getHeight();
        double d3 = (double)n - d / 2.0;
        double d4 = (double)n2 - d2 / 2.0;
        double d5 = Math.abs(d3 / d);
        double d6 = Math.abs(d4 / d2);
        String string = "West";
        string = d5 > d6 ? (d3 > 0.0 ? "East" : "West") : (d4 > 0.0 ? "South" : "North");
        if (!string.equals(this.direction)) {
            this.direction = string;
            if (this.direction.equals("South") || this.direction.equals("North")) {
                this.southPanel.setPreferredSize(new Dimension(0, 10));
            } else {
                this.southPanel.setPreferredSize(new Dimension(10, 0));
            }
            this.contentPanel.add((Component)this.southPanel, this.direction);
            this.contentPanel.revalidate();
        }
        SwingUtilities.invokeLater(() -> {
            int n3 = 0;
            int n4 = 0;
            if (d5 > d6) {
                n4 = -this.contentPanel.getHeight() / 2;
                if (d3 > 0.0) {
                    n3 = -this.contentPanel.getWidth();
                }
            } else {
                n3 = -this.contentPanel.getWidth() / 2;
                if (d4 > 0.0) {
                    n4 = -this.contentPanel.getHeight();
                }
            }
            Dimension dimension = this.contentPanel.getPreferredSize();
            this.contentPanel.setBounds(n + n3, n2 + n4, dimension.width, dimension.height);
            this.contentPanel.setDoPaint(true);
        });
    }

    public void close() {
        this.close(null);
    }

    private void close(Point point) {
        if (point == null || !this.contentPanel.getBounds().contains(point.x, point.y)) {
            this.close(false, null);
            if (this.parentMenu != null) {
                this.parentMenu.close(point);
            }
        }
    }

    public int getItems() {
        return this.centerPanel.getComponentCount();
    }

    public void addSeparator() {
        this.addComponent(new SepartorPanel(BreezeTheme.getInstance().getPanelBackground(), 5), new Insets(0, 0, 0, 0));
    }

    public void clickItemWithText(String string) {
        for (Component component : this.centerPanel.getComponents()) {
            BreezeMenuButton breezeMenuButton;
            if (!(component instanceof BreezeMenuButton) || !(breezeMenuButton = (BreezeMenuButton)component).getText().startsWith(string)) continue;
            breezeMenuButton.doClick();
            return;
        }
        throw new RuntimeException("No item with text '" + string + "' found in popup");
    }

    public void setColumn(int n) {
        this.selectedColumn = n;
    }

    public int getSelectedColumn() {
        return this.selectedColumn;
    }

    public class PopupContentPanel
    extends JPanel {
        private boolean doPaint = false;
        private boolean drawArrow = true;

        public PopupContentPanel() {
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics graphics) {
            if (!this.doPaint) {
                return;
            }
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 0;
            int n4 = 0;
            if (Objects.equals(BreezeContextMenu.this.direction, "South")) {
                n2 -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "North")) {
                n4 = 10;
                n2 -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "West")) {
                n3 = 10;
                n -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "East")) {
                n -= 10;
            }
            graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
            graphics2D.drawRoundRect(n3, n4, n - 1, n2 - 1, 20, 20);
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.doPaint) {
                return;
            }
            super.setBounds(n, n2, n3, n4);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.doPaint) {
                return;
            }
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = 0;
            int n4 = 0;
            if (Objects.equals(BreezeContextMenu.this.direction, "South")) {
                n2 -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "North")) {
                n4 = 10;
                n2 -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "West")) {
                n3 = 10;
                n -= 10;
            } else if (Objects.equals(BreezeContextMenu.this.direction, "East")) {
                n -= 10;
            }
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRoundRect(n3, n4, n, n2, 20, 20);
            if (this.drawArrow) {
                AffineTransform affineTransform = graphics2D.getTransform();
                if (Objects.equals(BreezeContextMenu.this.direction, "South")) {
                    graphics2D.translate(n / 2, n2 - 1);
                } else if (Objects.equals(BreezeContextMenu.this.direction, "North")) {
                    graphics2D.translate(n / 2, 10);
                    graphics2D.rotate(Math.PI);
                } else if (Objects.equals(BreezeContextMenu.this.direction, "West")) {
                    graphics2D.translate(10, n2 / 2);
                    graphics2D.rotate(1.5707963267948966);
                } else if (Objects.equals(BreezeContextMenu.this.direction, "East")) {
                    graphics2D.translate(n - 1, n2 / 2);
                    graphics2D.rotate(-1.5707963267948966);
                }
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(-10.0f, -1.0f);
                generalPath.lineTo(-1.0f, 10.0f);
                generalPath.lineTo(10.0f, -1.0f);
                generalPath.closePath();
                graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground());
                graphics2D.fill(generalPath);
                graphics2D.setColor(BreezeTheme.getInstance().getLabelForegroundLittleMoreDifuse());
                graphics2D.setStroke(new BasicStroke(1.0f));
                GeneralPath generalPath2 = new GeneralPath();
                generalPath2.moveTo(-10.0f, 0.0f);
                generalPath2.lineTo(-1.0f, 10.0f);
                generalPath2.lineTo(10.0f, 0.0f);
                graphics2D.draw(generalPath2);
                graphics2D.setTransform(affineTransform);
            }
        }

        @Generated
        public void setDoPaint(boolean bl) {
            this.doPaint = bl;
        }

        @Generated
        public void setDrawArrow(boolean bl) {
            this.drawArrow = bl;
        }
    }

    public static class BreezeMenuButton
    extends JPanel {
        private final JLabel subMenuLabel = new JLabel();
        private final JLabel nameLabel = new JLabel();
        private final JLabel iconLabel;
        private EntryMainHelper.ClickCallBack clickCallBack;
        private Color backgroundColor;

        public BreezeMenuButton(String string, EntryMainHelper.ClickCallBack clickCallBack, int n, boolean bl, String string2) {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints;
            Font font = new Font("Tahoma", 0, n);
            this.iconLabel = new JLabel();
            if (string2 != null) {
                this.iconLabel.setIcon(ImageHelper.getResourceIcon(string2));
            }
            this.subMenuLabel.setFont(font);
            this.subMenuLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
            this.subMenuLabel.setText(bl ? "\u203a" : " ");
            this.subMenuLabel.setPreferredSize(new Dimension(10, 10));
            this.subMenuLabel.setMinimumSize(new Dimension(10, 10));
            this.nameLabel.setFont(font);
            this.nameLabel.setText(string);
            this.nameLabel.setForeground(BreezeTheme.getInstance().getLabelForeground());
            int n2 = (int)((double)this.getFontMetrics(font).stringWidth(string) * 1.2);
            this.setPreferredSize(new Dimension(Math.max(180, n2), n * 2));
            if (clickCallBack != null) {
                this.addClickCallBack(clickCallBack);
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.mouseEnteredLocal();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.mouseExitedLocal();
                }
            };
            this.addMouseListener(mouseAdapter);
            this.subMenuLabel.addMouseListener(mouseAdapter);
            this.nameLabel.addMouseListener(mouseAdapter);
            if (string2 != null) {
                this.iconLabel.addMouseListener(mouseAdapter);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                this.add((Component)this.iconLabel, gridBagConstraints);
            }
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            this.add((Component)this.subMenuLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.anchor = 17;
            this.add((Component)this.nameLabel, gridBagConstraints2);
            this.backgroundColor = BreezeTheme.getInstance().getSettingPanelBackground();
            this.setBackground(this.backgroundColor);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        public String getText() {
            return this.nameLabel.getText();
        }

        public void addClickCallBack(EntryMainHelper.ClickCallBack clickCallBack) {
            this.clickCallBack = clickCallBack;
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.contains(SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this))) {
                        this.doClick();
                    }
                }
            };
            this.addMouseListener(mouseAdapter);
            this.subMenuLabel.addMouseListener(mouseAdapter);
            this.nameLabel.addMouseListener(mouseAdapter);
        }

        public void doClick() {
            this.requestFocus();
            this.clickCallBack.doClick();
        }

        protected void mouseEnteredLocal() {
            if (this.isEnabled()) {
                this.backgroundColor = BreezeTheme.getInstance().getPanelGradientBackground2();
                this.repaint();
            }
        }

        protected void mouseExitedLocal() {
            if (this.isEnabled()) {
                this.backgroundColor = BreezeTheme.getInstance().getSettingPanelBackground();
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.backgroundColor);
            graphics2D.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 10, 10);
            graphics2D.dispose();
        }

        @Generated
        public JLabel getIconLabel() {
            return this.iconLabel;
        }
    }

    private static class SepartorPanel
    extends JPanel {
        public SepartorPanel(Color color, int n) {
            this.setBackground(color);
            this.setPreferredSize(new Dimension(0, n));
        }
    }

    public static interface PopupCallback {
        public void addCustom(BreezeContextMenu var1);
    }
}

