/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.MainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.play.edit.EditWorkflowPanel;
import se.prediktera.map.common.cleanup.CleanUpPanel;

public abstract class AbstractBreezeDialog
extends CleanUpPanel {
    protected final BreezeFrame frame;
    private int result = 2;
    private final Color color;
    private BufferedImage bufferedImage = null;
    private final int opaquelevel;

    public AbstractBreezeDialog(BreezeFrame breezeFrame, Color color) {
        this(breezeFrame, color, true);
    }

    public AbstractBreezeDialog(BreezeFrame breezeFrame, Color color, boolean bl) {
        this(breezeFrame, color, true, bl, 100);
    }

    public AbstractBreezeDialog(BreezeFrame breezeFrame, Color color, boolean bl, boolean bl2, int n) {
        this.frame = breezeFrame;
        this.color = color;
        this.opaquelevel = n;
        if (SwingUtilities.isEventDispatchThread()) {
            this.createBackgroundImage();
            this.registerKeyActions(bl, bl2);
        } else {
            SwingUtilities.invokeLater(() -> {
                this.createBackgroundImage();
                this.registerKeyActions(bl, bl2);
            });
        }
    }

    private void registerKeyActions(boolean bl, boolean bl2) {
        if (bl) {
            this.registerKeyAction(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBreezeDialog.this.escapePressed();
                }
            });
        }
        if (bl2) {
            this.registerKeyAction(KeyStroke.getKeyStroke(10, 0), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractBreezeDialog.this.enterPressed();
                }
            });
        }
    }

    protected void escapePressed() {
        this.close(false, "");
    }

    public void close(boolean bl, Object object) {
        if (bl) {
            this.result = 0;
        }
        if (this.frame != null) {
            this.frame.removePage((JPanel)((Object)this), this.refreshSelectedEntry(null));
        }
        this.cleanUp();
    }

    public boolean refreshSelectedEntry(JPanel jPanel) {
        return false;
    }

    private void registerKeyAction(KeyStroke keyStroke, Action action) {
        InputMap inputMap = this.getInputMap(2);
        String string = "Input_" + inputMap.size();
        inputMap.put(keyStroke, string);
        ActionMap actionMap = this.getActionMap();
        actionMap.put(string, action);
    }

    protected void cleanUpChild() {
    }

    private void createBackgroundImage() {
        if (this.frame == null) {
            return;
        }
        JPanel jPanel = (JPanel)this.frame.getContentPane();
        Rectangle rectangle = jPanel.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
            Graphics2D graphics2D = (Graphics2D)this.bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            jPanel.paint(graphics2D);
            graphics2D.dispose();
            this.repaint();
        }
    }

    protected void enterPressed() {
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.bufferedImage != null) {
            graphics2D.drawImage((Image)this.bufferedImage, 0, 0, null);
        } else {
            super.paintComponent((Graphics)graphics2D);
            graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.opaquelevel >= 0) {
            graphics2D.setColor(new Color(128, 128, 128, 128));
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Generated
    public int getResult() {
        return this.result;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    public static class BreezeDialog
    extends AbstractBreezeDialog {
        private final double sizePercent;
        private int saveIndex;
        private JPanel panel;

        public BreezeDialog(BreezeFrame breezeFrame, double d) {
            super(breezeFrame, null);
            this.sizePercent = d;
            this.setLayout(new GridBagLayout());
        }

        @Override
        public boolean refreshSelectedEntry(JPanel jPanel) {
            if (jPanel instanceof EditWorkflowPanel) {
                return true;
            }
            return this.saveIndex != BreezeProperties.getInstance().getSaveIndex();
        }

        public void addPanel(JPanel jPanel) {
            this.panel = jPanel;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            BreezeFrame.setRelativeSize(jPanel, this.sizePercent);
            this.add(jPanel, gridBagConstraints);
            jPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForeground(), 1));
            if (jPanel instanceof EntryMainPanel) {
                EntryMainPanel entryMainPanel = (EntryMainPanel)jPanel;
                entryMainPanel.backButton.getButton().setName("none");
                entryMainPanel.topLeftPanel.setVisible(false);
                entryMainPanel.topRightPanel.setVisible(false);
                entryMainPanel.showLeftPanel = false;
                GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.gridx = 0;
                gridBagConstraints2.gridy = 0;
                gridBagConstraints2.gridwidth = 0;
                gridBagConstraints2.fill = 1;
                entryMainPanel.topPanel = new BreezeOptionDialog.TopPanel(entryMainPanel.getTitle(), entryMainPanel::backButtonClicked);
                entryMainPanel.add((Component)entryMainPanel.topPanel, gridBagConstraints2);
            }
            SwingUtilities.invokeLater(() -> {
                this.saveIndex = BreezeProperties.getInstance().getSaveIndex();
            });
        }

        @Override
        public void close(boolean bl, Object object) {
            Runnable runnable = () -> {
                Object object2 = this.panel;
                if (object2 instanceof EntryMainPanel) {
                    EntryMainPanel entryMainPanel = (EntryMainPanel)object2;
                    entryMainPanel.backButtonClicked();
                } else {
                    JPanel jPanel = this.panel;
                    if (jPanel instanceof MainPanelInterface) {
                        object2 = (MainPanelInterface)((Object)jPanel);
                        object2.cleanUp();
                    }
                    super.close(bl, object);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public static enum MessageType {
        CONFIRM_OPTION("OK", "Cancel"),
        CONFIRM_INFORMATION_OPTION("Yes", "No"),
        ERROR_OPTION,
        WARNING_OPTION,
        INFORMATION_OPTION,
        NO_BUTTON_OPTION("", ""),
        CLOSE_OPTION("Close", "Cancel"),
        INPUT_OPTION,
        INPUT_AREA_OPTION,
        CANCEL_OPTION,
        POPUP_OPTION,
        WIZARD_OPTION;

        private final ButtonTexts buttonTexts;
        private final DimensionOverride dimensionOverride;
        private final String defaultOk;
        private final String defaultCancel;

        private MessageType() {
            this("OK", "Cancel");
        }

        private MessageType(String string2, String string3) {
            this.buttonTexts = new ButtonTexts(string2, string3);
            this.dimensionOverride = new DimensionOverride(400, 500);
            this.defaultOk = string2;
            this.defaultCancel = string3;
        }

        public MessageType setOkText(String string) {
            this.buttonTexts.ok = StringUtils.isNotBlank((CharSequence)string) ? string : this.defaultOk;
            return this;
        }

        public MessageType setCancelText(String string) {
            this.buttonTexts.cancel = StringUtils.isNotBlank((CharSequence)string) ? string : this.defaultCancel;
            return this;
        }

        public MessageType setDimensionOverride(int n, int n2) {
            this.dimensionOverride.width = n;
            this.dimensionOverride.height = n2;
            return this;
        }

        public MessageType setDimensionOverrideWidth(int n) {
            this.dimensionOverride.width = n;
            return this;
        }

        public MessageType setDimensionOverrideHeight(int n) {
            this.dimensionOverride.height = n;
            return this;
        }

        @Generated
        public ButtonTexts getButtonTexts() {
            return this.buttonTexts;
        }

        @Generated
        public DimensionOverride getDimensionOverride() {
            return this.dimensionOverride;
        }

        public static class ButtonTexts {
            private String ok;
            private String cancel;

            @Generated
            public String getOk() {
                return this.ok;
            }

            @Generated
            public String getCancel() {
                return this.cancel;
            }

            @Generated
            public ButtonTexts(String string, String string2) {
                this.ok = string;
                this.cancel = string2;
            }
        }

        public static class DimensionOverride {
            private int height;
            private int width;

            @Generated
            public int getHeight() {
                return this.height;
            }

            @Generated
            public int getWidth() {
                return this.width;
            }

            @Generated
            public DimensionOverride(int n, int n2) {
                this.height = n;
                this.width = n2;
            }
        }
    }
}

