/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Semaphore;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeTextInputPanel;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.util.UserFriendlyExceptionString;

public class BreezeOptionDialog
extends AbstractBreezeDialog {
    public static final int insets = 15;
    public static final int buttonFontSize = 14;
    public static final int buttonWidth = 120;
    public static final int buttonHeight = 35;
    private static ImageIcon INFO_ICON;
    private static ImageIcon QUESTION_ICON;
    private static ImageIcon ERROR_ICON;
    private static ImageIcon WARNING_ICON;
    private final BreezeActionListener actionListener;
    private final AbstractBreezeDialog.MessageType optionType;
    protected AbstractBreezeCustomPanel breezeCustomPanel;
    private final BreezeButton okButton = new BreezeButton();
    protected final JTextArea textArea = new JTextArea();
    private final TopPanel topPanel;

    public static void clearIconCache() {
        INFO_ICON = ImageHelper.getResourceIcon("information");
        QUESTION_ICON = ImageHelper.getResourceIcon("help");
        ERROR_ICON = ImageHelper.tintIconWithColor(ImageHelper.getResourceIcon("error"), BreezeTheme.getInstance().getCautionColor());
        WARNING_ICON = ImageHelper.tintIconWithColor(ImageHelper.getResourceIcon("warning"), BreezeTheme.getInstance().getWarningColor());
    }

    public static boolean showDialogAndWait(BreezeFrame breezeFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must not block EDT");
        }
        final BoolHolder boolHolder = new BoolHolder(false);
        try {
            final Semaphore semaphore = new Semaphore(0);
            BreezeOptionDialog.showDialog(breezeFrame, color, messageType, string, string2, null, new BreezeActionListener(){

                @Override
                public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    boolHolder.setTrue();
                    semaphore.release();
                }

                @Override
                public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    semaphore.release();
                }
            });
            semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return boolHolder.getValue();
    }

    public static void showDialog(BreezeFrame breezeFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2) {
        BreezeOptionDialog.showDialog(breezeFrame, color, messageType, string, string2, null, null);
    }

    public static void showDialog(BreezeFrame breezeFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2, Object object, BreezeActionListener breezeActionListener) {
        BreezeOptionDialog.showDialog(breezeFrame, color, messageType, string, string2, null, object, breezeActionListener);
    }

    public static void showDialog(BreezeFrame breezeFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2, AbstractBreezeCustomPanel abstractBreezeCustomPanel, Object object, BreezeActionListener breezeActionListener) {
        if (breezeFrame != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                breezeFrame.addPage((JPanel)((Object)new BreezeOptionDialog(breezeFrame, color, messageType, string, string2, abstractBreezeCustomPanel, object, breezeActionListener)));
            } else {
                SwingUtilities.invokeLater(() -> breezeFrame.addPage((JPanel)((Object)new BreezeOptionDialog(breezeFrame, color, messageType, string, string2, abstractBreezeCustomPanel, object, breezeActionListener))));
            }
        }
    }

    public static void showDialog(JFrame jFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2, AbstractBreezeCustomPanel abstractBreezeCustomPanel, Object object, final BreezeActionListener breezeActionListener) {
        if (jFrame == null) {
            return;
        }
        Runnable runnable = () -> {
            BreezeFrame breezeFrame;
            final JDialog jDialog = new JDialog((Window)jFrame, null, Dialog.ModalityType.APPLICATION_MODAL);
            jDialog.setUndecorated(true);
            jDialog.getRootPane().setBorder(BorderFactory.createEmptyBorder());
            BreezeOptionDialog breezeOptionDialog = new BreezeOptionDialog(jFrame instanceof BreezeFrame ? (breezeFrame = (BreezeFrame)jFrame) : null, color, messageType, string, string2, abstractBreezeCustomPanel, object, new BreezeActionListener(){

                @Override
                public void actionPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    jDialog.dispose();
                    if (breezeActionListener != null) {
                        breezeActionListener.actionPerformed(breezeActionEvent);
                    }
                }

                @Override
                public void cancelPerformed(BreezeActionListener.BreezeActionEvent breezeActionEvent) {
                    jDialog.dispose();
                }
            });
            breezeOptionDialog.addHierarchyListener(hierarchyEvent -> {});
            jDialog.setContentPane((Container)((Object)breezeOptionDialog));
            jDialog.pack();
            jDialog.setLocationRelativeTo(jFrame);
            jDialog.setVisible(true);
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void showDialog(BreezeFrame breezeFrame, AbstractBreezeDialog.MessageType messageType, String string, String string2, BreezeActionListener breezeActionListener) {
        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project, messageType, string, string2, breezeActionListener);
    }

    public static void showDialog(BreezeFrame breezeFrame, BreezeType breezeType, AbstractBreezeDialog.MessageType messageType, String string, String string2, BreezeActionListener breezeActionListener) {
        BreezeOptionDialog.showDialog(breezeFrame, breezeType.getColor(), messageType, string, string2, null, breezeActionListener);
    }

    public static void showDialog(BreezeMainPanel breezeMainPanel, AbstractBreezeDialog.MessageType messageType, String string, String string2) {
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), messageType, string, string2, null, null);
    }

    public static void showDialog(BreezeMainPanel breezeMainPanel, AbstractBreezeDialog.MessageType messageType, String string, String string2, BreezeActionListener breezeActionListener) {
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), breezeMainPanel.getPageColor(), messageType, string, string2, null, breezeActionListener);
    }

    public static void showErrorDialog(BreezeFrame breezeFrame, String string, Throwable throwable) {
        BreezeOptionDialog.showExceptionDialog(breezeFrame, AbstractBreezeDialog.MessageType.ERROR_OPTION, string, throwable);
    }

    public static void showExceptionDialog(BreezeFrame breezeFrame, AbstractBreezeDialog.MessageType messageType, String string, Throwable throwable) {
        BreezeOptionDialog.showDialog(breezeFrame, messageType, string, new UserFriendlyExceptionString(throwable).getFirst(300), (BreezeActionListener.BreezeActionEvent breezeActionEvent) -> {});
    }

    public BreezeOptionDialog() {
        this(null, Color.white, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Title", "Text", null, null, null);
    }

    public BreezeOptionDialog(BreezeFrame breezeFrame, Color color, AbstractBreezeDialog.MessageType messageType, String string, String string2, AbstractBreezeCustomPanel abstractBreezeCustomPanel, Object object, BreezeActionListener breezeActionListener) {
        super(breezeFrame, color, abstractBreezeCustomPanel == null || abstractBreezeCustomPanel.registerEnterAction());
        this.optionType = messageType;
        this.actionListener = breezeActionListener;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(new Color(0, 0, 0));
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(255, 255, 255));
        jPanel.setMinimumSize(new Dimension(messageType.getDimensionOverride().getWidth(), messageType.getDimensionOverride().getHeight()));
        jPanel.setPreferredSize(new Dimension(messageType.getDimensionOverride().getWidth() + 100, messageType.getDimensionOverride().getHeight() + 100));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.topPanel = new TopPanel(string, () -> this.close(false, null));
        jPanel.add((Component)this.topPanel, gridBagConstraints);
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setFont(new Font("Tahoma", 0, 16));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setName("dialogText");
        this.textArea.setText(string2);
        this.textArea.setForeground(breezeTheme.getLabelForeground());
        this.textArea.setBackground(breezeTheme.getDialogBackground());
        this.textArea.setCaretColor(this.textArea.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        if (object != null) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 15;
        } else {
            gridBagConstraints.fill = 1;
        }
        gridBagConstraints.insets = new Insets(20, 15, 20, 15);
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (abstractBreezeCustomPanel != null) {
            int n = abstractBreezeCustomPanel.getLeftRightInsets(15);
            gridBagConstraints.insets = new Insets(0, n, 0, n);
        } else {
            gridBagConstraints.insets = new Insets(0, 15, 0, 15);
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        BreezeButton breezeButton = new BreezeButton();
        breezeButton.setTextFontSize(14);
        breezeButton.setPreferredAndMinimumSize(120, 35);
        breezeButton.setName("previous");
        breezeButton.setText("Previous");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(20, 15, 15, 0);
        jPanel3.add((Component)breezeButton, gridBagConstraints);
        this.okButton.setTextFontSize(14);
        this.okButton.setForeground(Color.white);
        this.okButton.setPreferredAndMinimumSize(120, 35);
        this.okButton.setName("ok");
        this.okButton.setText(messageType.getButtonTexts().getOk());
        this.okButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeOptionDialog.this.okButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(20, 15, 15, 0);
        jPanel3.add((Component)this.okButton, gridBagConstraints);
        BreezeButton breezeButton2 = new BreezeButton();
        breezeButton2.setTextFontSize(14);
        breezeButton2.setPreferredAndMinimumSize(120, 35);
        breezeButton2.setName("cancel");
        breezeButton2.setText(messageType.getButtonTexts().getCancel());
        breezeButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                BreezeOptionDialog.this.cancelButtonMouseClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(20, 20, 15, 15);
        jPanel3.add((Component)breezeButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.add(jPanel, new GridBagConstraints());
        jPanel.setBackground(breezeTheme.getDialogBackground());
        this.okButton.setBackground(color);
        this.okButton.setBaseBorderColor(color);
        this.okButton.setTextForeground(Color.white);
        breezeButton.setVisible(false);
        if (abstractBreezeCustomPanel != null) {
            this.breezeCustomPanel = abstractBreezeCustomPanel;
            this.breezeCustomPanel.setOptionDialog(this);
            jPanel2.add((Component)this.breezeCustomPanel, "Center");
            if (abstractBreezeCustomPanel.usePreferredSize()) {
                jPanel.setPreferredSize(abstractBreezeCustomPanel.getPreferredSize());
            }
            abstractBreezeCustomPanel.customButton(breezeButton, this.okButton, breezeButton2);
            abstractBreezeCustomPanel.onShow();
        }
        int n = -1;
        switch (messageType) {
            case CONFIRM_OPTION: {
                n = 3;
                break;
            }
            case CONFIRM_INFORMATION_OPTION: {
                n = 1;
                break;
            }
            case ERROR_OPTION: {
                n = 0;
                breezeButton2.setVisible(false);
                this.okButton.requestFocus();
                break;
            }
            case WARNING_OPTION: {
                n = 2;
                breezeButton2.setVisible(false);
                this.okButton.requestFocus();
                break;
            }
            case INPUT_OPTION: {
                n = 1;
                jPanel.setPreferredSize(new Dimension(600, 300));
                this.breezeCustomPanel = new BreezeTextInputPanel(this, object);
                jPanel2.add((Component)this.breezeCustomPanel, "North");
                break;
            }
            case INPUT_AREA_OPTION: {
                n = 1;
                this.breezeCustomPanel = new BreezeTextInputPanel(this, object, true);
                this.breezeCustomPanel.setBorder(new EmptyBorder(10, 0, 0, 0));
                if (string2 == null || string2.isEmpty()) {
                    jPanel.setPreferredSize(new Dimension(600, 350));
                }
                jPanel2.add((Component)this.breezeCustomPanel, "North");
                break;
            }
            case INFORMATION_OPTION: 
            case CLOSE_OPTION: {
                n = 1;
                breezeButton2.setVisible(false);
                break;
            }
            case NO_BUTTON_OPTION: {
                n = 1;
                jPanel3.setVisible(false);
                break;
            }
            case WIZARD_OPTION: {
                breezeButton.setVisible(true);
                break;
            }
        }
        switch (n) {
            case 3: {
                this.topPanel.setIcon(QUESTION_ICON);
                break;
            }
            case 0: {
                this.topPanel.setIcon(ERROR_ICON);
                break;
            }
            case 1: {
                this.topPanel.setIcon(INFO_ICON);
                break;
            }
            case 2: {
                this.topPanel.setIcon(WARNING_ICON);
                break;
            }
            default: {
                this.topPanel.setIcon(null);
            }
        }
        jPanel2.setVisible(jPanel2.getComponentCount() > 0);
        jScrollPane.setVisible(string2 != null && !string2.isEmpty());
        jPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
    }

    @Override
    public void close(boolean bl, Object object) {
        super.close(bl, object);
        if (this.actionListener != null) {
            if (bl || this.optionType == AbstractBreezeDialog.MessageType.ERROR_OPTION) {
                this.actionListener.actionPerformed(new BreezeActionListener.BreezeActionEvent(this, object));
            } else {
                this.actionListener.cancelPerformed(new BreezeActionListener.BreezeActionEvent(this, object));
            }
        }
    }

    @Override
    public void enterPressed() {
        if (this.okButton.isVisible() && this.okButton.isEnabled()) {
            this.okButtonMouseClicked(null);
        }
    }

    public void okButtonMouseClicked(MouseEvent mouseEvent) {
        String string = "";
        if (this.breezeCustomPanel != null) {
            this.breezeCustomPanel.okPressed(mouseEvent != null);
        } else {
            this.close(true, string);
        }
    }

    @Override
    protected void escapePressed() {
        this.cancelButtonMouseClicked();
    }

    private void cancelButtonMouseClicked() {
        if (this.breezeCustomPanel != null) {
            this.breezeCustomPanel.cancelPressed();
        } else {
            this.close(false, "");
        }
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setTitle(String string) {
        this.topPanel.setTitle(string);
    }

    public String getTitle() {
        return this.topPanel.getTitle();
    }

    @Generated
    public AbstractBreezeCustomPanel getBreezeCustomPanel() {
        return this.breezeCustomPanel;
    }

    @Generated
    public JTextArea getTextArea() {
        return this.textArea;
    }

    static {
        BreezeOptionDialog.clearIconCache();
    }

    public static class TopPanel
    extends BreezeGradientPanel {
        private final JLabel topLabel = new JLabel();
        private final JPanel customPanel;

        public TopPanel(String string, Runnable runnable) {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelGradientBackground2());
            this.setForeground(breezeTheme.getPanelGradientBackground1());
            this.setLayout(new GridBagLayout());
            this.topLabel.setForeground(breezeTheme.getLabelForeground());
            this.topLabel.setBackground(new Color(150, 150, 150));
            this.topLabel.setFont(new Font("Tahoma", 0, 18));
            this.topLabel.setText(string);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 15, 10, 20);
            this.add((Component)this.topLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(10, 15, 10, 20);
            this.customPanel = new JPanel(new BorderLayout());
            this.add((Component)this.customPanel, gridBagConstraints);
            this.customPanel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(10, 15, 10, 15);
            BreezeButton breezeButton = EntryMainHelper.createButton("", "material/close", runnable::run);
            breezeButton.setName("up");
            breezeButton.setHoverIcon(ImageHelper.replaceTransparentBackgroundWithColor(ImageHelper.changeGrayBrightnessDarkTheme(breezeButton.getIcon()), new Color(194, 40, 45)));
            this.add((Component)breezeButton, gridBagConstraints);
        }

        private void setIcon(ImageIcon imageIcon) {
            if (imageIcon != null && BreezeTheme.getInstance().isDarkMode() && ImageHelper.isGrayscaleIcon(imageIcon)) {
                imageIcon = ImageHelper.changeGrayBrightnessDarkTheme(imageIcon);
            }
            this.topLabel.setIcon(imageIcon);
        }

        public void setTitle(String string) {
            this.topLabel.setText(" " + string);
        }

        public String getTitle() {
            return this.topLabel.getText();
        }

        @Generated
        public JPanel getCustomPanel() {
            return this.customPanel;
        }
    }
}

