/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.util.Holder;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressDialogInterface;

public class BreezeProgressDialog
extends AbstractBreezeDialog
implements ProgressDialogInterface {
    private static OnNextActionFinishCallback onNextActionFinishCallback;
    private final ProgressAction progressAction;
    private final BreezeButton cancelButton = new BreezeButton();
    private final JPanel centerPanel = new JPanel(new GridBagLayout());
    private final JPanel progressPanel = new JPanel();
    private final JLabel topLabel = new JLabel();

    public static void onNextActionFinish(OnNextActionFinishCallback onNextActionFinishCallback) {
        BreezeProgressDialog.onNextActionFinishCallback = onNextActionFinishCallback;
    }

    public static void startProgress(BreezeFrame breezeFrame, ProgressAction progressAction, String string) {
        BreezeProgressDialog.startProgress(breezeFrame, progressAction, string, 0, false);
    }

    public static void startProgress(BreezeFrame breezeFrame, final RunAction runAction, String string) {
        BreezeProgressDialog.startProgress(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                runAction.runAction(this.getProgressManager());
            }
        }, string, 0, false);
    }

    public static void startProgress(BreezeFrame breezeFrame, ProgressAction progressAction, String string, int n) {
        BreezeProgressDialog.startProgress(breezeFrame, progressAction, string, n, false);
    }

    public static void startProgressWithCancel(BreezeFrame breezeFrame, ProgressAction progressAction, String string) {
        BreezeProgressDialog.startProgress(breezeFrame, progressAction, string, 0, true);
    }

    public static void startProgress(BreezeFrame breezeFrame, ProgressAction progressAction, String string, int n, boolean bl) {
        BreezeProgressDialog.prepareProgressManager(breezeFrame, progressAction, string, n, bl, null).invokeLater();
    }

    public static void startProgressAndWait(BreezeFrame breezeFrame, ProgressAction progressAction, String string, int n) throws Exception {
        BreezeProgressDialog.startProgressWait(breezeFrame, progressAction, string, n, false);
    }

    public static void startProgressWait(BreezeFrame breezeFrame, ProgressAction progressAction, String string, int n, boolean bl) throws Exception {
        Holder holder = new Holder();
        BreezeProgress breezeProgress = BreezeProgressDialog.prepareProgressManager(breezeFrame, progressAction, string, n, bl, holder::setValue);
        breezeProgress.invokeNowAndWaitFinish();
        if (holder.getValue() != null) {
            throw (Exception)holder.getValue();
        }
    }

    private static BreezeProgress prepareProgressManager(final BreezeFrame breezeFrame, final ProgressAction progressAction, String string, int n, boolean bl, final OnExceptionCallback onExceptionCallback) {
        progressAction.actionPrepare();
        final BreezeProgressDialog breezeProgressDialog = new BreezeProgressDialog(breezeFrame, progressAction, bl);
        breezeProgressDialog.setTitle(string + BreezeProgressDialog.getPrefix(progressAction));
        BreezeProgressManager breezeProgressManager = new BreezeProgressManager(breezeProgressDialog.getProgressPanel(), 10000000){

            @Override
            public ProgressAction getAction() {
                return progressAction;
            }

            @Override
            public Object doWork() {
                try {
                    progressAction.runAction();
                    boolean bl = this.isAborted();
                    if (bl) {
                        progressAction.actionAborted();
                    } else {
                        progressAction.actionComplete();
                    }
                    this.finishAndRemoveDialog(breezeFrame, breezeProgressDialog);
                    if (!bl) {
                        progressAction.actionFinished();
                    }
                }
                catch (BreezeProgress.ProgressActionCancelledException progressActionCancelledException) {
                    this.finishAndRemoveDialog(breezeFrame, breezeProgressDialog);
                    progressAction.actionAborted();
                }
                catch (Exception exception) {
                    this.finishAndRemoveDialog(breezeFrame, breezeProgressDialog);
                    if (onExceptionCallback != null) {
                        onExceptionCallback.handleException(exception);
                    } else if (!progressAction.actionFailed(exception)) {
                        ErrorHandler.handleUncaughtException((Throwable)exception);
                    }
                }
                finally {
                    if (onNextActionFinishCallback != null) {
                        onNextActionFinishCallback.actionFinished();
                        onNextActionFinishCallback = null;
                    }
                }
                return null;
            }

            @Override
            public void setConsoleVisible(boolean bl) {
                super.setConsoleVisible(bl);
                breezeProgressDialog.setCenterPanelSize(600);
            }

            private void finishAndRemoveDialog(BreezeFrame breezeFrame2, BreezeProgressDialog breezeProgressDialog2) {
                this.Finish();
                if (this.contentPane.isCloseOnFinish()) {
                    this.onClose();
                } else {
                    BreezeButton breezeButton = breezeProgressDialog2.cancelButton;
                    breezeButton.setText("OK");
                    breezeButton.setEnabled(true);
                    breezeButton.clearMouseListeners();
                    breezeButton.addClickCallBack(this::onClose);
                }
            }

            public void onClose() {
                progressAction.onClose();
                breezeFrame.removePage((JPanel)((Object)breezeProgressDialog), false);
            }

            @Override
            public void show() {
                super.show();
                if (breezeFrame != null && !this.isFinished()) {
                    breezeFrame.addPage((JPanel)((Object)breezeProgressDialog));
                }
            }
        };
        progressAction.setProgressManager(breezeProgressManager);
        progressAction.setProgressInterface(breezeProgressDialog);
        if (n > 0) {
            breezeProgressManager.setDeciSeconds(n);
        }
        breezeProgressManager.getContentPane().setTouchScreen(breezeProgressDialog.getProgressPanel().getBackground());
        return breezeProgressManager;
    }

    private static String getPrefix(ProgressAction progressAction) {
        if (progressAction.hasCtrShiftDown()) {
            return " *";
        }
        if (progressAction.hasShiftDown()) {
            return " (Reuse)";
        }
        return "";
    }

    public BreezeProgressDialog(BreezeFrame breezeFrame, ProgressAction progressAction, boolean bl) {
        super(breezeFrame, null, bl, false, 100);
        this.setName("progressDialog");
        this.progressAction = progressAction;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        JPanel jPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.centerPanel.setBackground(breezeTheme.getDialogBackground());
        this.setCenterPanelSize(450);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 180, 0, 180);
        this.add(this.centerPanel, gridBagConstraints);
        this.progressPanel.setBackground(breezeTheme.getDialogBackground());
        this.progressPanel.setMinimumSize(new Dimension(0, 100));
        this.progressPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 120, 20, 120);
        this.centerPanel.add((Component)this.progressPanel, gridBagConstraints);
        BreezeGradientPanel breezeGradientPanel = new BreezeGradientPanel();
        breezeGradientPanel.setLayout(new GridBagLayout());
        breezeGradientPanel.setBackground(breezeTheme.getPanelGradientBackground2());
        breezeGradientPanel.setForeground(breezeTheme.getPanelGradientBackground1());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.centerPanel.add((Component)breezeGradientPanel, gridBagConstraints);
        this.topLabel.setForeground(breezeTheme.getLabelForeground());
        this.topLabel.setBackground(new Color(150, 150, 150));
        this.topLabel.setFont(new Font("Tahoma", 0, 18));
        this.topLabel.setText("Progress");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 15, 15, 15);
        breezeGradientPanel.add((Component)this.topLabel, gridBagConstraints);
        jPanel.setOpaque(false);
        jPanel.setLayout(new GridBagLayout());
        this.cancelButton.setTextFontSize(14);
        this.cancelButton.setForeground(breezeTheme.getButtonForeground());
        this.cancelButton.setPreferredAndMinimumSize(120, 35);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addClickCallBack(() -> this.close(false, ""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 30, 20);
        jPanel.add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.centerPanel.add((Component)jPanel, gridBagConstraints);
        jPanel.setVisible(bl);
        this.centerPanel.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
    }

    private void setCenterPanelSize(int n) {
        this.centerPanel.setMinimumSize(new Dimension(0, n));
        this.centerPanel.setPreferredSize(new Dimension(0, n));
    }

    public JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void setTitle(String string) {
        this.topLabel.setText(string);
    }

    @Override
    public void close(boolean bl, Object object) {
        this.cancelButton.setText("Aborting...");
        this.cancelButton.setEnabled(false);
        this.progressAction.abort();
    }

    public static interface OnNextActionFinishCallback {
        public void actionFinished();
    }

    public static interface RunAction {
        public void runAction(BreezeProgressManager var1);
    }

    private static interface OnExceptionCallback {
        public void handleException(Exception var1);
    }
}

