/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.cleanup.CleanUpClass;
import se.prediktera.map.common.cleanup.CleanUpDialog;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.common.progress.ProgressPanelInterface;
import se.prediktera.map.common.progress.SwingWorker;
import se.prediktera.map.main.Evince;
import se.prediktera.map.main.IniManager;

public abstract class BreezeProgressManager
extends CleanUpClass
implements ProgressManager,
BreezeProgress {
    private Runnable abortListener;
    private static final int MAXSIZE = 10000000;
    private ProgressManager.Result modalresult = ProgressManager.Result.notDone;
    protected Object[] arguments;
    protected BreezeProgressPanel contentPane = new BreezeProgressPanel(this);
    protected Dimension preferredDimension;
    private SwingWorker worker;
    private boolean isfinished = false;
    private boolean initializing = true;
    private boolean lockforchanges = false;
    private int groupShowIndex = 0;
    private final int totalstep = 0;
    private int deciseconds = 10;
    private Window progressWindow;
    private boolean abortable = false;
    private String infoText;
    private JPanel holderPanel = null;
    private final SwingTimer infoTextUpdateTimer = new SwingTimer(50, actionEvent -> {
        if (!this.lockforchanges) {
            this.contentPane.setText(this.infoText);
        }
    });

    public static BreezeProgressManager createEmpty() {
        return new BreezeProgressManager(){

            @Override
            public Object doWork() {
                return null;
            }

            @Override
            protected void init(int n) {
            }
        };
    }

    public static BreezeProgressManager createFake() {
        return new BreezeProgressManager(false){

            @Override
            public Object doWork() {
                return null;
            }
        };
    }

    public BreezeProgressManager() {
        this(IniManager.getMainFrame(), 10000000);
    }

    public BreezeProgressManager(boolean bl) {
    }

    public BreezeProgressManager(Frame frame) {
        this(frame, 10000000);
        this.progressWindow.setSize(450, 250);
        this.progressWindow.setLocationRelativeTo(null);
    }

    public BreezeProgressManager(Frame frame, int n) {
        this.progressWindow = new CleanUpDialog(frame, "Progress Bar", true){

            protected void cleanUpChild() {
            }
        };
        this.init(n);
    }

    public BreezeProgressManager(JDialog jDialog) {
        this(jDialog, 10000000);
    }

    public BreezeProgressManager(JDialog jDialog, int n) {
        this.progressWindow = new CleanUpDialog(jDialog, "Progress Bar", true){

            protected void cleanUpChild() {
            }
        };
        this.init(n);
    }

    public BreezeProgressManager(JPanel jPanel, int n) {
        this.holderPanel = jPanel;
        this.init(n);
    }

    public BreezeProgressManager(Object[] objectArray) {
        this();
        this.arguments = objectArray;
    }

    public BreezeProgressManager(String string) {
        JFrame jFrame = new JFrame(string);
        Evince.setFrameIcons((Window)jFrame);
        jFrame.setResizable(false);
        this.progressWindow = jFrame;
        this.init(10000000);
    }

    public void setMaxtextlength(int n) {
    }

    @Override
    public void abort() {
        this.modalresult = ProgressManager.Result.abort;
        if (this.abortListener != null) {
            this.abortListener.run();
        }
    }

    @Override
    public void addAbortListener(Runnable runnable) {
        this.abortListener = runnable;
    }

    public void abortButtonClicked() {
        this.abort();
        this.isfinished = true;
        this.cleanUp();
    }

    public void addDistributionInfo() {
    }

    public void bringToFront() {
        if (this.progressWindow != null) {
            this.progressWindow.toFront();
        }
    }

    public abstract Object doWork();

    public void Finish() {
        this.contentPane.stop();
        if (!this.isAborted()) {
            this.modalresult = ProgressManager.Result.ok;
        }
        this.isfinished = true;
        if (this.progressWindow != null) {
            this.cleanUp();
        }
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public ProgressPanelInterface getContentPane() {
        return this.contentPane;
    }

    public ProgressManager.Result getModalResults() {
        return this.modalresult;
    }

    public Object getResult() {
        return this.worker.getValue();
    }

    public int getTotalStep() {
        return 0;
    }

    public Window getWindow() {
        return this.progressWindow;
    }

    public void Hide() {
        this.contentPane.stop();
        this.modalresult = ProgressManager.Result.ok;
        if (this.progressWindow != null) {
            this.progressWindow.setVisible(false);
        }
    }

    public final void hideAnimationPanel() {
        this.contentPane.hideAnimationPanel();
    }

    @Override
    public final void incStep() {
        this.incStepInternal(1);
    }

    @Override
    public final void incStep(int n) {
        this.incStepInternal(n);
    }

    @Override
    public void setComplete() {
        if (!this.lockforchanges) {
            this.contentPane.setComplete();
        }
    }

    @Override
    public final void incStepGroup(int n) {
        if (!this.lockforchanges && n == 1) {
            this.contentPane.setGroupValue(this.contentPane.getGroupValue() + 1);
        }
    }

    public void invokeAndWait() {
        try {
            SwingUtilities.invokeAndWait((Runnable)((Object)this));
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
        }
    }

    @Override
    public void invokeLater() {
        SwingUtilities.invokeLater((Runnable)((Object)this));
    }

    @Override
    public void invokeNow() {
        this.run();
    }

    @Override
    public void invokeNowAndWaitFinish() {
        this.run();
        ThreadUtil.awaitOrThrow(() -> this.isfinished, Time.Forever);
    }

    @Override
    public final boolean isAborted() {
        return this.modalresult == ProgressManager.Result.abort;
    }

    @Override
    public boolean throwOnAborted() {
        return this.isAborted();
    }

    public final boolean isFinished() {
        return this.isfinished;
    }

    public boolean isGroupProgressBarVisible() {
        return this.contentPane.isGroupVisible();
    }

    public void lockForChanges(boolean bl) {
        this.lockforchanges = bl;
        SwingUtilities.invokeLater(() -> {
            try {
                this.contentPane.setIndeterminate(bl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public void resetProgressValue() {
        if (this.lockforchanges) {
            return;
        }
        this.contentPane.setValue(0);
    }

    public void run() {
        this.worker = new SwingWorker(){

            public Object construct() {
                Object object = BreezeProgressManager.this.doWork();
                BreezeProgressManager.this.isfinished = true;
                return object;
            }

            public void finished() {
                BreezeProgressManager.this.Finish();
            }
        };
        try {
            this.isfinished = false;
            this.worker.start();
            Thread.sleep(50L);
            for (int i = 0; !this.isfinished && (i < this.deciseconds || this.initializing); ++i) {
                Thread.sleep(50L);
            }
            if (!this.isfinished) {
                this.runInternal();
            }
        }
        catch (InterruptedException interruptedException) {
            this.Finish();
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
            this.Finish();
        }
    }

    public void setAbortable(boolean bl) {
        this.abortable = bl;
        this.contentPane.setAbortable(bl);
        Window window = this.progressWindow;
        if (window instanceof JDialog) {
            JDialog jDialog = (JDialog)window;
            if (bl) {
                jDialog.setDefaultCloseOperation(2);
            } else {
                jDialog.setDefaultCloseOperation(0);
            }
        }
    }

    public void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    public void setDeciSeconds(int n) {
        this.deciseconds = n;
    }

    @Override
    public final int setGroupMaximumAndReset(int n) {
        if (!this.lockforchanges) {
            if (n > 0) {
                this.showGroupProgressBar(true);
                if (this.groupShowIndex == 1) {
                    this.contentPane.setGroupValue(0);
                    this.contentPane.setGroupIndeterminate(false);
                    this.contentPane.setGroupMaximum(n);
                }
            } else {
                this.showGroupProgressBar(false);
                this.contentPane.setGroupIndeterminate(true);
            }
        }
        return this.groupShowIndex;
    }

    public void setHolderPanel(JPanel jPanel) {
        this.holderPanel = jPanel;
    }

    @Override
    public void setIndeterminate(boolean bl) {
        this.contentPane.setIndeterminate(bl);
    }

    @Override
    public void setInfoText(String string) {
        if (!string.equals(this.infoText)) {
            this.infoText = string;
            this.infoTextUpdateTimer.restart();
        }
    }

    @Override
    public String getInfoText() {
        return this.infoText;
    }

    @Override
    public void setMaximumAndReset(int n) {
        if (!this.lockforchanges) {
            if (n > 0) {
                this.resetProgressValue();
                this.contentPane.setIndeterminate(false);
                this.contentPane.setMaximum(n);
            } else {
                this.contentPane.setIndeterminate(true);
            }
        }
    }

    public void setProgressValue(int n) {
    }

    @Override
    public int getProgress() {
        return this.contentPane.getValue();
    }

    @Override
    public ProgressAction getAction() {
        return null;
    }

    public void setProgressValueDirectly(int n) {
        if (!this.lockforchanges) {
            this.contentPane.setValue(n);
        }
    }

    public void show() {
        this.contentPane.start();
        this.modalresult = ProgressManager.Result.notDone;
        if (this.progressWindow != null) {
            try {
                this.progressWindow.setVisible(true);
            }
            catch (Throwable throwable) {
                ErrorHandler.logAndReportException((Throwable)throwable);
            }
        }
    }

    public void showGroupProgressBar(boolean bl) {
        this.groupShowIndex = bl ? ++this.groupShowIndex : --this.groupShowIndex;
        if (this.groupShowIndex <= 1) {
            this.contentPane.setGroupVisible(this.groupShowIndex != 0);
            if (this.progressWindow != null) {
                this.progressWindow.pack();
            }
        }
    }

    public final void subMaximum(int n) {
        if (!this.lockforchanges) {
            this.contentPane.setMaximum(this.contentPane.getMaximum() - n);
        }
    }

    protected void cleanUpChild() {
        this.arguments = null;
        this.preferredDimension = null;
        if (this.progressWindow != null) {
            if (this.progressWindow instanceof CleanUpDialog) {
                if (this.progressWindow.isVisible()) {
                    this.progressWindow.setVisible(false);
                }
                ((CleanUpDialog)this.progressWindow).cleanUp();
            } else if (this.progressWindow.isVisible()) {
                this.progressWindow.setVisible(false);
            }
            this.progressWindow = null;
        }
    }

    private final void incStepInternal(int n) {
        if (!this.lockforchanges) {
            this.contentPane.setValue(this.contentPane.getValue() + n);
        }
    }

    protected void init(int n) {
        this.contentPane.setIndeterminate(true);
        this.contentPane.setMinimum(0);
        this.contentPane.setMaximum(n);
        this.jbInit();
        if (this.progressWindow != null) {
            this.progressWindow.pack();
            this.preferredDimension = (Dimension)this.progressWindow.getPreferredSize().clone();
            this.progressWindow.setLocationRelativeTo(null);
        }
        this.initializing = false;
    }

    private void jbInit() {
        this.contentPane.setGroupVisible(false);
        if (this.progressWindow != null) {
            if (this.progressWindow instanceof JDialog) {
                ((JDialog)this.progressWindow).setContentPane(this.contentPane);
            } else {
                ((JFrame)this.progressWindow).setContentPane(this.contentPane);
            }
        }
        this.setAbortable(false);
    }

    private void runInternal() {
        this.contentPane.setAbortable(this.abortable);
        Cursor cursor = null;
        if (this.progressWindow != null) {
            cursor = this.progressWindow.getCursor();
            this.progressWindow.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (this.holderPanel != null) {
            this.holderPanel.setLayout(new BorderLayout());
            this.holderPanel.add((Component)this.contentPane, "Center");
            this.holderPanel.revalidate();
            this.holderPanel.repaint();
        }
        this.show();
        if (this.progressWindow != null) {
            this.progressWindow.setCursor(cursor);
        }
    }

    @Override
    public void setConsoleVisible(boolean bl) {
        this.contentPane.setConsolePaneVisible(bl);
    }

    @Override
    public void addConsoleText(String string) {
        this.contentPane.appendConsoleText(string);
    }

    public JTextPane getConsoleText() {
        return this.contentPane.getConsolePane();
    }
}

