/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import lombok.Generated;
import se.prediktera.breeze.common.util.BreezeColor;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeProgressBar;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.progress.ProgressPanelInterface;

public class BreezeProgressPanel
extends JPanel
implements ProgressPanelInterface {
    private static final ImageIcon[] progressImages = new ImageIcon[]{ImageHelper.getResourceIcon("progress/loader-0.png"), ImageHelper.getResourceIcon("progress/loader-1.png"), ImageHelper.getResourceIcon("progress/loader-2.png"), ImageHelper.getResourceIcon("progress/loader-3.png"), ImageHelper.getResourceIcon("progress/loader-4.png"), ImageHelper.getResourceIcon("progress/loader-5.png"), ImageHelper.getResourceIcon("progress/loader-6.png")};
    private final AnimPanel animPanel = new AnimPanel();
    private final JButton abortButton = new JButton();
    private final JPanel animationPanel = new JPanel();
    private final JPanel centerPanel = new JPanel();
    private final BreezeProgressBar groupProgressBar = new BreezeProgressBar();
    private final JLabel labelInfo = new JLabel();
    private final BreezeProgressBar progressBar = new BreezeProgressBar();
    private final JPanel southPanel = new JPanel();
    private final JTextPane consolePane = new JTextPane();
    private boolean closeOnFinish = true;
    private final JScrollPane scrollPane;

    public BreezeProgressPanel(BreezeProgressManager breezeProgressManager) {
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.southPanel.setLayout(new GridBagLayout());
        this.abortButton.setText("Abort");
        this.abortButton.setMinimumSize(new Dimension(74, 27));
        this.abortButton.setPreferredSize(new Dimension(74, 27));
        this.abortButton.addActionListener(actionEvent -> breezeProgressManager.abortButtonClicked());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.southPanel.add((Component)this.abortButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.southPanel, gridBagConstraints);
        this.centerPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.centerPanel.setLayout(new GridBagLayout());
        this.labelInfo.setText("Running...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.centerPanel.add((Component)this.labelInfo, gridBagConstraints);
        this.consolePane.setEditable(false);
        this.consolePane.setFont(new Font("Courier New", 0, 12));
        this.consolePane.setBackground(breezeTheme.getDialogBackground());
        this.consolePane.setForeground(breezeTheme.getLabelForeground());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.consolePane);
        this.scrollPane = new BreezeScrollPane(jPanel, true);
        this.scrollPane.setPreferredSize(new Dimension(300, 300));
        this.scrollPane.setMinimumSize(new Dimension(120, 120));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.centerPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.scrollPane.setVisible(false);
        this.progressBar.setMinimumSize(new Dimension(10, 16));
        this.progressBar.setPreferredSize(new Dimension(300, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.centerPanel.add((Component)this.progressBar, gridBagConstraints);
        this.groupProgressBar.setMinimumSize(new Dimension(10, 16));
        this.groupProgressBar.setPreferredSize(new Dimension(300, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.centerPanel.add((Component)this.groupProgressBar, gridBagConstraints);
        this.animationPanel.setPreferredSize(new Dimension(120, 120));
        this.animationPanel.setMinimumSize(new Dimension(120, 120));
        this.animationPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.centerPanel.add((Component)this.animationPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.centerPanel, gridBagConstraints);
        this.animationPanel.add((Component)this.animPanel, "Center");
    }

    public void hideAnimationPanel() {
        this.animPanel.setVisible(false);
    }

    public boolean isGroupVisible() {
        return this.groupProgressBar.isVisible();
    }

    public void setAbortable(boolean bl) {
        this.abortButton.setEnabled(bl);
    }

    public void setGroupIndeterminate(boolean bl) {
        this.groupProgressBar.setIndeterminate(bl);
    }

    public void setGroupMaximum(int n) {
        this.groupProgressBar.setMaximum(n);
    }

    public void setGroupValue(int n) {
        this.groupProgressBar.setValue(n);
    }

    public int getGroupValue() {
        return this.groupProgressBar.getValue();
    }

    public void setGroupVisible(boolean bl) {
        this.groupProgressBar.setVisible(bl);
    }

    public int getGroupMaximum() {
        return this.groupProgressBar.getMaximum();
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public void setMaximum(int n) {
        this.progressBar.setMaximum(n);
    }

    public void setMinimum(int n) {
        this.progressBar.setMinimum(n);
    }

    public int getMaximum() {
        return this.progressBar.getMaximum();
    }

    public void setText(String string) {
        this.labelInfo.setText(string);
    }

    public void setConsolePaneVisible(boolean bl) {
        this.scrollPane.setVisible(bl);
        this.closeOnFinish = false;
    }

    public void appendConsoleText(String string) {
        StyledDocument styledDocument = this.consolePane.getStyledDocument();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (string.startsWith("Epoch")) {
            StyleConstants.setForeground(simpleAttributeSet, BreezeColor.DeepSkyBlue);
        } else if (StringHelper.startsWithIgnoreCase((CharSequence)string, (CharSequence)"warn")) {
            StyleConstants.setForeground(simpleAttributeSet, BreezeColor.WarmOrange);
        } else if (StringHelper.startsWithIgnoreCase((CharSequence)string, (CharSequence)"error")) {
            StyleConstants.setForeground(simpleAttributeSet, BreezeColor.Coral);
        } else {
            simpleAttributeSet = null;
        }
        try {
            styledDocument.insertString(styledDocument.getLength(), string + "\n", simpleAttributeSet);
        }
        catch (BadLocationException badLocationException) {
            Logg.debug((String)"", (Object[])new Object[]{badLocationException});
        }
        this.consolePane.setCaretPosition(styledDocument.getLength());
    }

    public void setTouchScreen(Color color) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(color);
        this.centerPanel.setBackground(color);
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder());
        this.southPanel.setBackground(color);
        this.southPanel.setBorder(BorderFactory.createEmptyBorder());
        Font font = this.labelInfo.getFont();
        this.abortButton.setVisible(false);
        this.abortButton.setBackground(color);
        this.abortButton.setForeground(Color.white);
        this.abortButton.setMinimumSize(new Dimension(80, 40));
        this.abortButton.setPreferredSize(new Dimension(80, 40));
        this.abortButton.setMargin(new Insets(0, 0, 0, 0));
        this.abortButton.setFont(new Font(font.getName(), font.getStyle(), 18));
        this.animationPanel.setBackground(color);
        this.animPanel.setBackground(color);
        this.labelInfo.setForeground(breezeTheme.getLabelForeground());
        this.labelInfo.setFont(new Font(font.getName(), font.getStyle(), 16));
        this.progressBar.setMinimumSize(new Dimension(10, 32));
        this.progressBar.setPreferredSize(new Dimension(300, 32));
        this.groupProgressBar.setMinimumSize(new Dimension(10, 32));
        this.groupProgressBar.setPreferredSize(new Dimension(300, 32));
        this.groupProgressBar.setStringPainted(true);
    }

    public void setValue(int n) {
        this.progressBar.setValue(n);
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void setComplete() {
        this.progressBar.setValue(this.progressBar.getMaximum());
    }

    public void start() {
        this.animPanel.start();
    }

    public void stop() {
        if (this.animPanel != null) {
            this.animPanel.stop();
        }
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @Generated
    public JTextPane getConsolePane() {
        return this.consolePane;
    }

    @Generated
    public boolean isCloseOnFinish() {
        return this.closeOnFinish;
    }

    private static class AnimPanel
    extends JPanel
    implements ActionListener {
        private final Timer timer;
        private int index = 0;

        public AnimPanel() {
            this.setPreferredSize(new Dimension(50, 50));
            this.timer = new Timer(50, this);
            this.timer.setInitialDelay(0);
            this.timer.setCoalesce(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.index = (this.index + 1) % progressImages.length;
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            ImageIcon imageIcon = progressImages[this.index];
            int n = this.getWidth() / 2 - 50;
            int n2 = this.getHeight() / 2 - 50;
            imageIcon.paintIcon(this, graphics, n, n2);
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }
    }
}

