/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.LabelEntry;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;

public class BreezeStudyChooserPanel
extends AbstractBreezeCustomPanel {
    private final SelectionList preferredList = new SelectionList("preferredInput");
    private final SelectionList list = new SelectionList("input");

    public BreezeStudyChooserPanel(List<BasicWorkflow> list, Workflow workflow) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(500, 600));
        BreezeLabel breezeLabel = new BreezeLabel();
        breezeLabel.setText("Choose Project to work with:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        this.add((Component)breezeLabel, gridBagConstraints);
        this.preferredList.setOtherList(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.add((Component)this.preferredList, gridBagConstraints);
        this.list.setOtherList(this.preferredList);
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.list, true);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)breezeScrollPane, gridBagConstraints);
        List<BasicWorkflow> list2 = this.getFavorites(list);
        this.preferredList.setBorder(breezeScrollPane.getBorder());
        this.preferredList.setModel(new ArrayListModel(list2));
        list.removeAll(list2);
        this.list.setModel(new ArrayListModel(list));
        if (list2.contains(workflow)) {
            this.preferredList.setSelectedValue(workflow, true);
            SwingUtilities.invokeLater(() -> this.preferredList.requestFocus());
        } else if (list.contains(workflow)) {
            this.list.setSelectedValue(workflow, true);
            SwingUtilities.invokeLater(() -> this.list.requestFocus());
        } else if (list2.size() > 0) {
            this.preferredList.setSelectedIndex(0);
            SwingUtilities.invokeLater(() -> this.preferredList.requestFocus());
        } else if (list.size() > 0) {
            this.list.setSelectedIndex(0);
            SwingUtilities.invokeLater(() -> this.list.requestFocus());
        }
    }

    private List<BasicWorkflow> getFavorites(List<BasicWorkflow> list) {
        ArrayList<BasicWorkflow> arrayList = new ArrayList<BasicWorkflow>();
        String string = BreezeProperties.getInstance().getFavorites();
        for (String string2 : string.split(";")) {
            for (BasicWorkflow basicWorkflow : list) {
                if (!basicWorkflow.getUid().equals(string2)) continue;
                arrayList.add(basicWorkflow);
            }
        }
        return arrayList;
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public Object getResult() {
        Object e = this.preferredList.getSelectedValue();
        if (e != null) {
            return e;
        }
        return this.list.getSelectedValue();
    }

    private class SelectionList
    extends JList {
        private SelectionList otherList;
        private boolean clearingSelection = false;

        public SelectionList(String string) {
            this.setSelectionMode(0);
            this.setName(string);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() > 1) {
                        BreezeStudyChooserPanel.this.okPressed(false);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        BreezeStudyChooserPanel.this.okPressed(false);
                    }
                }
            });
            this.setCellRenderer(new LabelEntry(150, 30, 16, false));
            this.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
                if (!listSelectionEvent.getValueIsAdjusting() && !this.clearingSelection) {
                    this.otherList.clearSelection();
                }
            });
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
            this.setForeground(breezeTheme.getLabelForeground());
        }

        @Override
        public void clearSelection() {
            this.clearingSelection = true;
            super.clearSelection();
            this.clearingSelection = false;
        }

        public void setOtherList(SelectionList selectionList) {
            this.otherList = selectionList;
        }
    }
}

