/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButtonInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeRadioButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.main.play.TutorialManager;

public class BreezeTogglePanel
extends AbstractBreezeCustomPanel {
    private final List<TogglePanel> togglePanelList = new ArrayList<TogglePanel>();
    private final BreezeTextArea descriptionTextArea = new BreezeTextArea("", true);
    private final JPanel customPanel = new JPanel(new BorderLayout());
    private final MethodPanel methodPanel = new MethodPanel();
    private final TabChangedCallBack tabChangedCallBack;
    private TogglePanel togglePanel;
    private final BreezeInputField nameInputField;

    public BreezeTogglePanel() {
        this(null, null, "", null, 0);
    }

    public BreezeTogglePanel(List<ToggleItem> list, BreezeType breezeType, String string, TabChangedCallBack tabChangedCallBack, int n) {
        this.tabChangedCallBack = tabChangedCallBack;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.nameInputField = new BreezeInputField();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.setMinimumSize(new Dimension(0, 60));
        jPanel.setPreferredSize(new Dimension(0, 60));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)jPanel, gridBagConstraints);
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 20);
        this.add((Component)jPanel2, gridBagConstraints);
        this.nameInputField.setUnit("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 20, 20);
        this.add((Component)this.nameInputField, gridBagConstraints);
        this.nameInputField.getTextField().setName("input");
        this.setInputName(string);
        this.descriptionTextArea.setFont(new Font("Tahoma", 0, 18));
        this.descriptionTextArea.setOpaque(false);
        this.descriptionTextArea.setRows(4);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setBorder(BorderFactory.createEmptyBorder());
        this.descriptionTextArea.hideVerticalScrollBar();
        this.descriptionTextArea.hideCaret();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(20, 20, 20, 20);
        jPanel2.add((Component)this.descriptionTextArea, gridBagConstraints2);
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createLineBorder(breezeType.getColor(), 3));
        this.customPanel.setOpaque(false);
        this.customPanel.setVisible(false);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 20, 6, 20);
        jPanel2.add((Component)this.customPanel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 20, 20, 20);
        jPanel2.add((Component)this.methodPanel, gridBagConstraints2);
        this.methodPanel.setChangedListener(object -> {
            if (this.togglePanel != null) {
                this.togglePanel.setType(this.methodPanel.getSelectedItem());
            }
        });
        if (list != null) {
            int n2 = Math.max(600, 200 * list.size());
            this.setPreferredSize(new Dimension(n2, 560));
            for (ToggleItem toggleItem : list) {
                gridBagConstraints2 = new GridBagConstraints();
                gridBagConstraints2.insets = new Insets(20, this.togglePanelList.isEmpty() ? 20 : 0, 0, 20);
                gridBagConstraints2.anchor = 18;
                gridBagConstraints2.fill = 3;
                gridBagConstraints2.gridx = jPanel.getComponentCount();
                final TogglePanel togglePanel = new TogglePanel(toggleItem, breezeType);
                togglePanel.setName(toggleItem.getName());
                jPanel.add((Component)togglePanel, gridBagConstraints2);
                togglePanel.addSelectListener(new MouseAdapter(this){
                    final /* synthetic */ BreezeTogglePanel this$0;
                    {
                        this.this$0 = breezeTogglePanel;
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        this.this$0.setSelectedItem(togglePanel);
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        togglePanel.setHovering(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        togglePanel.setHovering(false);
                    }
                });
                this.togglePanelList.add(togglePanel);
            }
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(20, this.togglePanelList.isEmpty() ? 20 : 0, 0, 20);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.gridx = jPanel.getComponentCount();
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 3;
            JPanel jPanel3 = new JPanel();
            jPanel3.setOpaque(false);
            jPanel.add((Component)jPanel3, gridBagConstraints2);
            if (!this.togglePanelList.isEmpty()) {
                this.setSelectedIndex(n);
            }
        }
    }

    public void setSelectedIndex(int n) {
        this.setSelectedItem(this.togglePanelList.get(n));
    }

    private void setSelectedItem(TogglePanel togglePanel) {
        this.togglePanel = togglePanel;
        for (TogglePanel togglePanel2 : this.togglePanelList) {
            togglePanel2.setSelected(false);
        }
        togglePanel.setSelected(true);
        this.tabChangedCallBack.tabChanged(this, togglePanel.getToggleItem());
    }

    @Override
    public boolean usePreferredSize() {
        return true;
    }

    @Override
    public ToggleItem getResult() {
        for (TogglePanel togglePanel : this.togglePanelList) {
            if (!togglePanel.isSelected()) continue;
            return togglePanel.getToggleItem();
        }
        return null;
    }

    public void setInputName(String string) {
        this.nameInputField.setValue(string);
        this.nameInputField.requestFocusAndSelectAll();
    }

    public String getInputName() {
        return this.nameInputField.getValue();
    }

    public BreezeInputField getNameInputField() {
        return this.nameInputField;
    }

    public BreezeComboBoxInputField getTypeComboBox() {
        return this.methodPanel.getTypeComboBox();
    }

    public Object getType() {
        return this.methodPanel.getSelectedItem();
    }

    public void setSelectedType(String string) {
        this.methodPanel.setSelectedType(string);
    }

    public static interface TabChangedCallBack {
        public void tabChanged(BreezeTogglePanel var1, ToggleItem var2);
    }

    public static class MethodPanel
    extends JPanel {
        private final JPanel filterPanel = new JPanel(new FlowLayout(0));
        private final BreezeComboBoxInputField typeComboBox = new BreezeComboBoxInputField("Method");
        private final BreezeExternalLinkPanel typeHelpPanel = new BreezeExternalLinkPanel((JComponent)this.typeComboBox, "", false, true);

        public MethodPanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.typeHelpPanel, gridBagConstraints);
            Dimension dimension = new Dimension(100, 30);
            this.typeComboBox.setMinimumSize(dimension);
            this.typeComboBox.setPreferredSize(dimension);
            this.typeComboBox.setChangedListener((T object) -> {
                if (object instanceof TutorialManager.TutorialData) {
                    TutorialManager.TutorialData tutorialData = (TutorialManager.TutorialData)object;
                    this.typeHelpPanel.setHelpSite(tutorialData.getHelpSite());
                }
            });
            this.typeComboBox.setRenderer(new BreezeComboBox.ComboBoxListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    return super.getListCellRendererComponent(jList, (Object)this.formatItem(object), n, bl, bl2);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 2, 0);
            this.add((Component)this.filterPanel, gridBagConstraints);
            this.filterPanel.setOpaque(false);
        }

        public void setSelectedType(String string) {
            for (int i = 0; i < this.typeComboBox.getItemCount(); ++i) {
                if (!this.formatItem(this.typeComboBox.getItemAt(i)).equals(string)) continue;
                this.typeComboBox.setSelectedIndex(i);
                return;
            }
        }

        private String formatItem(Object object) {
            if (object == null) {
                return null;
            }
            String string = object.toString();
            if (object instanceof BasicAnalyse.ModelMethod) {
                string = StringHelper.formatLabel(((BasicAnalyse.ModelMethod)((Object)object)).getMethod());
            }
            return string;
        }

        public void setSelectedItem(ToggleItem toggleItem) {
            final List<Object> list = toggleItem.getTypes();
            List<String> list2 = this.getGroups(list);
            this.filterPanel.removeAll();
            if (list2.size() > 0) {
                ButtonGroup buttonGroup = new ButtonGroup();
                BreezeRadioButton.RadioButtonCallback radioButtonCallback = new BreezeRadioButton.RadioButtonCallback(){
                    final /* synthetic */ MethodPanel this$0;
                    {
                        this.this$0 = methodPanel;
                    }

                    @Override
                    public void selected(BreezeRadioButton breezeRadioButton, boolean bl) {
                        this.this$0.typeComboBox.setItems(this.getItemsFromGroup(list, breezeRadioButton.getText()));
                    }

                    private List getItemsFromGroup(List<Object> list2, String string) {
                        if (string.equalsIgnoreCase("All")) {
                            return list2;
                        }
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (Object object : list2) {
                            AbstractBreezeFunctionInfo abstractBreezeFunctionInfo;
                            AbstractCardInfo.GroupType groupType;
                            if (!(object instanceof AbstractBreezeFunctionInfo) || (groupType = (abstractBreezeFunctionInfo = (AbstractBreezeFunctionInfo)object).getGroup()) == null || !string.equals(groupType.name())) continue;
                            arrayList.add(object);
                        }
                        return arrayList;
                    }
                };
                this.filterPanel.add(new BreezeLabel("Filter:", false, 14));
                this.filterPanel.add(new FilterRadioButton("All", buttonGroup, true, radioButtonCallback));
                for (String string : list2) {
                    this.filterPanel.add(new FilterRadioButton(string, buttonGroup, false, radioButtonCallback));
                }
            }
            this.filterPanel.setVisible(this.filterPanel.getComponentCount() > 0);
            this.typeComboBox.setDescription(toggleItem.getTypeName());
            this.typeComboBox.setItems(list);
            this.typeComboBox.setEnabled(this.typeComboBox.getItemCount() > 1);
            this.typeHelpPanel.setVisible(list != null);
        }

        private List<String> getGroups(List<Object> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null) {
                for (Object object : list) {
                    String string;
                    AbstractBreezeFunctionInfo abstractBreezeFunctionInfo;
                    AbstractCardInfo.GroupType groupType;
                    if (!(object instanceof AbstractBreezeFunctionInfo) || (groupType = (abstractBreezeFunctionInfo = (AbstractBreezeFunctionInfo)object).getGroup()) == null || (string = groupType.name()) == null || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            return arrayList;
        }

        public Object getSelectedItem() {
            return this.typeComboBox.getSelectedItem();
        }

        public void setChangedListener(BreezeComboBoxInputField.SelectionChangedListener selectionChangedListener) {
            this.typeComboBox.setChangedListener(selectionChangedListener);
        }

        public BreezeComboBoxInputField getTypeComboBox() {
            return this.typeComboBox;
        }

        private static class FilterRadioButton
        extends BreezeRadioButton {
            public FilterRadioButton(String string, ButtonGroup buttonGroup, boolean bl, BreezeRadioButton.RadioButtonCallback radioButtonCallback) {
                super(string, buttonGroup, bl, radioButtonCallback);
                this.setFont(new Font(this.getFont().getFontName(), 0, 14));
            }
        }
    }

    public static class ToggleItem<T> {
        private final String name;
        private final String description;
        private final String typeName;
        private final List<T> types;
        private final String iconName;

        public ToggleItem(String string, String string2) {
            this(string, string2, "", null, null);
        }

        public ToggleItem(String string, String string2, String string3) {
            this(string, string2, "", string3, null);
        }

        public ToggleItem(String string, String string2, String string3, List<T> list) {
            this(string, string2, string3, null, list);
        }

        public ToggleItem(String string, String string2, String string3, String string4, List<T> list) {
            this.name = string;
            this.description = string2;
            this.typeName = string3;
            this.iconName = string4;
            this.types = list;
        }

        public String getName() {
            return this.name;
        }

        public List<T> getTypes() {
            return this.types;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDescription(Object object) {
            return this.getDescription();
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getIconName() {
            return this.iconName;
        }

        public JComponent getCustom() {
            return null;
        }
    }

    public class TogglePanel
    extends BreezeGradientPanel
    implements BreezeButtonInterface {
        private final ToggleItem toggleItem;
        private final BreezeLabel headerLabel = new BreezeLabel();
        private final Color[] colorNormal;
        private final Color[] colorHover;
        private final Color[] colorSelected;
        private boolean selected = false;
        private boolean hovering = false;
        private final ImageIcon icon;
        private final ImageIcon selectedIcon;

        public TogglePanel(ToggleItem toggleItem, BreezeType breezeType) {
            this.toggleItem = toggleItem;
            Color color = breezeType.getColor();
            Color color2 = BreezeTheme.getInstance().getPlotGridColor();
            this.colorNormal = new Color[]{color2, color2, color2};
            this.colorHover = new Color[]{color2, color2, color2};
            this.colorSelected = new Color[]{color, color, color};
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.headerLabel.setText(toggleItem.getName());
            this.headerLabel.setIconTextGap(5);
            this.icon = ImageHelper.getResourceIcon(toggleItem.getIconName());
            this.selectedIcon = ImageHelper.changeGrayBrightness(this.icon, 100);
            this.headerLabel.setIcon(this.icon);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, this.icon != null ? 10 : 20, 0, 20);
            this.add((Component)this.headerLabel, gridBagConstraints);
            this.updateColors();
        }

        public void setHovering(boolean bl) {
            this.hovering = bl;
            this.updateColors();
        }

        public synchronized void addSelectListener(MouseListener mouseListener) {
            super.addMouseListener(mouseListener);
            this.headerLabel.addMouseListener(mouseListener);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            BreezeTogglePanel.this.descriptionTextArea.setText(this.toggleItem.getDescription());
            BreezeTogglePanel.this.methodPanel.setSelectedItem(this.toggleItem);
            BreezeTogglePanel.this.customPanel.removeAll();
            JComponent jComponent = this.toggleItem.getCustom();
            if (jComponent != null) {
                BreezeTogglePanel.this.customPanel.add((Component)jComponent, "Center");
            }
            BreezeTogglePanel.this.customPanel.revalidate();
            BreezeTogglePanel.this.customPanel.setVisible(jComponent != null);
            this.selected = bl;
            this.updateColors();
        }

        public void setType(Object object) {
            BreezeTogglePanel.this.descriptionTextArea.setText(this.toggleItem.getDescription(object));
        }

        private void updateColors() {
            Color[] colorArray = this.selected ? this.colorSelected : (this.hovering ? this.colorHover : this.colorNormal);
            this.setForeground(colorArray[1]);
            this.setBackground(colorArray[2]);
            this.headerLabel.setForeground(this.selected ? Color.white : BreezeTheme.getInstance().getLabelForegroundDifuse());
            this.headerLabel.setIcon(this.selected ? this.selectedIcon : this.icon);
            this.setBorder(BorderFactory.createLineBorder(colorArray[0]));
        }

        public ToggleItem getToggleItem() {
            return this.toggleItem;
        }

        @Override
        public void doClick() {
            for (MouseListener mouseListener : this.getMouseListeners()) {
                mouseListener.mousePressed(null);
            }
        }
    }
}

